/*
 * Decompiled with CFR 0.152.
 */
package ca.krasnay.sqlbuilder.orm;

import ca.krasnay.sqlbuilder.DeleteCreator;
import ca.krasnay.sqlbuilder.InsertCreator;
import ca.krasnay.sqlbuilder.Predicate;
import ca.krasnay.sqlbuilder.SelectCreator;
import ca.krasnay.sqlbuilder.UpdateCreator;
import ca.krasnay.sqlbuilder.orm.Column;
import ca.krasnay.sqlbuilder.orm.Converter;
import ca.krasnay.sqlbuilder.orm.OptimisticLockException;
import ca.krasnay.sqlbuilder.orm.OrmConfig;
import ca.krasnay.sqlbuilder.orm.ReflectionUtils;
import ca.krasnay.sqlbuilder.orm.RowNotFoundException;
import ca.krasnay.sqlbuilder.orm.SingleResultException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;

public class Mapping<T> {
    public static final long NULL_ID = 0L;
    private OrmConfig ormConfig;
    private Class<T> clazz;
    private String table;
    private Column idColumn;
    private Column versionColumn;
    private List<Column> columns = new ArrayList<Column>();
    private List<String> ignoredFields = new ArrayList<String>();

    public Mapping(OrmConfig ormConfig, Class<T> clazz, String table) {
        this.ormConfig = ormConfig;
        this.clazz = clazz;
        this.table = table;
    }

    public Mapping<T> addColumn(Column column) {
        this.columns.add(column);
        return this;
    }

    public Mapping<T> addColumn(String fieldName) {
        this.addColumn(new Column(fieldName));
        return this;
    }

    public Mapping<T> addColumn(String fieldName, String columnName) {
        this.addColumn(new Column(fieldName, columnName));
        return this;
    }

    public Mapping<T> addColumn(String fieldName, Converter<?> converter) {
        this.addColumn(new Column(fieldName, converter));
        return this;
    }

    public Mapping<T> addColumn(String fieldName, String columnName, Converter<?> converter) {
        this.addColumn(new Column(fieldName, columnName, converter));
        return this;
    }

    public Mapping<T> addFields() {
        if (this.idColumn == null) {
            throw new RuntimeException("Map ID column before adding class fields");
        }
        for (Field f : ReflectionUtils.getDeclaredFieldsInHierarchy(this.clazz)) {
            if (Modifier.isStatic(f.getModifiers()) || this.isFieldMapped(f.getName()) || this.ignoredFields.contains(f.getName())) continue;
            this.addColumn(f.getName());
        }
        return this;
    }

    public Delete beginDelete() {
        return new Delete();
    }

    protected T createInstance() {
        try {
            Constructor<T> ctor = this.clazz.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return ctor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Query createQuery() {
        return new Query();
    }

    public void deleteById(Object id) {
        int count = this.beginDelete().whereEquals(this.idColumn.getColumnName(), id).delete();
        if (count == 0) {
            throw new RowNotFoundException(this.table, id);
        }
    }

    public T findById(Object id) throws RowNotFoundException {
        List result = this.createQuery().whereEquals(this.idColumn.getColumnName(), id).getResultList();
        if (result.size() == 0) {
            throw new RowNotFoundException(this.table, id);
        }
        return result.get(0);
    }

    private Converter<?> getConverter(Column column) {
        if (column.getConverter() != null) {
            return column.getConverter();
        }
        Field field = ReflectionUtils.getDeclaredFieldWithPath(this.clazz, column.getFieldName());
        return this.ormConfig.getConverterFactory().getConverter(field.getType());
    }

    public Column getIdColumn() {
        return this.idColumn;
    }

    private Object getFieldValueAsColumn(T entity, Column column) {
        Object fieldValue = ReflectionUtils.getFieldValueWithPath(entity, column.getFieldName());
        Converter<?> converter = this.getConverter(column);
        return converter.convertFieldValueToColumn(fieldValue);
    }

    public Object getPrimaryKey(T entity) {
        return ReflectionUtils.getFieldValue(entity, this.idColumn.getFieldName());
    }

    public String getTable() {
        return this.table;
    }

    private int getVersion(T entity) {
        Object value = ReflectionUtils.getFieldValue(entity, this.versionColumn.getFieldName());
        return ((Number)value).intValue();
    }

    public Mapping<T> ignoreField(String fieldName) {
        this.ignoredFields.add(fieldName);
        return this;
    }

    public T insert(T entity) {
        if (this.isPersistent(entity)) {
            throw new RuntimeException(String.format("Tried to insert object of type %s with existing id %d", entity.getClass().getSimpleName(), this.getPrimaryKey(entity)));
        }
        Object id = this.ormConfig.getIdSourceFactory().getIdSource(this.ormConfig.getDataSource(), this).nextId();
        InsertCreator insert = new InsertCreator(this.table);
        insert.setValue(this.idColumn.getColumnName(), id);
        if (this.versionColumn != null) {
            insert.setValue(this.versionColumn.getColumnName(), 0);
        }
        for (Column column : this.columns) {
            insert.setValue(column.getColumnName(), this.getFieldValueAsColumn(entity, column));
        }
        new JdbcTemplate(this.ormConfig.getDataSource()).update((PreparedStatementCreator)insert);
        ReflectionUtils.setFieldValue(entity, this.idColumn.getFieldName(), id);
        if (this.versionColumn != null) {
            ReflectionUtils.setFieldValue(entity, this.versionColumn.getFieldName(), 0);
        }
        return entity;
    }

    private boolean isFieldMapped(String fieldName) {
        if (fieldName.equals(this.idColumn.getFieldName())) {
            return true;
        }
        if (this.versionColumn != null && fieldName.equals(this.versionColumn.getFieldName())) {
            return true;
        }
        for (Column column : this.columns) {
            if (!column.getFieldName().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    public boolean isPersistent(T entity) {
        Object pk = this.getPrimaryKey(entity);
        if (pk == null) {
            return false;
        }
        return !(pk instanceof Number) || ((Number)pk).longValue() != 0L;
    }

    public void setFieldValueFromResultSet(T entity, ResultSet rs, Column column) {
        try {
            Converter<?> converter = this.getConverter(column);
            Object fieldValue = converter.getFieldValueFromResultSet(rs, column.getColumnName());
            ReflectionUtils.setFieldValueWithPath(entity, column.getFieldName(), fieldValue);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Mapping<T> setIdColumn(Column idColumn) {
        this.idColumn = idColumn;
        return this;
    }

    public Mapping<T> setIdColumn(String idColumnName) {
        this.idColumn = new Column(idColumnName);
        return this;
    }

    public Mapping<T> setVersionColumn(Column versionColumn) {
        this.versionColumn = versionColumn;
        return this;
    }

    public Mapping<T> setVersionColumn(String versionColumnName) {
        this.versionColumn = new Column(versionColumnName);
        return this;
    }

    public T update(T entity) throws RowNotFoundException, OptimisticLockException {
        if (!this.isPersistent(entity)) {
            throw new RuntimeException(String.format("Tried to update non-persistent object of type %s", entity.getClass().getSimpleName()));
        }
        UpdateCreator update = new UpdateCreator(this.table);
        update.whereEquals(this.idColumn.getColumnName(), this.getPrimaryKey(entity));
        if (this.versionColumn != null) {
            update.set(this.versionColumn.getColumnName() + " = " + this.versionColumn.getColumnName() + " + 1");
            update.whereEquals(this.versionColumn.getColumnName(), this.getVersion(entity));
        }
        for (Column column : this.columns) {
            update.setValue(column.getColumnName(), this.getFieldValueAsColumn(entity, column));
        }
        int rows = new JdbcTemplate(this.ormConfig.getDataSource()).update((PreparedStatementCreator)update);
        if (rows == 1) {
            if (this.versionColumn != null) {
                ReflectionUtils.setFieldValue(entity, this.versionColumn.getFieldName(), this.getVersion(entity) + 1);
            }
            return entity;
        }
        if (rows > 1) {
            throw new RuntimeException(String.format("Updating table %s with id %s updated %d rows. There must be a mapping problem. Is column %s really the primary key?", this.table, this.getPrimaryKey(entity), rows, this.idColumn));
        }
        SelectCreator selectById = new SelectCreator().column("count(*)").from(this.table).whereEquals(this.idColumn.getColumnName(), this.getPrimaryKey(entity));
        rows = (Integer)new JdbcTemplate(this.ormConfig.getDataSource()).query((PreparedStatementCreator)selectById, (ResultSetExtractor)new ResultSetExtractor<Integer>(){

            public Integer extractData(ResultSet rs) throws SQLException, DataAccessException {
                rs.next();
                return rs.getInt(1);
            }
        });
        if (rows == 0) {
            throw new RowNotFoundException(this.table, this.getPrimaryKey(entity));
        }
        throw new OptimisticLockException(this.table, this.getPrimaryKey(entity));
    }

    public class Query {
        private SelectCreator select;

        private Query() {
            this.select = new SelectCreator().from(Mapping.this.table);
        }

        public Query and(Predicate predicate) {
            return this.where(predicate);
        }

        public Query and(String expr) {
            return this.where(expr);
        }

        public Query forUpdate() {
            this.select.forUpdate();
            return this;
        }

        public List<T> getResultList() {
            this.select.column(Mapping.this.idColumn.getColumnName());
            if (Mapping.this.versionColumn != null) {
                this.select.column(Mapping.this.versionColumn.getColumnName());
            }
            for (Column column : Mapping.this.columns) {
                this.select.column(column.getColumnName());
            }
            return new JdbcTemplate(Mapping.this.ormConfig.getDataSource()).query((PreparedStatementCreator)this.select, new RowMapper<T>(){

                public T mapRow(ResultSet rs, int row) throws SQLException {
                    Object result = Mapping.this.createInstance();
                    Mapping.this.setFieldValueFromResultSet(result, rs, Mapping.this.idColumn);
                    if (Mapping.this.versionColumn != null) {
                        Mapping.this.setFieldValueFromResultSet(result, rs, Mapping.this.versionColumn);
                    }
                    for (Column column : Mapping.this.columns) {
                        Mapping.this.setFieldValueFromResultSet(result, rs, column);
                    }
                    return result;
                }
            });
        }

        public T getSingleResult() throws SingleResultException {
            List results = this.getResultList();
            if (results.size() == 1) {
                return results.get(0);
            }
            throw new SingleResultException(results.size(), this.select);
        }

        public T getSingleResultOrNull() throws SingleResultException {
            List results = this.getResultList();
            if (results.size() == 1) {
                return results.get(0);
            }
            if (results.size() == 0) {
                return null;
            }
            throw new SingleResultException(results.size(), this.select);
        }

        public Query orderBy(String expr) {
            this.select.orderBy(expr);
            return this;
        }

        public Query orderBy(String expr, boolean ascending) {
            this.select.orderBy(expr, ascending);
            return this;
        }

        public Query noWait() {
            this.select.noWait();
            return this;
        }

        public Query setParameter(String name, Object value) {
            this.select.setParameter(name, value);
            return this;
        }

        public Query where(Predicate predicate) {
            this.select.where(predicate);
            return this;
        }

        public Query where(String expr) {
            this.select.where(expr);
            return this;
        }

        public Query whereEquals(String expr, Object value) {
            this.select.whereEquals(expr, value);
            return this;
        }
    }

    public class Delete {
        private DeleteCreator delete;

        private Delete() {
            this.delete = new DeleteCreator(Mapping.this.table);
        }

        public Delete and(String expr) {
            return this.where(expr);
        }

        public Delete and(Predicate predicate) {
            return this.where(predicate);
        }

        public int delete() {
            return new JdbcTemplate(Mapping.this.ormConfig.getDataSource()).update((PreparedStatementCreator)this.delete);
        }

        public Delete where(String expr) {
            this.delete.where(expr);
            return this;
        }

        public Delete where(Predicate predicate) {
            this.delete.where(predicate);
            return this;
        }

        public Delete whereEquals(String expr, Object value) {
            this.delete.whereEquals(expr, value);
            return this;
        }
    }
}

