/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.BeanUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.hl7.fhir.instance.model.IBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRuntimeDeclaredChildDefinition
extends BaseRuntimeChildDefinition {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseRuntimeDeclaredChildDefinition.class);
    private Boolean ourUseMethodAccessors;
    private final BaseRuntimeChildDefinition.IAccessor myAccessor;
    private final String myElementName;
    private final Field myField;
    private final String myFormalDefinition;
    private final int myMax;
    private final int myMin;
    private final BaseRuntimeChildDefinition.IMutator myMutator;
    private final String myShortDefinition;

    BaseRuntimeDeclaredChildDefinition(Field theField, Child theChildAnnotation, Description theDescriptionAnnotation, String theElementName) throws ConfigurationException {
        if (theField == null) {
            throw new IllegalArgumentException("No field speficied");
        }
        if (theChildAnnotation.min() < 0) {
            throw new ConfigurationException("Min must be >= 0");
        }
        if (theChildAnnotation.max() != -1 && theChildAnnotation.max() < theChildAnnotation.min()) {
            throw new ConfigurationException("Max must be >= Min (unless it is -1 / unlimited)");
        }
        if (StringUtils.isBlank((CharSequence)theElementName)) {
            throw new ConfigurationException("Element name must not be blank");
        }
        this.myField = theField;
        this.myMin = theChildAnnotation.min();
        this.myMax = theChildAnnotation.max();
        this.myElementName = theElementName;
        if (theDescriptionAnnotation != null) {
            this.myShortDefinition = theDescriptionAnnotation.shortDefinition();
            this.myFormalDefinition = theDescriptionAnnotation.formalDefinition();
        } else {
            this.myShortDefinition = null;
            this.myFormalDefinition = null;
        }
        if (this.ourUseMethodAccessors == null) {
            try {
                this.myField.setAccessible(true);
                this.ourUseMethodAccessors = false;
            }
            catch (SecurityException e) {
                ourLog.info("Can not use field accessors/mutators, going to use methods instead");
                this.ourUseMethodAccessors = true;
            }
        }
        if (!this.ourUseMethodAccessors.booleanValue()) {
            if (List.class.equals(this.myField.getType())) {
                this.myAccessor = new FieldListAccessor();
                this.myMutator = new FieldListMutator();
            } else {
                this.myAccessor = new FieldPlainAccessor();
                this.myMutator = new FieldPlainMutator();
            }
        } else {
            Class<?> declaringClass = this.myField.getDeclaringClass();
            Class<?> targetReturnType = this.myField.getType();
            try {
                Method accessor;
                String elementName = this.myElementName;
                if ("class".equals(elementName.toLowerCase())) {
                    elementName = "classElement";
                }
                if ((accessor = BeanUtils.findAccessor(declaringClass, targetReturnType, elementName)) == null) {
                    throw new ConfigurationException("Could not find bean accessor/getter for property " + elementName + " on class " + declaringClass.getCanonicalName());
                }
                Method mutator = BaseRuntimeDeclaredChildDefinition.findMutator(declaringClass, targetReturnType, elementName);
                if (mutator == null) {
                    throw new ConfigurationException("Could not find bean mutator/setter for property " + elementName + " on class " + declaringClass.getCanonicalName() + " (expected return type " + targetReturnType.getCanonicalName() + ")");
                }
                if (List.class.isAssignableFrom(targetReturnType)) {
                    this.myAccessor = new ListAccessor(accessor);
                    this.myMutator = new ListMutator(mutator);
                } else {
                    this.myAccessor = new PlainAccessor(accessor);
                    this.myMutator = new PlainMutator(targetReturnType, mutator);
                }
            }
            catch (NoSuchFieldException e) {
                throw new ConfigurationException(e);
            }
        }
    }

    @Override
    public BaseRuntimeChildDefinition.IAccessor getAccessor() {
        return this.myAccessor;
    }

    @Override
    public String getElementName() {
        return this.myElementName;
    }

    public Field getField() {
        return this.myField;
    }

    public String getFormalDefinition() {
        return this.myFormalDefinition;
    }

    @Override
    public int getMax() {
        return this.myMax;
    }

    @Override
    public int getMin() {
        return this.myMin;
    }

    @Override
    public BaseRuntimeChildDefinition.IMutator getMutator() {
        return this.myMutator;
    }

    public String getShortDefinition() {
        return this.myShortDefinition;
    }

    public BaseRuntimeElementDefinition<?> getSingleChildOrThrow() {
        if (this.getValidChildNames().size() != 1) {
            throw new IllegalStateException("This child has " + this.getValidChildNames().size() + " children, expected 1. This is a HAPI bug. Found: " + this.getValidChildNames());
        }
        return this.getChildByName(this.getValidChildNames().iterator().next());
    }

    private static Method findMutator(Class<?> theDeclaringClass, Class<?> theTargetReturnType, String theElementName) {
        String methodName = "set" + WordUtils.capitalize((String)theElementName);
        try {
            return theDeclaringClass.getMethod(methodName, theTargetReturnType);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            throw new ConfigurationException("Failed to scan class '" + theDeclaringClass + "' because of a security exception", e);
        }
    }

    private final class PlainMutator
    implements BaseRuntimeChildDefinition.IMutator {
        private final Method myMutatorMethod;
        private final Class<?> myTargetReturnType;

        private PlainMutator(Class<?> theTargetReturnType, Method theMutator) {
            assert (theTargetReturnType != null);
            assert (theMutator != null);
            this.myTargetReturnType = theTargetReturnType;
            this.myMutatorMethod = theMutator;
        }

        @Override
        public void addValue(Object theTarget, IBase theValue) {
            try {
                if (theValue != null && !this.myTargetReturnType.isAssignableFrom(theValue.getClass())) {
                    throw new ConfigurationException("Value for field " + BaseRuntimeDeclaredChildDefinition.this.myElementName + " expects type " + this.myTargetReturnType + " but got " + theValue.getClass());
                }
                this.myMutatorMethod.invoke(theTarget, theValue);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Failed to get value", e);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Failed to get value", e);
            }
            catch (InvocationTargetException e) {
                throw new ConfigurationException("Failed to get value", e);
            }
        }
    }

    private final class PlainAccessor
    implements BaseRuntimeChildDefinition.IAccessor {
        private final Method myAccessorMethod;

        private PlainAccessor(Method theAccessor) {
            this.myAccessorMethod = theAccessor;
        }

        @Override
        public List<IBase> getValues(Object theTarget) {
            try {
                return Collections.singletonList((IBase)this.myAccessorMethod.invoke(theTarget, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Failed to get value", e);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Failed to get value", e);
            }
            catch (InvocationTargetException e) {
                throw new ConfigurationException("Failed to get value", e);
            }
        }
    }

    private final class ListMutator
    implements BaseRuntimeChildDefinition.IMutator {
        private final Method myMutatorMethod;

        private ListMutator(Method theMutator) {
            this.myMutatorMethod = theMutator;
        }

        @Override
        public void addValue(Object theTarget, IBase theValue) {
            List<IBase> existingList = BaseRuntimeDeclaredChildDefinition.this.myAccessor.getValues(theTarget);
            if (existingList == null) {
                existingList = new ArrayList<IBase>();
                try {
                    this.myMutatorMethod.invoke(theTarget, existingList);
                }
                catch (IllegalAccessException e) {
                    throw new ConfigurationException("Failed to get value", e);
                }
                catch (IllegalArgumentException e) {
                    throw new ConfigurationException("Failed to get value", e);
                }
                catch (InvocationTargetException e) {
                    throw new ConfigurationException("Failed to get value", e);
                }
            }
            existingList.add(theValue);
        }
    }

    private static final class ListAccessor
    implements BaseRuntimeChildDefinition.IAccessor {
        private final Method myAccessorMethod;

        private ListAccessor(Method theAccessor) {
            this.myAccessorMethod = theAccessor;
        }

        @Override
        public List<IBase> getValues(Object theTarget) {
            try {
                return (List)this.myAccessorMethod.invoke(theTarget, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Failed to get value", e);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Failed to get value", e);
            }
            catch (InvocationTargetException e) {
                throw new ConfigurationException("Failed to get value", e);
            }
        }
    }

    private final class FieldListAccessor
    implements BaseRuntimeChildDefinition.IAccessor {
        private FieldListAccessor() {
        }

        @Override
        public List<IBase> getValues(Object theTarget) {
            List<IBase> retVal;
            try {
                retVal = (List<IBase>)BaseRuntimeDeclaredChildDefinition.this.myField.get(theTarget);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Failed to get value", e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Failed to get value", e);
            }
            if (retVal == null) {
                retVal = Collections.emptyList();
            }
            return retVal;
        }
    }

    private final class FieldListMutator
    implements BaseRuntimeChildDefinition.IMutator {
        private FieldListMutator() {
        }

        @Override
        public void addValue(Object theTarget, IBase theValue) {
            try {
                ArrayList<IBase> existingList = (ArrayList<IBase>)BaseRuntimeDeclaredChildDefinition.this.myField.get(theTarget);
                if (existingList == null) {
                    existingList = new ArrayList<IBase>(2);
                    BaseRuntimeDeclaredChildDefinition.this.myField.set(theTarget, existingList);
                }
                existingList.add(theValue);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Failed to set value", e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Failed to set value", e);
            }
        }
    }

    private final class FieldPlainAccessor
    implements BaseRuntimeChildDefinition.IAccessor {
        private FieldPlainAccessor() {
        }

        @Override
        public List<IBase> getValues(Object theTarget) {
            try {
                Object values = BaseRuntimeDeclaredChildDefinition.this.myField.get(theTarget);
                if (values == null) {
                    return Collections.emptyList();
                }
                List<IBase> retVal = Collections.singletonList((IBase)values);
                return retVal;
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Failed to get value", e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Failed to get value", e);
            }
        }
    }

    private final class FieldPlainMutator
    implements BaseRuntimeChildDefinition.IMutator {
        private FieldPlainMutator() {
        }

        @Override
        public void addValue(Object theTarget, IBase theValue) {
            try {
                BaseRuntimeDeclaredChildDefinition.this.myField.set(theTarget, theValue);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Failed to set value", e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Failed to set value", e);
            }
        }
    }
}

