/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeChildDeclaredExtensionDefinition;
import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.IBase;
import org.hl7.fhir.instance.model.api.IBaseEnumFactory;

public abstract class BaseRuntimeElementDefinition<T extends IBase> {
    private String myName;
    private Class<? extends T> myImplementingClass;
    private List<RuntimeChildDeclaredExtensionDefinition> myExtensions = new ArrayList<RuntimeChildDeclaredExtensionDefinition>();
    private Map<String, RuntimeChildDeclaredExtensionDefinition> myUrlToExtension = new HashMap<String, RuntimeChildDeclaredExtensionDefinition>();
    private List<RuntimeChildDeclaredExtensionDefinition> myExtensionsModifier = new ArrayList<RuntimeChildDeclaredExtensionDefinition>();
    private List<RuntimeChildDeclaredExtensionDefinition> myExtensionsNonModifier = new ArrayList<RuntimeChildDeclaredExtensionDefinition>();

    public BaseRuntimeElementDefinition(String theName, Class<? extends T> theImplementingClass) {
        assert (StringUtils.isNotBlank((CharSequence)theName));
        assert (theImplementingClass != null);
        this.myName = theName;
        if (this.myName.endsWith("Dt")) {
            this.myName = this.myName.substring(0, this.myName.length() - 2);
        }
        this.myImplementingClass = theImplementingClass;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    public void addExtension(RuntimeChildDeclaredExtensionDefinition theExtension) {
        if (theExtension == null) {
            throw new NullPointerException();
        }
        this.myExtensions.add(theExtension);
    }

    public List<RuntimeChildDeclaredExtensionDefinition> getExtensions() {
        return this.myExtensions;
    }

    public List<RuntimeChildDeclaredExtensionDefinition> getExtensionsModifier() {
        return this.myExtensionsModifier;
    }

    public List<RuntimeChildDeclaredExtensionDefinition> getExtensionsNonModifier() {
        return this.myExtensionsNonModifier;
    }

    public RuntimeChildDeclaredExtensionDefinition getDeclaredExtension(String theExtensionUrl) {
        return this.myUrlToExtension.get(theExtensionUrl);
    }

    public String getName() {
        return this.myName;
    }

    public T newInstance() {
        return this.newInstance(null);
    }

    public T newInstance(Object theArgument) {
        try {
            if (theArgument == null) {
                return (T)((IBase)this.getImplementingClass().newInstance());
            }
            if (theArgument instanceof IValueSetEnumBinder) {
                return (T)((IBase)this.getImplementingClass().getConstructor(IValueSetEnumBinder.class).newInstance(theArgument));
            }
            return (T)((IBase)this.getImplementingClass().getConstructor(IBaseEnumFactory.class).newInstance(theArgument));
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("Failed to instantiate type:" + this.getImplementingClass().getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Failed to instantiate type:" + this.getImplementingClass().getName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Failed to instantiate type:" + this.getImplementingClass().getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException("Failed to instantiate type:" + this.getImplementingClass().getName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("Failed to instantiate type:" + this.getImplementingClass().getName(), e);
        }
        catch (SecurityException e) {
            throw new ConfigurationException("Failed to instantiate type:" + this.getImplementingClass().getName(), e);
        }
    }

    public Class<? extends T> getImplementingClass() {
        return this.myImplementingClass;
    }

    void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        for (BaseRuntimeChildDefinition baseRuntimeChildDefinition : this.myExtensions) {
            baseRuntimeChildDefinition.sealAndInitialize(theContext, theClassToElementDefinitions);
        }
        for (RuntimeChildDeclaredExtensionDefinition runtimeChildDeclaredExtensionDefinition : this.myExtensions) {
            String extUrl = runtimeChildDeclaredExtensionDefinition.getExtensionUrl();
            if (this.myUrlToExtension.containsKey(extUrl)) {
                throw new ConfigurationException("Duplicate extension URL[" + extUrl + "] in Element[" + this.getName() + "]");
            }
            this.myUrlToExtension.put(extUrl, runtimeChildDeclaredExtensionDefinition);
            if (runtimeChildDeclaredExtensionDefinition.isModifier()) {
                this.myExtensionsModifier.add(runtimeChildDeclaredExtensionDefinition);
                continue;
            }
            this.myExtensionsNonModifier.add(runtimeChildDeclaredExtensionDefinition);
        }
        this.myExtensions = Collections.unmodifiableList(this.myExtensions);
    }

    public abstract ChildTypeEnum getChildType();

    public static enum ChildTypeEnum {
        COMPOSITE_DATATYPE,
        PRIMITIVE_DATATYPE,
        RESOURCE,
        RESOURCE_REF,
        RESOURCE_BLOCK,
        PRIMITIVE_XHTML,
        UNDECL_EXT,
        EXTENSION_DECLARED,
        CONTAINED_RESOURCES;

    }
}

