/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.model.api.IFhirVersion;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;

public enum FhirVersionEnum {
    DSTU1("ca.uhn.fhir.model.dstu.FhirDstu1", null),
    DSTU2("ca.uhn.fhir.model.dstu2.FhirDstu2", null),
    DEV("ca.uhn.fhir.model.dev.FhirDev", null),
    DSTU2_HL7ORG("org.hl7.fhir.instance.FhirDstu2Hl7Org", null);

    private final String myVersionClass;
    private final FhirVersionEnum myEquivalent;
    private volatile Boolean myPresentOnClasspath;
    private volatile IFhirVersion myVersionImplementation;

    private FhirVersionEnum(String theVersionClass, FhirVersionEnum theEquivalent) {
        this.myVersionClass = theVersionClass;
        this.myEquivalent = theEquivalent;
    }

    public boolean isEquivalentTo(FhirVersionEnum theVersion) {
        if (this.equals((Object)theVersion)) {
            return true;
        }
        if (this.myEquivalent != null) {
            return this.myEquivalent.equals((Object)theVersion);
        }
        return false;
    }

    public boolean isNewerThan(FhirVersionEnum theVersion) {
        return this.ordinal() > theVersion.ordinal();
    }

    public boolean isPresentOnClasspath() {
        Boolean retVal = this.myPresentOnClasspath;
        if (retVal == null) {
            try {
                Class.forName(this.myVersionClass);
                retVal = true;
            }
            catch (Exception e) {
                retVal = false;
            }
            this.myPresentOnClasspath = retVal;
        }
        return retVal;
    }

    public IFhirVersion getVersionImplementation() {
        if (!this.isPresentOnClasspath()) {
            throw new IllegalStateException("Version " + this.name() + " is not present on classpath");
        }
        if (this.myVersionImplementation == null) {
            try {
                this.myVersionImplementation = (IFhirVersion)Class.forName(this.myVersionClass).newInstance();
            }
            catch (Exception e) {
                throw new InternalErrorException("Failed to instantiate FHIR version " + this.name(), (Throwable)e);
            }
        }
        return this.myVersionImplementation;
    }
}

