/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeChildAny;
import ca.uhn.fhir.context.RuntimeChildChoiceDefinition;
import ca.uhn.fhir.context.RuntimeChildCompositeBoundDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeChildCompositeDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeChildContainedResources;
import ca.uhn.fhir.context.RuntimeChildDeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimeChildDirectResource;
import ca.uhn.fhir.context.RuntimeChildEnumerationDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeChildExtensionDt;
import ca.uhn.fhir.context.RuntimeChildNarrativeDefinition;
import ca.uhn.fhir.context.RuntimeChildPrimitiveBoundCodeDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeChildPrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeChildResourceBlockDefinition;
import ca.uhn.fhir.context.RuntimeChildResourceDefinition;
import ca.uhn.fhir.context.RuntimeChildUndeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimeCompositeDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeExtensionDtDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeNarrativeDefinition;
import ca.uhn.fhir.context.RuntimeResourceBlockDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.model.api.CodeableConceptElement;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.IBoundCodeableConcept;
import ca.uhn.fhir.model.api.ICodeEnum;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.Extension;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.base.composite.BaseContainedDt;
import ca.uhn.fhir.model.base.composite.BaseNarrativeDt;
import ca.uhn.fhir.model.base.composite.BaseResourceReferenceDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.ICodedDatatype;
import ca.uhn.fhir.model.primitive.XhtmlDt;
import ca.uhn.fhir.rest.method.RestSearchParameterTypeEnum;
import ca.uhn.fhir.util.ReflectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.IBase;
import org.hl7.fhir.instance.model.IBaseResource;
import org.hl7.fhir.instance.model.ICompositeType;
import org.hl7.fhir.instance.model.IPrimitiveType;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseEnumFactory;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IDatatypeElement;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.INarrative;
import org.hl7.fhir.instance.model.api.IReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModelScanner {
    private static final Logger ourLog = LoggerFactory.getLogger(ModelScanner.class);
    private Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> myClassToElementDefinitions = new HashMap();
    private FhirContext myContext;
    private Map<String, RuntimeResourceDefinition> myIdToResourceDefinition = new HashMap<String, RuntimeResourceDefinition>();
    private Map<String, RuntimeResourceDefinition> myNameToResourceDefinitions = new HashMap<String, RuntimeResourceDefinition>();
    private Map<String, Class<? extends IBaseResource>> myNameToResourceType = new HashMap<String, Class<? extends IBaseResource>>();
    private RuntimeChildUndeclaredExtensionDefinition myRuntimeChildUndeclaredExtensionDefinition;
    private Set<Class<? extends IBase>> myScanAlso = new HashSet<Class<? extends IBase>>();
    private Set<Class<? extends ICodeEnum>> myScanAlsoCodeTable = new HashSet<Class<? extends ICodeEnum>>();
    private FhirVersionEnum myVersion;

    ModelScanner(FhirContext theContext, FhirVersionEnum theVersion, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theExistingDefinitions, Collection<Class<? extends IElement>> theResourceTypes) throws ConfigurationException {
        this.myContext = theContext;
        this.myVersion = theVersion;
        HashSet<Class<? extends IBase>> toScan = theResourceTypes != null ? new HashSet<Class<? extends IElement>>(theResourceTypes) : new HashSet();
        this.init(theExistingDefinitions, toScan);
    }

    private void addScanAlso(Class<? extends IBase> theType) {
        if (theType.isInterface() || Modifier.isAbstract(theType.getModifiers())) {
            return;
        }
        this.myScanAlso.add(theType);
    }

    private Class<?> determineElementType(Field next) {
        Class<?> nextElementType = next.getType();
        if (List.class.equals(nextElementType)) {
            nextElementType = ReflectionUtil.getGenericCollectionTypeOfField(next);
        } else if (Collection.class.isAssignableFrom(nextElementType)) {
            throw new ConfigurationException("Field '" + next.getName() + "' in type '" + next.getClass().getCanonicalName() + "' is a Collection - Only java.util.List curently supported");
        }
        return nextElementType;
    }

    private IValueSetEnumBinder<Enum<?>> getBoundCodeBinder(Field theNext) {
        Class<?> bound = ModelScanner.getGenericCollectionTypeOfCodedField(theNext);
        if (bound == null) {
            throw new ConfigurationException("Field '" + theNext + "' has no parameter for " + BoundCodeDt.class.getSimpleName() + " to determine enum type");
        }
        try {
            Field bindingField = bound.getField("VALUESET_BINDER");
            return (IValueSetEnumBinder)bindingField.get(null);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Field '" + theNext + "' has type parameter " + bound.getCanonicalName() + " but this class has no valueset binding field", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Field '" + theNext + "' has type parameter " + bound.getCanonicalName() + " but this class has no valueset binding field", e);
        }
        catch (NoSuchFieldException e) {
            throw new ConfigurationException("Field '" + theNext + "' has type parameter " + bound.getCanonicalName() + " but this class has no valueset binding field", e);
        }
        catch (SecurityException e) {
            throw new ConfigurationException("Field '" + theNext + "' has type parameter " + bound.getCanonicalName() + " but this class has no valueset binding field", e);
        }
    }

    public Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> getClassToElementDefinitions() {
        return this.myClassToElementDefinitions;
    }

    public Map<String, RuntimeResourceDefinition> getIdToResourceDefinition() {
        return this.myIdToResourceDefinition;
    }

    public Map<String, RuntimeResourceDefinition> getNameToResourceDefinitions() {
        return this.myNameToResourceDefinitions;
    }

    public Map<String, Class<? extends IBaseResource>> getNameToResourceType() {
        return this.myNameToResourceType;
    }

    public RuntimeChildUndeclaredExtensionDefinition getRuntimeChildUndeclaredExtensionDefinition() {
        return this.myRuntimeChildUndeclaredExtensionDefinition;
    }

    private void init(Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theExistingDefinitions, Set<Class<? extends IBase>> theDatatypes) {
        if (theExistingDefinitions != null) {
            this.myClassToElementDefinitions.putAll(theExistingDefinitions);
        }
        int startSize = this.myClassToElementDefinitions.size();
        long start = System.currentTimeMillis();
        Map<String, Class<? extends IBaseResource>> resourceTypes = this.myNameToResourceType;
        ModelScanner.scanVersionPropertyFile(theDatatypes, resourceTypes, this.myVersion);
        do {
            for (Class<? extends IBase> clazz : theDatatypes) {
                this.scan(clazz);
            }
            Iterator<Object> iter = this.myScanAlso.iterator();
            while (iter.hasNext()) {
                if (!this.myClassToElementDefinitions.containsKey(iter.next())) continue;
                iter.remove();
            }
            theDatatypes.clear();
            theDatatypes.addAll(this.myScanAlso);
            this.myScanAlso.clear();
        } while (!theDatatypes.isEmpty());
        for (Map.Entry entry : this.myClassToElementDefinitions.entrySet()) {
            if (theExistingDefinitions != null && theExistingDefinitions.containsKey(entry.getKey())) continue;
            BaseRuntimeElementDefinition next = (BaseRuntimeElementDefinition)entry.getValue();
            next.sealAndInitialize(this.myContext, this.myClassToElementDefinitions);
        }
        this.myRuntimeChildUndeclaredExtensionDefinition = new RuntimeChildUndeclaredExtensionDefinition();
        this.myRuntimeChildUndeclaredExtensionDefinition.sealAndInitialize(this.myContext, this.myClassToElementDefinitions);
        long time = System.currentTimeMillis() - start;
        int size = this.myClassToElementDefinitions.size() - startSize;
        ourLog.debug("Done scanning FHIR library, found {} model entries in {}ms", (Object)size, (Object)time);
    }

    private <T extends Annotation> T pullAnnotation(AnnotatedElement theTarget, Class<T> theAnnotationType) {
        T retVal = theTarget.getAnnotation(theAnnotationType);
        return retVal;
    }

    private void scan(Class<? extends IBase> theClass) throws ConfigurationException {
        Block blockDefinition;
        DatatypeDef datatypeDefinition;
        BaseRuntimeElementDefinition<?> existingDef = this.myClassToElementDefinitions.get(theClass);
        if (existingDef != null) {
            return;
        }
        ResourceDef resourceDefinition = this.pullAnnotation(theClass, ResourceDef.class);
        if (resourceDefinition != null) {
            if (!IBaseResource.class.isAssignableFrom(theClass)) {
                throw new ConfigurationException("Resource type contains a @" + ResourceDef.class.getSimpleName() + " annotation but does not implement " + IResource.class.getCanonicalName() + ": " + theClass.getCanonicalName());
            }
            Class<? extends IBase> resClass = theClass;
            this.scanResource(resClass, resourceDefinition);
        }
        if ((datatypeDefinition = this.pullAnnotation(theClass, DatatypeDef.class)) != null) {
            Class<? extends IBase> resClass;
            if (ICompositeType.class.isAssignableFrom(theClass)) {
                resClass = theClass;
                this.scanCompositeDatatype(resClass, datatypeDefinition);
            } else if (IPrimitiveType.class.isAssignableFrom(theClass)) {
                resClass = theClass;
                this.scanPrimitiveDatatype(resClass, datatypeDefinition);
            } else {
                throw new ConfigurationException("Resource type contains a @" + DatatypeDef.class.getSimpleName() + " annotation but does not implement " + IDatatype.class.getCanonicalName() + ": " + theClass.getCanonicalName());
            }
        }
        if ((blockDefinition = this.pullAnnotation(theClass, Block.class)) != null) {
            if (IResourceBlock.class.isAssignableFrom(theClass) || IBackboneElement.class.isAssignableFrom(theClass) || IDatatypeElement.class.isAssignableFrom(theClass)) {
                this.scanBlock(theClass);
            } else {
                throw new ConfigurationException("Type contains a @" + Block.class.getSimpleName() + " annotation but does not implement " + IResourceBlock.class.getCanonicalName() + ": " + theClass.getCanonicalName());
            }
        }
        if (blockDefinition == null && datatypeDefinition == null && resourceDefinition == null) {
            throw new ConfigurationException("Resource class[" + theClass.getName() + "] does not contain any valid HAPI-FHIR annotations");
        }
    }

    private void scanBlock(Class<? extends IBase> theClass) {
        ourLog.debug("Scanning resource block class: {}", (Object)theClass.getName());
        String resourceName = theClass.getCanonicalName();
        if (StringUtils.isBlank((CharSequence)resourceName)) {
            throw new ConfigurationException("Block type @" + Block.class.getSimpleName() + " annotation contains no name: " + theClass.getCanonicalName());
        }
        RuntimeResourceBlockDefinition resourceDef = new RuntimeResourceBlockDefinition(resourceName, theClass);
        this.myClassToElementDefinitions.put(theClass, resourceDef);
        this.scanCompositeElementForChildren(theClass, resourceDef);
    }

    private void scanCompositeDatatype(Class<? extends ICompositeType> theClass, DatatypeDef theDatatypeDefinition) {
        ourLog.debug("Scanning datatype class: {}", (Object)theClass.getName());
        RuntimeCompositeDatatypeDefinition resourceDef = theClass.equals(ExtensionDt.class) ? new RuntimeExtensionDtDefinition(theDatatypeDefinition, theClass) : new RuntimeCompositeDatatypeDefinition(theDatatypeDefinition, theClass);
        this.myClassToElementDefinitions.put(theClass, resourceDef);
        this.scanCompositeElementForChildren(theClass, resourceDef);
    }

    private void scanCompositeElementForChildren(Class<? extends IBase> theClass, BaseRuntimeElementCompositeDefinition<?> theDefinition) {
        HashSet<String> elementNames = new HashSet<String>();
        TreeMap<Integer, BaseRuntimeDeclaredChildDefinition> orderToElementDef = new TreeMap<Integer, BaseRuntimeDeclaredChildDefinition>();
        TreeMap<Integer, BaseRuntimeDeclaredChildDefinition> orderToExtensionDef = new TreeMap<Integer, BaseRuntimeDeclaredChildDefinition>();
        LinkedList<Class<? extends IBase>> classes = new LinkedList<Class<? extends IBase>>();
        Class<? extends IBase> current = theClass;
        do {
            classes.push(current);
        } while ((current = IBase.class.isAssignableFrom(current.getSuperclass()) ? current.getSuperclass() : null) != null);
        for (Class clazz : classes) {
            this.scanCompositeElementForChildren(clazz, elementNames, orderToElementDef, orderToExtensionDef);
        }
        TreeSet<Object> orders = new TreeSet<Object>();
        orders.addAll(orderToElementDef.keySet());
        orders.addAll(orderToExtensionDef.keySet());
        for (Integer n : orders) {
            BaseRuntimeDeclaredChildDefinition nextExt;
            BaseRuntimeChildDefinition nextChild = orderToElementDef.get(n);
            if (nextChild != null) {
                theDefinition.addChild(nextChild);
            }
            if ((nextExt = orderToExtensionDef.get(n)) == null) continue;
            theDefinition.addExtension((RuntimeChildDeclaredExtensionDefinition)nextExt);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void scanCompositeElementForChildren(Class<? extends IBase> theClass, Set<String> elementNames, TreeMap<Integer, BaseRuntimeDeclaredChildDefinition> theOrderToElementDef, TreeMap<Integer, BaseRuntimeDeclaredChildDefinition> theOrderToExtensionDef) {
        int baseElementOrder = theOrderToElementDef.isEmpty() ? 0 : theOrderToElementDef.lastEntry().getKey() + 1;
        for (Field next : theClass.getDeclaredFields()) {
            Object def;
            void var19_27;
            if (Modifier.isFinal(next.getModifiers())) {
                ourLog.trace("Ignoring constant {} on target type {}", (Object)next.getName(), theClass);
                continue;
            }
            Child childAnnotation = this.pullAnnotation(next, Child.class);
            if (childAnnotation == null) {
                ourLog.trace("Ignoring non @Child field {} on target type {}", (Object)next.getName(), theClass);
                continue;
            }
            Description descriptionAnnotation = this.pullAnnotation(next, Description.class);
            TreeMap<Integer, BaseRuntimeDeclaredChildDefinition> orderMap = theOrderToElementDef;
            Extension extensionAttr = this.pullAnnotation(next, Extension.class);
            if (extensionAttr != null) {
                orderMap = theOrderToExtensionDef;
            }
            String elementName = childAnnotation.name();
            int order = childAnnotation.order();
            if (order == -2) {
                BaseRuntimeDeclaredChildDefinition nextDef;
                if (extensionAttr != null) {
                    for (Map.Entry<Integer, BaseRuntimeDeclaredChildDefinition> entry : orderMap.entrySet()) {
                        nextDef = entry.getValue();
                        if (!(nextDef instanceof RuntimeChildDeclaredExtensionDefinition) || !nextDef.getExtensionUrl().equals(extensionAttr.url())) continue;
                        order = entry.getKey();
                        orderMap.remove(entry.getKey());
                        elementNames.remove(elementName);
                        break;
                    }
                    if (order == -2) {
                        throw new ConfigurationException("Field " + next.getName() + "' on target type " + theClass.getSimpleName() + " has order() of REPLACE_PARENT (" + -2 + ") but no parent element with extension URL " + extensionAttr.url() + " could be found on type " + next.getDeclaringClass().getSimpleName());
                    }
                } else {
                    for (Map.Entry<Integer, BaseRuntimeDeclaredChildDefinition> entry : orderMap.entrySet()) {
                        nextDef = entry.getValue();
                        if (!elementName.equals(nextDef.getElementName())) continue;
                        order = entry.getKey();
                        orderMap.remove(entry.getKey());
                        elementNames.remove(elementName);
                        break;
                    }
                    if (order == -2) {
                        throw new ConfigurationException("Field " + next.getName() + "' on target type " + theClass.getSimpleName() + " has order() of REPLACE_PARENT (" + -2 + ") but no parent element with name " + elementName + " could be found on type " + next.getDeclaringClass().getSimpleName());
                    }
                }
            }
            if (order < 0 && order != -1) {
                throw new ConfigurationException("Invalid order '" + order + "' on @Child for field '" + next.getName() + "' on target type: " + theClass);
            }
            if (order != -1) {
                order += baseElementOrder;
            }
            if (order == -1) {
                order = Integer.MIN_VALUE;
                while (orderMap.containsKey(order)) {
                    ++order;
                }
            }
            ArrayList<Class<? extends IBase>> choiceTypes = new ArrayList<Class<? extends IBase>>();
            Class<? extends IElement>[] classArray = childAnnotation.type();
            int nextDef = classArray.length;
            boolean bl = false;
            while (var19_27 < nextDef) {
                Class<? extends IElement> nextChoiceType = classArray[var19_27];
                choiceTypes.add(nextChoiceType);
                ++var19_27;
            }
            if (orderMap.containsKey(order)) {
                throw new ConfigurationException("Detected duplicate field order '" + childAnnotation.order() + "' for element named '" + elementName + "' in type '" + theClass.getCanonicalName() + "'");
            }
            if (elementNames.contains(elementName)) {
                throw new ConfigurationException("Detected duplicate field name '" + elementName + "' in type '" + theClass.getCanonicalName() + "'");
            }
            Class<?> clazz = this.determineElementType(next);
            if (IAnyResource.class.isAssignableFrom(clazz) || IResource.class.equals(clazz)) {
                def = new RuntimeChildDirectResource(next, childAnnotation, descriptionAnnotation, elementName);
                orderMap.put(order, (BaseRuntimeDeclaredChildDefinition)def);
            } else if (BaseContainedDt.class.isAssignableFrom(clazz) || childAnnotation.name().equals("contained") && IDomainResource.class.isAssignableFrom(theClass)) {
                def = new RuntimeChildContainedResources(next, childAnnotation, descriptionAnnotation, elementName);
                orderMap.put(order, (BaseRuntimeDeclaredChildDefinition)def);
            } else if (choiceTypes.size() > 1 && !BaseResourceReferenceDt.class.isAssignableFrom(clazz) && !IReference.class.isAssignableFrom(clazz)) {
                for (Class clazz2 : choiceTypes) {
                    this.addScanAlso(clazz2);
                }
                def = new RuntimeChildChoiceDefinition(next, elementName, childAnnotation, descriptionAnnotation, choiceTypes);
                orderMap.put(order, (BaseRuntimeDeclaredChildDefinition)def);
            } else if (next.getType().equals(ExtensionDt.class)) {
                def = new RuntimeChildExtensionDt(next, elementName, childAnnotation, descriptionAnnotation);
                orderMap.put(order, (BaseRuntimeDeclaredChildDefinition)def);
                if (IElement.class.isAssignableFrom(clazz)) {
                    this.addScanAlso(clazz);
                }
            } else if (extensionAttr != null) {
                void var19_31;
                Class<?> et = clazz;
                Object var19_29 = null;
                if (BoundCodeDt.class.isAssignableFrom(clazz) || IBoundCodeableConcept.class.isAssignableFrom(clazz)) {
                    IValueSetEnumBinder<Enum<?>> iValueSetEnumBinder = this.getBoundCodeBinder(next);
                }
                RuntimeChildDeclaredExtensionDefinition def2 = new RuntimeChildDeclaredExtensionDefinition(next, childAnnotation, descriptionAnnotation, extensionAttr, elementName, extensionAttr.url(), (Class<? extends IBase>)et, (IValueSetEnumBinder<Enum<?>>)var19_31);
                orderMap.put(order, def2);
                if (IElement.class.isAssignableFrom(clazz)) {
                    this.addScanAlso(clazz);
                }
            } else if (BaseResourceReferenceDt.class.isAssignableFrom(clazz) || IReference.class.isAssignableFrom(clazz)) {
                ArrayList<Class<? extends IBaseResource>> refTypesList = new ArrayList<Class<? extends IBaseResource>>();
                for (Class<? extends IElement> nextType : childAnnotation.type()) {
                    if (!IBaseResource.class.isAssignableFrom(nextType)) {
                        throw new ConfigurationException("Field '" + next.getName() + "' in class '" + next.getDeclaringClass().getCanonicalName() + "' is of type " + BaseResourceReferenceDt.class + " but contains a non-resource type: " + nextType.getCanonicalName());
                    }
                    refTypesList.add(nextType);
                    this.addScanAlso(nextType);
                }
                RuntimeChildResourceDefinition runtimeChildResourceDefinition = new RuntimeChildResourceDefinition(next, elementName, childAnnotation, descriptionAnnotation, refTypesList);
                orderMap.put(order, runtimeChildResourceDefinition);
            } else if (IResourceBlock.class.isAssignableFrom(clazz) || IBackboneElement.class.isAssignableFrom(clazz) || IDatatypeElement.class.isAssignableFrom(clazz)) {
                Class<?> blockDef = clazz;
                this.addScanAlso(blockDef);
                RuntimeChildResourceBlockDefinition runtimeChildResourceBlockDefinition = new RuntimeChildResourceBlockDefinition(next, childAnnotation, descriptionAnnotation, elementName, blockDef);
                orderMap.put(order, runtimeChildResourceBlockDefinition);
            } else if (IDatatype.class.equals(clazz) || IElement.class.equals(clazz) || "org.hl7.fhir.instance.model.Type".equals(clazz.getName()) || IBaseDatatype.class.equals(clazz)) {
                def = new RuntimeChildAny(next, elementName, childAnnotation, descriptionAnnotation);
                orderMap.put(order, (BaseRuntimeDeclaredChildDefinition)def);
            } else if (IDatatype.class.isAssignableFrom(clazz) || IPrimitiveType.class.isAssignableFrom(clazz) || ICompositeType.class.isAssignableFrom(clazz) || IBaseDatatype.class.isAssignableFrom(clazz) || IBaseExtension.class.isAssignableFrom(clazz)) {
                void var19_41;
                IValueSetEnumBinder<Enum<?>> binder;
                Class<?> nextDatatype = clazz;
                this.addScanAlso(nextDatatype);
                if (IPrimitiveType.class.isAssignableFrom(clazz)) {
                    if (clazz.equals(BoundCodeDt.class)) {
                        binder = this.getBoundCodeBinder(next);
                        RuntimeChildPrimitiveBoundCodeDatatypeDefinition runtimeChildPrimitiveBoundCodeDatatypeDefinition = new RuntimeChildPrimitiveBoundCodeDatatypeDefinition(next, elementName, childAnnotation, descriptionAnnotation, nextDatatype, binder);
                    } else if (!childAnnotation.enumFactory().getSimpleName().equals("NoEnumFactory")) {
                        Class<? extends IBaseEnumFactory<?>> enumFactory = childAnnotation.enumFactory();
                        RuntimeChildEnumerationDatatypeDefinition runtimeChildEnumerationDatatypeDefinition = new RuntimeChildEnumerationDatatypeDefinition(next, elementName, childAnnotation, descriptionAnnotation, nextDatatype, enumFactory);
                    } else {
                        RuntimeChildPrimitiveDatatypeDefinition runtimeChildPrimitiveDatatypeDefinition = new RuntimeChildPrimitiveDatatypeDefinition(next, elementName, descriptionAnnotation, childAnnotation, nextDatatype);
                    }
                } else if (IBoundCodeableConcept.class.isAssignableFrom(clazz)) {
                    binder = this.getBoundCodeBinder(next);
                    RuntimeChildCompositeBoundDatatypeDefinition runtimeChildCompositeBoundDatatypeDefinition = new RuntimeChildCompositeBoundDatatypeDefinition(next, elementName, childAnnotation, descriptionAnnotation, nextDatatype, binder);
                } else if (BaseNarrativeDt.class.isAssignableFrom(clazz) || INarrative.class.getName().equals(clazz.getClass().getName())) {
                    RuntimeChildNarrativeDefinition runtimeChildNarrativeDefinition = new RuntimeChildNarrativeDefinition(next, elementName, childAnnotation, descriptionAnnotation, nextDatatype);
                } else {
                    RuntimeChildCompositeDatatypeDefinition runtimeChildCompositeDatatypeDefinition = new RuntimeChildCompositeDatatypeDefinition(next, elementName, childAnnotation, descriptionAnnotation, nextDatatype);
                }
                CodeableConceptElement concept = this.pullAnnotation(next, CodeableConceptElement.class);
                if (concept != null) {
                    if (!ICodedDatatype.class.isAssignableFrom(nextDatatype)) {
                        throw new ConfigurationException("Field '" + elementName + "' in type '" + theClass.getCanonicalName() + "' is marked as @" + CodeableConceptElement.class.getCanonicalName() + " but type is not a subtype of " + ICodedDatatype.class.getName());
                    }
                    Class<? extends ICodeEnum> type = concept.type();
                    this.myScanAlsoCodeTable.add(type);
                    var19_41.setCodeType(type);
                }
                orderMap.put(order, (BaseRuntimeDeclaredChildDefinition)var19_41);
            } else {
                throw new ConfigurationException("Field '" + elementName + "' in type '" + theClass.getCanonicalName() + "' is not a valid child type: " + clazz);
            }
            elementNames.add(elementName);
        }
    }

    private String scanPrimitiveDatatype(Class<? extends IPrimitiveType<?>> theClass, DatatypeDef theDatatypeDefinition) {
        BaseRuntimeElementDefinition resourceDef;
        ourLog.debug("Scanning resource class: {}", (Object)theClass.getName());
        String resourceName = theDatatypeDefinition.name();
        if (StringUtils.isBlank((CharSequence)resourceName)) {
            throw new ConfigurationException("Resource type @" + ResourceDef.class.getSimpleName() + " annotation contains no resource name: " + theClass.getCanonicalName());
        }
        if (theClass.equals(XhtmlDt.class)) {
            Class<IPrimitiveType<?>> clazz = theClass;
            resourceDef = new RuntimePrimitiveDatatypeNarrativeDefinition(resourceName, (Class<XhtmlDt>)clazz);
        } else {
            resourceDef = new RuntimePrimitiveDatatypeDefinition(theDatatypeDefinition, theClass);
        }
        this.myClassToElementDefinitions.put(theClass, resourceDef);
        return resourceName;
    }

    private String scanResource(Class<? extends IBaseResource> theClass, ResourceDef resourceDefinition) {
        String resourceId;
        ourLog.debug("Scanning resource class: {}", (Object)theClass.getName());
        boolean primaryNameProvider = true;
        String resourceName = resourceDefinition.name();
        if (StringUtils.isBlank((CharSequence)resourceName)) {
            Class<? extends IBaseResource> parent = theClass.getSuperclass();
            primaryNameProvider = false;
            while (!parent.equals(Object.class) && StringUtils.isBlank((CharSequence)resourceName)) {
                ResourceDef nextDef = this.pullAnnotation(parent, ResourceDef.class);
                if (nextDef != null) {
                    resourceName = nextDef.name();
                }
                parent = parent.getSuperclass();
            }
            if (StringUtils.isBlank((CharSequence)resourceName)) {
                throw new ConfigurationException("Resource type @" + ResourceDef.class.getSimpleName() + " annotation contains no resource name(): " + theClass.getCanonicalName() + " - This is only allowed for types that extend other resource types ");
            }
        }
        if (!StringUtils.isBlank((CharSequence)(resourceId = resourceDefinition.id())) && this.myIdToResourceDefinition.containsKey(resourceId)) {
            throw new ConfigurationException("The following resource types have the same ID of '" + resourceId + "' - " + theClass.getCanonicalName() + " and " + this.myIdToResourceDefinition.get(resourceId).getImplementingClass().getCanonicalName());
        }
        RuntimeResourceDefinition resourceDef = new RuntimeResourceDefinition(this.myContext, resourceName, theClass, resourceDefinition);
        this.myClassToElementDefinitions.put(theClass, resourceDef);
        if (primaryNameProvider && resourceDef.getStructureVersion() == this.myVersion) {
            this.myNameToResourceDefinitions.put(resourceName, resourceDef);
        }
        this.scanCompositeElementForChildren(theClass, resourceDef);
        this.myIdToResourceDefinition.put(resourceId, resourceDef);
        this.scanResourceForSearchParams(theClass, resourceDef);
        return resourceName;
    }

    private void scanResourceForSearchParams(Class<? extends IBaseResource> theClass, RuntimeResourceDefinition theResourceDef) {
        HashMap<String, RuntimeSearchParam> nameToParam = new HashMap<String, RuntimeSearchParam>();
        LinkedHashMap<Field, String[]> compositeFields = new LinkedHashMap<Field, String[]>();
        for (Field nextField : theClass.getFields()) {
            String[] searchParam = this.pullAnnotation(nextField, SearchParamDefinition.class);
            if (searchParam == null) continue;
            RestSearchParameterTypeEnum paramType = RestSearchParameterTypeEnum.valueOf(searchParam.type().toUpperCase());
            if (paramType == null) {
                throw new ConfigurationException("Search param " + searchParam.name() + " has an invalid type: " + searchParam.type());
            }
            if (paramType == RestSearchParameterTypeEnum.COMPOSITE) {
                compositeFields.put(nextField, searchParam);
                continue;
            }
            RuntimeSearchParam param = new RuntimeSearchParam(searchParam.name(), searchParam.description(), searchParam.path(), paramType);
            theResourceDef.addSearchParam(param);
            nameToParam.put(param.getName(), param);
        }
        for (Map.Entry entry : compositeFields.entrySet()) {
            SearchParamDefinition searchParam = (SearchParamDefinition)entry.getValue();
            ArrayList<RuntimeSearchParam> compositeOf = new ArrayList<RuntimeSearchParam>();
            for (String nextName : searchParam.compositeOf()) {
                RuntimeSearchParam param = (RuntimeSearchParam)nameToParam.get(nextName);
                if (param == null) {
                    ourLog.warn("Search parameter {}.{} declares that it is a composite with compositeOf value '{}' but that is not a valid parametr name itself. Valid values are: {}", new Object[]{theResourceDef.getName(), searchParam.name(), nextName, nameToParam.keySet()});
                    continue;
                }
                compositeOf.add(param);
            }
            RuntimeSearchParam param = new RuntimeSearchParam(searchParam.name(), searchParam.description(), searchParam.path(), RestSearchParameterTypeEnum.COMPOSITE, compositeOf);
            theResourceDef.addSearchParam(param);
        }
    }

    private static Class<?> getGenericCollectionTypeOfCodedField(Field next) {
        Class type;
        ParameterizedType collectionType = (ParameterizedType)next.getGenericType();
        Type firstArg = collectionType.getActualTypeArguments()[0];
        if (ParameterizedType.class.isAssignableFrom(firstArg.getClass())) {
            ParameterizedType pt = (ParameterizedType)firstArg;
            firstArg = pt.getActualTypeArguments()[0];
            type = (Class)firstArg;
        } else {
            type = (Class)firstArg;
        }
        return type;
    }

    static void scanVersionPropertyFile(Set<Class<? extends IBase>> theDatatypes, Map<String, Class<? extends IBaseResource>> theResourceTypes, FhirVersionEnum version) {
        InputStream str = version.getVersionImplementation().getFhirVersionPropertiesFile();
        Properties prop = new Properties();
        try {
            prop.load(str);
            for (Map.Entry<Object, Object> nextEntry : prop.entrySet()) {
                Class<?> nextClass;
                String nextKey = nextEntry.getKey().toString();
                String nextValue = nextEntry.getValue().toString();
                if (nextKey.startsWith("datatype.")) {
                    if (theDatatypes == null) continue;
                    try {
                        Class<?> dtType = Class.forName(nextValue);
                        if (IElement.class.isAssignableFrom(dtType)) {
                            nextClass = dtType;
                            theDatatypes.add(nextClass);
                            continue;
                        }
                        if (IBaseDatatype.class.isAssignableFrom(dtType)) {
                            nextClass = dtType;
                            theDatatypes.add(nextClass);
                            continue;
                        }
                        ourLog.warn("Class is not assignable from " + IElement.class.getSimpleName() + " or " + IBaseDatatype.class.getSimpleName() + ": " + nextValue);
                    }
                    catch (ClassNotFoundException e) {
                        ourLog.error("Unknown class[" + nextValue + "] for data type definition: " + nextKey.substring("datatype.".length()), (Throwable)e);
                    }
                    continue;
                }
                if (nextKey.startsWith("resource.")) {
                    String resName = nextKey.substring("resource.".length()).toLowerCase();
                    try {
                        nextClass = Class.forName(nextValue);
                        if (!IBaseResource.class.isAssignableFrom(nextClass)) {
                            ourLog.warn("Class is not assignable from " + IBaseResource.class.getSimpleName() + ": " + nextValue);
                            continue;
                        }
                        theResourceTypes.put(resName, nextClass);
                    }
                    catch (ClassNotFoundException e) {
                        ourLog.error("Unknown class[" + nextValue + "] for resource definition: " + nextKey.substring("resource.".length()), (Throwable)e);
                    }
                    continue;
                }
                ourLog.warn("Unexpected property in version property file: {}={}", (Object)nextKey, (Object)nextValue);
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to load model property file from classpath: /ca/uhn/fhir/model/dstu/model.properties");
        }
    }
}

