/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceReferenceDefinition;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.IBase;
import org.hl7.fhir.instance.model.IBaseResource;

public class RuntimeChildChoiceDefinition
extends BaseRuntimeDeclaredChildDefinition {
    private List<Class<? extends IBase>> myChoiceTypes;
    private Map<String, BaseRuntimeElementDefinition<?>> myNameToChildDefinition;
    private Map<Class<? extends IBase>, String> myDatatypeToElementName;
    private Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> myDatatypeToElementDefinition;

    public RuntimeChildChoiceDefinition(Field theField, String theElementName, Child theChildAnnotation, Description theDescriptionAnnotation, List<Class<? extends IBase>> theChoiceTypes) {
        super(theField, theChildAnnotation, theDescriptionAnnotation, theElementName);
        this.myChoiceTypes = Collections.unmodifiableList(theChoiceTypes);
    }

    RuntimeChildChoiceDefinition(Field theField, String theElementName, Child theChildAnnotation, Description theDescriptionAnnotation) {
        super(theField, theChildAnnotation, theDescriptionAnnotation, theElementName);
    }

    void setChoiceTypes(List<Class<? extends IBase>> theChoiceTypes) {
        this.myChoiceTypes = Collections.unmodifiableList(theChoiceTypes);
    }

    public List<Class<? extends IBase>> getChoices() {
        return this.myChoiceTypes;
    }

    @Override
    public Set<String> getValidChildNames() {
        return this.myNameToChildDefinition.keySet();
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildByName(String theName) {
        assert (this.myNameToChildDefinition.containsKey(theName));
        return this.myNameToChildDefinition.get(theName);
    }

    @Override
    void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        this.myNameToChildDefinition = new HashMap();
        this.myDatatypeToElementName = new HashMap<Class<? extends IBase>, String>();
        this.myDatatypeToElementDefinition = new HashMap();
        for (Class<? extends IBase> next : this.myChoiceTypes) {
            RuntimeResourceReferenceDefinition nextDef;
            String elementName;
            String alternateElementName = null;
            if (IBaseResource.class.isAssignableFrom(next)) {
                elementName = this.getElementName() + StringUtils.capitalize((String)next.getSimpleName());
                alternateElementName = this.getElementName() + "Resource";
                ArrayList<Class<? extends IBaseResource>> types = new ArrayList<Class<? extends IBaseResource>>();
                types.add(next);
                nextDef = new RuntimeResourceReferenceDefinition(elementName, types);
                ((BaseRuntimeElementDefinition)nextDef).sealAndInitialize(theContext, theClassToElementDefinitions);
            } else {
                nextDef = theClassToElementDefinitions.get(next);
                elementName = this.getElementName() + StringUtils.capitalize((String)nextDef.getName());
            }
            this.myNameToChildDefinition.put(elementName, nextDef);
            if (alternateElementName != null) {
                this.myNameToChildDefinition.put(alternateElementName, nextDef);
            }
            if (IBaseResource.class.isAssignableFrom(next)) {
                Class<? extends IBase> refType = theContext.getVersion().getResourceReferenceType();
                this.myDatatypeToElementDefinition.put(refType, nextDef);
                alternateElementName = this.getElementName() + "Resource";
                this.myDatatypeToElementName.put(refType, alternateElementName);
            }
            this.myDatatypeToElementDefinition.put(next, nextDef);
            this.myDatatypeToElementName.put(next, elementName);
        }
        this.myNameToChildDefinition = Collections.unmodifiableMap(this.myNameToChildDefinition);
        this.myDatatypeToElementName = Collections.unmodifiableMap(this.myDatatypeToElementName);
        this.myDatatypeToElementDefinition = Collections.unmodifiableMap(this.myDatatypeToElementDefinition);
    }

    @Override
    public String getChildNameByDatatype(Class<? extends IBase> theDatatype) {
        return this.myDatatypeToElementName.get(theDatatype);
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildElementDefinitionByDatatype(Class<? extends IBase> theDatatype) {
        return this.myDatatypeToElementDefinition.get(theDatatype);
    }

    public Set<Class<? extends IBase>> getValidChildTypes() {
        return Collections.unmodifiableSet(this.myDatatypeToElementDefinition.keySet());
    }
}

