/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeElemContainedResources;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.base.composite.BaseContainedDt;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.instance.model.IBase;

public class RuntimeChildContainedResources
extends BaseRuntimeDeclaredChildDefinition {
    private RuntimeElemContainedResources myElem;

    RuntimeChildContainedResources(Field theField, Child theChildAnnotation, Description theDescriptionAnnotation, String theElementName) throws ConfigurationException {
        super(theField, theChildAnnotation, theDescriptionAnnotation, theElementName);
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildByName(String theName) {
        assert (theName.equals(this.getElementName()));
        return this.myElem;
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildElementDefinitionByDatatype(Class<? extends IBase> theType) {
        assert (BaseContainedDt.class.isAssignableFrom(theType));
        return this.myElem;
    }

    @Override
    public String getChildNameByDatatype(Class<? extends IBase> theDatatype) {
        assert (BaseContainedDt.class.isAssignableFrom(theDatatype));
        return this.getElementName();
    }

    @Override
    public Set<String> getValidChildNames() {
        return Collections.singleton(this.getElementName());
    }

    @Override
    void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        Class<?> actualType = theContext.getVersion().getContainedType();
        if (BaseContainedDt.class.isAssignableFrom(actualType)) {
            Class<?> type = actualType;
            this.myElem = new RuntimeElemContainedResources(type);
        } else if (ArrayList.class.isAssignableFrom(actualType)) {
            this.myElem = null;
        } else {
            throw new ConfigurationException("Fhir Version definition returned invalid contained type: " + actualType);
        }
    }
}

