/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeCompositeDatatypeDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeResourceBlockDefinition;
import ca.uhn.fhir.context.RuntimeResourceReferenceDefinition;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.Extension;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.IBase;
import org.hl7.fhir.instance.model.IBaseResource;

public class RuntimeChildDeclaredExtensionDefinition
extends BaseRuntimeDeclaredChildDefinition {
    private BaseRuntimeElementDefinition<?> myChildDef;
    private Class<? extends IBase> myChildType;
    private String myDatatypeChildName;
    private boolean myDefinedLocally;
    private String myExtensionUrl;
    private boolean myModifier;
    private Map<String, RuntimeChildDeclaredExtensionDefinition> myUrlToChildExtension;
    private Object myInstanceConstructorArguments;

    RuntimeChildDeclaredExtensionDefinition(Field theField, Child theChild, Description theDescriptionAnnotation, Extension theExtension, String theElementName, String theExtensionUrl, Class<? extends IBase> theChildType, IValueSetEnumBinder<Enum<?>> theBoundTypeBinder) throws ConfigurationException {
        super(theField, theChild, theDescriptionAnnotation, theElementName);
        assert (StringUtils.isNotBlank((CharSequence)theExtensionUrl));
        this.myExtensionUrl = theExtensionUrl;
        this.myChildType = theChildType;
        this.myDefinedLocally = theExtension.definedLocally();
        this.myModifier = theExtension.isModifier();
        this.myInstanceConstructorArguments = theBoundTypeBinder;
    }

    @Override
    public Object getInstanceConstructorArguments() {
        return this.myInstanceConstructorArguments;
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildByName(String theName) {
        if (this.myDatatypeChildName != null) {
            if (this.myDatatypeChildName.equals(theName)) {
                return this.myChildDef;
            }
            return null;
        }
        return null;
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildElementDefinitionByDatatype(Class<? extends IBase> theType) {
        if (this.myChildType.equals(theType)) {
            return this.myChildDef;
        }
        return null;
    }

    public RuntimeChildDeclaredExtensionDefinition getChildExtensionForUrl(String theUrl) {
        return this.myUrlToChildExtension.get(theUrl);
    }

    @Override
    public String getChildNameByDatatype(Class<? extends IBase> theDatatype) {
        if (this.myChildType.equals(theDatatype) && this.myDatatypeChildName != null) {
            return this.myDatatypeChildName;
        }
        return "extension";
    }

    public Class<? extends IBase> getChildType() {
        return this.myChildType;
    }

    @Override
    public String getExtensionUrl() {
        return this.myExtensionUrl;
    }

    @Override
    public BaseRuntimeElementDefinition<?> getSingleChildOrThrow() {
        return this.myChildDef;
    }

    @Override
    public Set<String> getValidChildNames() {
        return Collections.emptySet();
    }

    public boolean isDefinedLocally() {
        return this.myDefinedLocally;
    }

    public boolean isModifier() {
        return this.myModifier;
    }

    public IBase newInstance() {
        try {
            return this.myChildType.newInstance();
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("Failed to instantiate type:" + this.myChildType.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Failed to instantiate type:" + this.myChildType.getName(), e);
        }
    }

    @Override
    void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        this.myUrlToChildExtension = new HashMap<String, RuntimeChildDeclaredExtensionDefinition>();
        BaseRuntimeElementDefinition<?> elementDef = theClassToElementDefinitions.get(this.myChildType);
        if (elementDef instanceof RuntimePrimitiveDatatypeDefinition || elementDef instanceof RuntimeCompositeDatatypeDefinition) {
            this.myDatatypeChildName = "value" + elementDef.getName().substring(0, 1).toUpperCase() + elementDef.getName().substring(1);
            if ("valueResourceReference".equals(this.myDatatypeChildName)) {
                this.myDatatypeChildName = "valueResource";
                ArrayList<Class<? extends IBaseResource>> types = new ArrayList<Class<? extends IBaseResource>>();
                types.add(IResource.class);
                this.myChildDef = new RuntimeResourceReferenceDefinition("valueResource", types);
            } else {
                this.myChildDef = elementDef;
            }
        } else {
            RuntimeResourceBlockDefinition extDef = (RuntimeResourceBlockDefinition)elementDef;
            for (RuntimeChildDeclaredExtensionDefinition next : extDef.getExtensions()) {
                this.myUrlToChildExtension.put(next.getExtensionUrl(), next);
            }
            this.myChildDef = extDef;
        }
        this.myUrlToChildExtension = Collections.unmodifiableMap(this.myUrlToChildExtension);
    }
}

