/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceReferenceDefinition;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.base.composite.BaseResourceReferenceDt;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.instance.model.IBase;
import org.hl7.fhir.instance.model.IBaseResource;

public class RuntimeChildResourceDefinition
extends BaseRuntimeDeclaredChildDefinition {
    private BaseRuntimeElementDefinition<?> myRuntimeDef;
    private List<Class<? extends IBaseResource>> myResourceTypes;
    private Set<String> myValidChildNames;

    public RuntimeChildResourceDefinition(Field theField, String theElementName, Child theChildAnnotation, Description theDescriptionAnnotation, List<Class<? extends IBaseResource>> theResourceTypes) {
        super(theField, theChildAnnotation, theDescriptionAnnotation, theElementName);
        this.myResourceTypes = theResourceTypes;
        if (theResourceTypes == null || theResourceTypes.isEmpty()) {
            this.myResourceTypes = new ArrayList<Class<? extends IBaseResource>>();
            this.myResourceTypes.add(IBaseResource.class);
        }
    }

    @Override
    public String getChildNameByDatatype(Class<? extends IBase> theDatatype) {
        if (BaseResourceReferenceDt.class.isAssignableFrom(theDatatype)) {
            return this.getElementName();
        }
        return null;
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildElementDefinitionByDatatype(Class<? extends IBase> theDatatype) {
        if (BaseResourceReferenceDt.class.isAssignableFrom(theDatatype)) {
            return this.myRuntimeDef;
        }
        return null;
    }

    @Override
    public Set<String> getValidChildNames() {
        return this.myValidChildNames;
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildByName(String theName) {
        return this.myRuntimeDef;
    }

    @Override
    void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        this.myRuntimeDef = new RuntimeResourceReferenceDefinition(this.getElementName(), this.myResourceTypes);
        this.myRuntimeDef.sealAndInitialize(theContext, theClassToElementDefinitions);
        this.myValidChildNames = new HashSet<String>();
        this.myValidChildNames.add(this.getElementName());
        this.myValidChildNames.add(this.getElementName() + "Resource");
        this.myResourceTypes = Collections.unmodifiableList(this.myResourceTypes);
        this.myValidChildNames = Collections.unmodifiableSet(this.myValidChildNames);
    }

    public List<Class<? extends IBaseResource>> getResourceTypes() {
        return this.myResourceTypes;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getElementName() + "]";
    }
}

