/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.IRuntimeDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeResourceReferenceDefinition;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.base.composite.BaseResourceReferenceDt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.text.WordUtils;
import org.hl7.fhir.instance.model.IBase;
import org.hl7.fhir.instance.model.IBaseResource;

public class RuntimeChildUndeclaredExtensionDefinition
extends BaseRuntimeChildDefinition {
    private Map<String, BaseRuntimeElementDefinition<?>> myAttributeNameToDefinition;
    private Map<Class<? extends IBase>, String> myDatatypeToAttributeName;
    private Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> myDatatypeToDefinition;

    @Override
    public BaseRuntimeChildDefinition.IAccessor getAccessor() {
        return new BaseRuntimeChildDefinition.IAccessor(){

            @Override
            public List<IBase> getValues(Object theTarget) {
                ExtensionDt target = (ExtensionDt)theTarget;
                if (target.getValue() != null) {
                    return Collections.singletonList(target.getValue());
                }
                ArrayList<IBase> retVal = new ArrayList<IBase>(target.getUndeclaredExtensions());
                return retVal;
            }
        };
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildByName(String theName) {
        return this.myAttributeNameToDefinition.get(theName);
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildElementDefinitionByDatatype(Class<? extends IBase> theType) {
        return this.myDatatypeToDefinition.get(theType);
    }

    @Override
    public String getChildNameByDatatype(Class<? extends IBase> theDatatype) {
        return this.myDatatypeToAttributeName.get(theDatatype);
    }

    @Override
    public String getElementName() {
        return "extension";
    }

    @Override
    public int getMax() {
        return 1;
    }

    @Override
    public int getMin() {
        return 0;
    }

    @Override
    public BaseRuntimeChildDefinition.IMutator getMutator() {
        return new BaseRuntimeChildDefinition.IMutator(){

            @Override
            public void addValue(Object theTarget, IBase theValue) {
                ExtensionDt target = (ExtensionDt)theTarget;
                if (theValue instanceof IDatatype) {
                    target.setValue((IDatatype)theTarget);
                } else {
                    target.getUndeclaredExtensions().add((ExtensionDt)theValue);
                }
            }
        };
    }

    @Override
    public Set<String> getValidChildNames() {
        return this.myAttributeNameToDefinition.keySet();
    }

    @Override
    void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        HashMap datatypeAttributeNameToDefinition = new HashMap();
        this.myDatatypeToAttributeName = new HashMap<Class<? extends IBase>, String>();
        for (BaseRuntimeElementDefinition<?> baseRuntimeElementDefinition : theClassToElementDefinitions.values()) {
            if (!(baseRuntimeElementDefinition instanceof IRuntimeDatatypeDefinition) || ((IRuntimeDatatypeDefinition)((Object)baseRuntimeElementDefinition)).isSpecialization()) continue;
            String attrName = RuntimeChildUndeclaredExtensionDefinition.createExtensionChildName(baseRuntimeElementDefinition);
            datatypeAttributeNameToDefinition.put(attrName, baseRuntimeElementDefinition);
            datatypeAttributeNameToDefinition.put(attrName.toLowerCase(), baseRuntimeElementDefinition);
            this.myDatatypeToAttributeName.put(baseRuntimeElementDefinition.getImplementingClass(), attrName);
        }
        this.myAttributeNameToDefinition = datatypeAttributeNameToDefinition;
        this.myDatatypeToDefinition = new HashMap();
        for (Map.Entry entry : this.myAttributeNameToDefinition.entrySet()) {
            Class type = ((BaseRuntimeElementDefinition)entry.getValue()).getImplementingClass();
            this.myDatatypeToDefinition.put(type, (BaseRuntimeElementDefinition<?>)entry.getValue());
        }
        this.myDatatypeToAttributeName.put(theContext.getVersion().getResourceReferenceType(), "valueResource");
        ArrayList<Class<? extends IBaseResource>> types = new ArrayList<Class<? extends IBaseResource>>();
        types.add(IBaseResource.class);
        RuntimeResourceReferenceDefinition runtimeResourceReferenceDefinition = new RuntimeResourceReferenceDefinition("valueResource", types);
        runtimeResourceReferenceDefinition.sealAndInitialize(theContext, theClassToElementDefinitions);
        this.myAttributeNameToDefinition.put("valueResource", runtimeResourceReferenceDefinition);
        this.myDatatypeToDefinition.put(BaseResourceReferenceDt.class, runtimeResourceReferenceDefinition);
        this.myDatatypeToDefinition.put(theContext.getVersion().getResourceReferenceType(), runtimeResourceReferenceDefinition);
    }

    public static String createExtensionChildName(BaseRuntimeElementDefinition<?> next) {
        String attrName = "value" + WordUtils.capitalize((String)next.getName());
        return attrName;
    }
}

