/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.IRuntimeDatatypeDefinition;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.IBase;
import org.hl7.fhir.instance.model.IPrimitiveType;

public class RuntimePrimitiveDatatypeDefinition
extends BaseRuntimeElementDefinition<IPrimitiveType>
implements IRuntimeDatatypeDefinition {
    private boolean mySpecialization;

    public RuntimePrimitiveDatatypeDefinition(DatatypeDef theDef, Class<? extends IPrimitiveType> theImplementingClass) {
        super(theDef.name(), theImplementingClass);
        String resourceName = theDef.name();
        if (StringUtils.isBlank((CharSequence)resourceName)) {
            throw new ConfigurationException("Resource type @" + ResourceDef.class.getSimpleName() + " annotation contains no resource name: " + theImplementingClass.getCanonicalName());
        }
        this.mySpecialization = theDef.isSpecialization();
    }

    @Override
    public boolean isSpecialization() {
        return this.mySpecialization;
    }

    @Override
    void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
    }

    @Override
    public BaseRuntimeElementDefinition.ChildTypeEnum getChildType() {
        return BaseRuntimeElementDefinition.ChildTypeEnum.PRIMITIVE_DATATYPE;
    }
}

