/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.UrlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.IBase;
import org.hl7.fhir.instance.model.IBaseResource;
import org.hl7.fhir.instance.model.api.IAnyResource;

public class RuntimeResourceDefinition
extends BaseRuntimeElementCompositeDefinition<IBaseResource> {
    private RuntimeResourceDefinition myBaseDefinition;
    private Map<String, RuntimeSearchParam> myNameToSearchParam = new LinkedHashMap<String, RuntimeSearchParam>();
    private IBaseResource myProfileDef;
    private String myResourceProfile;
    private List<RuntimeSearchParam> mySearchParams;
    private FhirContext myContext;
    private String myId;
    private final FhirVersionEnum myStructureVersion;

    public FhirVersionEnum getStructureVersion() {
        return this.myStructureVersion;
    }

    public RuntimeResourceDefinition(FhirContext theContext, String theResourceName, Class<? extends IBaseResource> theClass, ResourceDef theResourceAnnotation) {
        super(theResourceName, theClass);
        this.myContext = theContext;
        this.myResourceProfile = theResourceAnnotation.profile();
        this.myId = theResourceAnnotation.id();
        try {
            IBaseResource instance = theClass.newInstance();
            this.myStructureVersion = instance instanceof IAnyResource ? FhirVersionEnum.DSTU2_HL7ORG : ((IResource)instance).getStructureFhirVersionEnum();
        }
        catch (Exception e) {
            throw new ConfigurationException(this.myContext.getLocalizer().getMessage(this.getClass(), "nonInstantiableType", theClass.getName(), e.toString()), e);
        }
    }

    public String getId() {
        return this.myId;
    }

    public void addSearchParam(RuntimeSearchParam theParam) {
        this.myNameToSearchParam.put(theParam.getName(), theParam);
    }

    public RuntimeResourceDefinition getBaseDefinition() {
        return this.myBaseDefinition;
    }

    @Override
    public BaseRuntimeElementDefinition.ChildTypeEnum getChildType() {
        return BaseRuntimeElementDefinition.ChildTypeEnum.RESOURCE;
    }

    @Deprecated
    public String getResourceProfile() {
        return this.myResourceProfile;
    }

    public String getResourceProfile(String theServerBase) {
        String profileWithUrl;
        String profile;
        if (!this.myResourceProfile.isEmpty()) {
            profile = this.myResourceProfile;
        } else if (!this.myId.isEmpty()) {
            profile = this.myId;
        } else {
            return "";
        }
        if (!UrlUtil.isValid(profile) && UrlUtil.isValid(profileWithUrl = theServerBase + "/Profile/" + profile)) {
            return profileWithUrl;
        }
        return profile;
    }

    public RuntimeSearchParam getSearchParam(String theName) {
        return this.myNameToSearchParam.get(theName);
    }

    public List<RuntimeSearchParam> getSearchParams() {
        return this.mySearchParams;
    }

    public boolean isStandardProfile() {
        return this.myResourceProfile.startsWith("http://hl7.org/fhir/profiles");
    }

    @Override
    public void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        super.sealAndInitialize(theContext, theClassToElementDefinitions);
        this.myNameToSearchParam = Collections.unmodifiableMap(this.myNameToSearchParam);
        ArrayList<RuntimeSearchParam> searchParams = new ArrayList<RuntimeSearchParam>(this.myNameToSearchParam.values());
        Collections.sort(searchParams, new Comparator<RuntimeSearchParam>(){

            @Override
            public int compare(RuntimeSearchParam theArg0, RuntimeSearchParam theArg1) {
                return theArg0.getName().compareTo(theArg1.getName());
            }
        });
        this.mySearchParams = Collections.unmodifiableList(searchParams);
        Class target = this.getImplementingClass();
        this.myBaseDefinition = this;
        do {
            if (!IResource.class.isAssignableFrom(target = target.getSuperclass()) || target.getAnnotation(ResourceDef.class) == null) continue;
            this.myBaseDefinition = (RuntimeResourceDefinition)theClassToElementDefinitions.get(target);
        } while (!target.equals(Object.class));
    }

    @Deprecated
    public synchronized IBaseResource toProfile() {
        IBaseResource retVal;
        if (this.myProfileDef != null) {
            return this.myProfileDef;
        }
        this.myProfileDef = retVal = this.myContext.getVersion().generateProfile(this, null);
        return retVal;
    }

    public synchronized IBaseResource toProfile(String theServerBase) {
        IBaseResource retVal;
        if (this.myProfileDef != null) {
            return this.myProfileDef;
        }
        this.myProfileDef = retVal = this.myContext.getVersion().generateProfile(this, theServerBase);
        return retVal;
    }

    public boolean isBundle() {
        return "Bundle".equals(this.getName());
    }
}

