/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.rest.method.RestSearchParameterTypeEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class RuntimeSearchParam {
    private String myDescription;
    private String myName;
    private RestSearchParameterTypeEnum myParamType;
    private String myPath;
    private List<RuntimeSearchParam> myCompositeOf;

    public RuntimeSearchParam(String theName, String theDescription, String thePath, RestSearchParameterTypeEnum theParamType) {
        this(theName, theDescription, thePath, theParamType, null);
    }

    public RuntimeSearchParam(String theName, String theDescription, String thePath, RestSearchParameterTypeEnum theParamType, List<RuntimeSearchParam> theCompositeOf) {
        this.myName = theName;
        this.myDescription = theDescription;
        this.myPath = thePath;
        this.myParamType = theParamType;
        this.myCompositeOf = theCompositeOf;
    }

    public List<RuntimeSearchParam> getCompositeOf() {
        return this.myCompositeOf;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public String getName() {
        return this.myName;
    }

    public RestSearchParameterTypeEnum getParamType() {
        return this.myParamType;
    }

    public String getPath() {
        return this.myPath;
    }

    public List<String> getPathsSplit() {
        String path = this.getPath();
        if (path.indexOf(124) == -1) {
            return Collections.singletonList(path);
        }
        ArrayList<String> retVal = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(path, "|");
        while (tok.hasMoreElements()) {
            String nextPath = tok.nextToken().trim();
            retVal.add(nextPath.trim());
        }
        return retVal;
    }
}

