/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.api;

import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IPrimitiveDatatype;
import ca.uhn.fhir.parser.DataFormatException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hl7.fhir.instance.model.IPrimitiveType;

public abstract class BasePrimitive<T>
extends BaseIdentifiableElement
implements IPrimitiveDatatype<T> {
    private T myCoercedValue;
    private String myStringValue;

    public boolean equals(Object theObj) {
        if (theObj == null) {
            return false;
        }
        if (theObj.getClass() != this.getClass()) {
            return false;
        }
        BasePrimitive o = (BasePrimitive)theObj;
        EqualsBuilder b = new EqualsBuilder();
        b.append(this.getValue(), o.getValue());
        return b.isEquals();
    }

    @Override
    public T getValue() {
        return this.myCoercedValue;
    }

    @Override
    public String getValueAsString() throws DataFormatException {
        return this.myStringValue;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getValue()).toHashCode();
    }

    @Override
    public boolean isEmpty() {
        return super.isBaseEmpty() && this.getValue() == null;
    }

    @Override
    public IPrimitiveType<T> setValue(T theValue) throws DataFormatException {
        this.myCoercedValue = theValue;
        this.updateStringValue();
        return this;
    }

    protected void updateStringValue() {
        this.myStringValue = this.myCoercedValue == null ? null : this.encode(this.myCoercedValue);
    }

    @Override
    public void setValueAsString(String theValue) throws DataFormatException {
        this.myCoercedValue = theValue == null ? null : this.parse(theValue);
        this.myStringValue = theValue;
    }

    protected abstract T parse(String var1);

    protected abstract String encode(T var1);

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getValueAsString() + "]";
    }
}

