/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.api;

import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IPrimitiveDatatype;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.primitive.StringDt;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;

@DatatypeDef(name="Extension")
public class ExtensionDt
extends BaseIdentifiableElement
implements ICompositeDatatype,
IBaseExtension<ExtensionDt> {
    private boolean myModifier;
    @Child(name="url", type={StringDt.class}, order=0, min=1, max=1)
    private StringDt myUrl;
    @Child(name="value", type={IDatatype.class}, order=1, min=0, max=1)
    private IBaseDatatype myValue;

    public ExtensionDt() {
    }

    public ExtensionDt(boolean theIsModifier) {
        this.myModifier = theIsModifier;
    }

    public ExtensionDt(boolean theIsModifier, String theUrl) {
        Validate.notEmpty((CharSequence)theUrl, (String)"URL must be populated", (Object[])new Object[0]);
        this.myModifier = theIsModifier;
        this.myUrl = new StringDt(theUrl);
    }

    public ExtensionDt(boolean theIsModifier, String theUrl, IBaseDatatype theValue) {
        Validate.notEmpty((CharSequence)theUrl, (String)"URL must be populated", (Object[])new Object[0]);
        Validate.notNull((Object)theValue, (String)"Value must not be null", (Object[])new Object[0]);
        this.myModifier = theIsModifier;
        this.myUrl = new StringDt(theUrl);
        this.myValue = theValue;
    }

    @Override
    public String getUrl() {
        return this.myUrl != null ? (String)this.myUrl.getValue() : null;
    }

    public String getUrlAsString() {
        return this.getUrl();
    }

    @Override
    public IBaseDatatype getValue() {
        return this.myValue;
    }

    public IPrimitiveDatatype<?> getValueAsPrimitive() {
        if (!(this.getValue() instanceof IPrimitiveDatatype)) {
            throw new ClassCastException("Extension with URL[" + this.myUrl + "] can not be cast to primitive type, type is: " + this.getClass().getCanonicalName());
        }
        return (IPrimitiveDatatype)this.getValue();
    }

    @Override
    public boolean isEmpty() {
        return super.isBaseEmpty() && (this.myValue == null || this.myValue.isEmpty());
    }

    public boolean isModifier() {
        return this.myModifier;
    }

    public void setModifier(boolean theModifier) {
        this.myModifier = theModifier;
    }

    @Override
    public ExtensionDt setUrl(String theUrl) {
        this.myUrl = theUrl != null ? new StringDt(theUrl) : this.myUrl;
        return this;
    }

    public ExtensionDt setUrl(StringDt theUrl) {
        this.myUrl = theUrl;
        return this;
    }

    @Override
    public ExtensionDt setValue(IBaseDatatype theValue) {
        this.myValue = theValue;
        return this;
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return new ArrayList();
    }

    @Override
    public List<ExtensionDt> getExtension() {
        return this.getAllUndeclaredExtensions();
    }
}

