/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.api;

import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.valueset.BundleEntrySearchModeEnum;
import ca.uhn.fhir.model.valueset.BundleEntryTransactionMethodEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class ResourceMetadataKeyEnum<T> {
    public static final ResourceMetadataKeyEnum<InstantDt> DELETED_AT = new ResourceMetadataKeyEnum<InstantDt>("DELETED_AT"){

        @Override
        public InstantDt get(IResource theResource) {
            return ResourceMetadataKeyEnum.getInstantFromMetadataOrNullIfNone(theResource.getResourceMetadata(), 1.DELETED_AT);
        }

        @Override
        public void put(IResource theResource, InstantDt theObject) {
            theResource.getResourceMetadata().put(DELETED_AT, theObject);
        }
    };
    public static final ResourceMetadataKeyEnum<DecimalDt> ENTRY_SCORE = new ResourceMetadataKeyEnum<DecimalDt>("ENTRY_SCORE"){

        @Override
        public DecimalDt get(IResource theResource) {
            return ResourceMetadataKeyEnum.getDecimalFromMetadataOrNullIfNone(theResource.getResourceMetadata(), 2.ENTRY_SCORE);
        }

        @Override
        public void put(IResource theResource, DecimalDt theObject) {
            theResource.getResourceMetadata().put(ENTRY_SCORE, theObject);
        }
    };
    public static final ResourceMetadataKeyEnum<BundleEntrySearchModeEnum> ENTRY_SEARCH_MODE = new ResourceMetadataKeyEnum<BundleEntrySearchModeEnum>("ENTRY_SEARCH_MODE"){

        @Override
        public BundleEntrySearchModeEnum get(IResource theResource) {
            return (BundleEntrySearchModeEnum)ResourceMetadataKeyEnum.getEnumFromMetadataOrNullIfNone(theResource.getResourceMetadata(), 3.ENTRY_SEARCH_MODE, BundleEntrySearchModeEnum.class, BundleEntrySearchModeEnum.VALUESET_BINDER);
        }

        @Override
        public void put(IResource theResource, BundleEntrySearchModeEnum theObject) {
            theResource.getResourceMetadata().put(ENTRY_SEARCH_MODE, theObject);
        }
    };
    public static final ResourceMetadataKeyEnum<BundleEntryTransactionMethodEnum> ENTRY_TRANSACTION_METHOD = new ResourceMetadataKeyEnum<BundleEntryTransactionMethodEnum>("ENTRY_TRANSACTION_OPERATION"){

        @Override
        public BundleEntryTransactionMethodEnum get(IResource theResource) {
            return (BundleEntryTransactionMethodEnum)ResourceMetadataKeyEnum.getEnumFromMetadataOrNullIfNone(theResource.getResourceMetadata(), 4.ENTRY_TRANSACTION_METHOD, BundleEntryTransactionMethodEnum.class, BundleEntryTransactionMethodEnum.VALUESET_BINDER);
        }

        @Override
        public void put(IResource theResource, BundleEntryTransactionMethodEnum theObject) {
            theResource.getResourceMetadata().put(ENTRY_TRANSACTION_METHOD, theObject);
        }
    };
    public static final ResourceMetadataKeyEnum<String> LINK_ALTERNATE = new ResourceMetadataKeyEnum<String>("LINK_ALTERNATE"){

        @Override
        public String get(IResource theResource) {
            return ResourceMetadataKeyEnum.getStringFromMetadataOrNullIfNone(theResource.getResourceMetadata(), 5.LINK_ALTERNATE);
        }

        @Override
        public void put(IResource theResource, String theObject) {
            theResource.getResourceMetadata().put(LINK_ALTERNATE, theObject);
        }
    };
    public static final ResourceMetadataKeyEnum<String> LINK_SEARCH = new ResourceMetadataKeyEnum<String>("LINK_SEARCH"){

        @Override
        public String get(IResource theResource) {
            return ResourceMetadataKeyEnum.getStringFromMetadataOrNullIfNone(theResource.getResourceMetadata(), 6.LINK_SEARCH);
        }

        @Override
        public void put(IResource theResource, String theObject) {
            theResource.getResourceMetadata().put(LINK_SEARCH, theObject);
        }
    };
    public static final ResourceMetadataKeyEnum<IdDt> PREVIOUS_ID = new ResourceMetadataKeyEnum<IdDt>("PREVIOUS_ID"){

        @Override
        public IdDt get(IResource theResource) {
            return ResourceMetadataKeyEnum.getIdFromMetadataOrNullIfNone(theResource.getResourceMetadata(), 7.PREVIOUS_ID);
        }

        @Override
        public void put(IResource theResource, IdDt theObject) {
            theResource.getResourceMetadata().put(PREVIOUS_ID, theObject);
        }
    };
    public static final ResourceMetadataKeyEnum<List<IdDt>> PROFILES = new ResourceMetadataKeyEnum<List<IdDt>>("PROFILES"){

        @Override
        public List<IdDt> get(IResource theResource) {
            return ResourceMetadataKeyEnum.getIdListFromMetadataOrNullIfNone(theResource.getResourceMetadata(), 8.PROFILES);
        }

        @Override
        public void put(IResource theResource, List<IdDt> theObject) {
            theResource.getResourceMetadata().put(PROFILES, theObject);
        }
    };
    public static final ResourceMetadataKeyEnum<InstantDt> PUBLISHED = new ResourceMetadataKeyEnum<InstantDt>("PUBLISHED"){

        @Override
        public InstantDt get(IResource theResource) {
            return ResourceMetadataKeyEnum.getInstantFromMetadataOrNullIfNone(theResource.getResourceMetadata(), 9.PUBLISHED);
        }

        @Override
        public void put(IResource theResource, InstantDt theObject) {
            theResource.getResourceMetadata().put(PUBLISHED, theObject);
        }
    };
    public static final ResourceMetadataKeyEnum<List<BaseCodingDt>> SECURITY_LABELS = new ResourceMetadataKeyEnum<List<BaseCodingDt>>("SECURITY_LABELS"){

        @Override
        public List<BaseCodingDt> get(IResource resource) {
            Object obj = resource.getResourceMetadata().get(SECURITY_LABELS);
            if (obj == null) {
                return null;
            }
            try {
                List securityLabels = (List)obj;
                if (securityLabels.isEmpty()) {
                    return null;
                }
                return securityLabels;
            }
            catch (ClassCastException e) {
                throw new InternalErrorException("Found an object of type '" + obj.getClass().getCanonicalName() + "' in resource metadata for key SECURITY_LABELS - Expected " + BaseCodingDt.class.getCanonicalName());
            }
        }

        @Override
        public void put(IResource iResource, List<BaseCodingDt> labels) {
            iResource.getResourceMetadata().put(SECURITY_LABELS, labels);
        }
    };
    public static final ResourceMetadataKeyEnum<TagList> TAG_LIST = new ResourceMetadataKeyEnum<TagList>("TAG_LIST"){

        @Override
        public TagList get(IResource theResource) {
            Object retValObj = theResource.getResourceMetadata().get(TAG_LIST);
            if (retValObj == null) {
                return null;
            }
            if (retValObj instanceof TagList) {
                if (((TagList)retValObj).isEmpty()) {
                    return null;
                }
                return (TagList)retValObj;
            }
            throw new InternalErrorException("Found an object of type '" + retValObj.getClass().getCanonicalName() + "' in resource metadata for key " + 11.TAG_LIST.name() + " - Expected " + TagList.class.getCanonicalName());
        }

        @Override
        public void put(IResource theResource, TagList theObject) {
            theResource.getResourceMetadata().put(TAG_LIST, theObject);
        }
    };
    public static final ResourceMetadataKeyEnum<String> TITLE = new ResourceMetadataKeyEnum<String>("TITLE"){

        @Override
        public String get(IResource theResource) {
            return ResourceMetadataKeyEnum.getStringFromMetadataOrNullIfNone(theResource.getResourceMetadata(), 12.TITLE);
        }

        @Override
        public void put(IResource theResource, String theObject) {
            theResource.getResourceMetadata().put(TITLE, theObject);
        }
    };
    public static final ResourceMetadataKeyEnum<InstantDt> UPDATED = new ResourceMetadataKeyEnum<InstantDt>("UPDATED"){

        @Override
        public InstantDt get(IResource theResource) {
            return ResourceMetadataKeyEnum.getInstantFromMetadataOrNullIfNone(theResource.getResourceMetadata(), 13.UPDATED);
        }

        @Override
        public void put(IResource theResource, InstantDt theObject) {
            theResource.getResourceMetadata().put(UPDATED, theObject);
        }
    };
    public static final ResourceMetadataKeyEnum<String> VERSION = new ResourceMetadataKeyEnum<String>("VERSION"){

        @Override
        public String get(IResource theResource) {
            return ResourceMetadataKeyEnum.getStringFromMetadataOrNullIfNone(theResource.getResourceMetadata(), 14.VERSION);
        }

        @Override
        public void put(IResource theResource, String theObject) {
            theResource.getResourceMetadata().put(VERSION, theObject);
        }
    };
    @Deprecated
    public static final ResourceMetadataKeyEnum<IdDt> VERSION_ID = new ResourceMetadataKeyEnum<IdDt>("VERSION_ID"){

        @Override
        public IdDt get(IResource theResource) {
            return ResourceMetadataKeyEnum.getIdFromMetadataOrNullIfNone(theResource.getResourceMetadata(), 15.VERSION_ID);
        }

        @Override
        public void put(IResource theResource, IdDt theObject) {
            theResource.getResourceMetadata().put(VERSION_ID, theObject);
        }
    };
    private final String myValue;

    public ResourceMetadataKeyEnum(String theValue) {
        this.myValue = theValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceMetadataKeyEnum other = (ResourceMetadataKeyEnum)obj;
        return !(this.myValue == null ? other.myValue != null : !this.myValue.equals(other.myValue));
    }

    public abstract T get(IResource var1);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
        return result;
    }

    private String name() {
        return this.myValue;
    }

    public abstract void put(IResource var1, T var2);

    public String toString() {
        return this.myValue;
    }

    private static DecimalDt getDecimalFromMetadataOrNullIfNone(Map<ResourceMetadataKeyEnum<?>, Object> theResourceMetadata, ResourceMetadataKeyEnum<DecimalDt> theKey) {
        Object retValObj = theResourceMetadata.get(theKey);
        if (retValObj == null) {
            return null;
        }
        if (retValObj instanceof DecimalDt) {
            if (((DecimalDt)retValObj).isEmpty()) {
                return null;
            }
            return (DecimalDt)retValObj;
        }
        if (retValObj instanceof String) {
            if (StringUtils.isBlank((CharSequence)((String)retValObj))) {
                return null;
            }
            return new DecimalDt((String)retValObj);
        }
        if (retValObj instanceof Double) {
            return new DecimalDt((Double)retValObj);
        }
        throw new InternalErrorException("Found an object of type '" + retValObj.getClass().getCanonicalName() + "' in resource metadata for key " + super.name() + " - Expected " + InstantDt.class.getCanonicalName());
    }

    private static <T extends Enum<?>> T getEnumFromMetadataOrNullIfNone(Map<ResourceMetadataKeyEnum<?>, Object> theResourceMetadata, ResourceMetadataKeyEnum<T> theKey, Class<T> theEnumType, IValueSetEnumBinder<T> theBinder) {
        Object retValObj = theResourceMetadata.get(theKey);
        if (retValObj == null) {
            return null;
        }
        if (theEnumType.equals(retValObj.getClass())) {
            return (T)((Enum)retValObj);
        }
        if (retValObj instanceof String) {
            return theBinder.fromCodeString((String)retValObj);
        }
        throw new InternalErrorException("Found an object of type '" + retValObj.getClass().getCanonicalName() + "' in resource metadata for key " + super.name() + " - Expected " + InstantDt.class.getCanonicalName());
    }

    private static IdDt getIdFromMetadataOrNullIfNone(Map<ResourceMetadataKeyEnum<?>, Object> theResourceMetadata, ResourceMetadataKeyEnum<?> theKey) {
        return ResourceMetadataKeyEnum.toId(theKey, theResourceMetadata.get(theKey));
    }

    private static List<IdDt> getIdListFromMetadataOrNullIfNone(Map<ResourceMetadataKeyEnum<?>, Object> theResourceMetadata, ResourceMetadataKeyEnum<?> theKey) {
        Object retValObj = theResourceMetadata.get(theKey);
        if (retValObj == null) {
            return null;
        }
        if (retValObj instanceof List) {
            List retValList = (List)retValObj;
            for (Object next : retValList) {
                if (next instanceof IdDt) continue;
                ArrayList<IdDt> retVal = new ArrayList<IdDt>();
                for (Object nextVal : retValList) {
                    retVal.add(ResourceMetadataKeyEnum.toId(theKey, nextVal));
                }
                return Collections.unmodifiableList(retVal);
            }
            List retVal = retValList;
            return Collections.unmodifiableList(retVal);
        }
        return Collections.singletonList(ResourceMetadataKeyEnum.toId(theKey, retValObj));
    }

    private static InstantDt getInstantFromMetadataOrNullIfNone(Map<ResourceMetadataKeyEnum<?>, Object> theResourceMetadata, ResourceMetadataKeyEnum<InstantDt> theKey) {
        Object retValObj = theResourceMetadata.get(theKey);
        if (retValObj == null) {
            return null;
        }
        if (retValObj instanceof Date) {
            return new InstantDt((Date)retValObj);
        }
        if (retValObj instanceof InstantDt) {
            if (((InstantDt)retValObj).isEmpty()) {
                return null;
            }
            return (InstantDt)retValObj;
        }
        throw new InternalErrorException("Found an object of type '" + retValObj.getClass().getCanonicalName() + "' in resource metadata for key " + super.name() + " - Expected " + InstantDt.class.getCanonicalName());
    }

    private static StringDt getStringDtFromMetadataOrNullIfNone(Map<ResourceMetadataKeyEnum<?>, Object> theResourceMetadata, ResourceMetadataKeyEnum<StringDt> theKey) {
        Object retValObj = theResourceMetadata.get(theKey);
        if (retValObj == null) {
            return null;
        }
        if (retValObj instanceof String) {
            if (StringUtils.isBlank((CharSequence)((String)retValObj))) {
                return null;
            }
            return new StringDt((String)retValObj);
        }
        if (retValObj instanceof StringDt) {
            if (((StringDt)retValObj).isEmpty()) {
                return null;
            }
            return (StringDt)retValObj;
        }
        throw new InternalErrorException("Found an object of type '" + retValObj.getClass().getCanonicalName() + "' in resource metadata for key " + super.name() + " - Expected " + InstantDt.class.getCanonicalName());
    }

    private static String getStringFromMetadataOrNullIfNone(Map<ResourceMetadataKeyEnum<?>, Object> theResourceMetadata, ResourceMetadataKeyEnum<String> theKey) {
        Object retValObj = theResourceMetadata.get(theKey);
        if (retValObj == null) {
            return null;
        }
        if (retValObj instanceof String) {
            if (StringUtils.isBlank((CharSequence)((String)retValObj))) {
                return null;
            }
            return (String)retValObj;
        }
        throw new InternalErrorException("Found an object of type '" + retValObj.getClass().getCanonicalName() + "' in resource metadata for key " + super.name() + " - Expected " + String.class.getCanonicalName());
    }

    private static IdDt toId(ResourceMetadataKeyEnum<?> theKey, Object retValObj) {
        if (retValObj == null) {
            return null;
        }
        if (retValObj instanceof String) {
            if (StringUtils.isNotBlank((CharSequence)((String)retValObj))) {
                return new IdDt((String)retValObj);
            }
            return null;
        }
        if (retValObj instanceof IdDt) {
            if (((IdDt)retValObj).isEmpty()) {
                return null;
            }
            return (IdDt)retValObj;
        }
        if (retValObj instanceof Number) {
            return new IdDt(((Number)retValObj).toString());
        }
        throw new InternalErrorException("Found an object of type '" + retValObj.getClass().getCanonicalName() + "' in resource metadata for key " + super.name() + " - Expected " + IdDt.class.getCanonicalName());
    }
}

