/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.api;

import ca.uhn.fhir.model.api.BaseElement;
import ca.uhn.fhir.model.api.IElement;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class Tag
extends BaseElement
implements IElement {
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_SCHEME = "scheme";
    public static final String ATTR_TERM = "term";
    public static final String HL7_ORG_FHIR_TAG = "http://hl7.org/fhir/tag";
    public static final String HL7_ORG_PROFILE_TAG = "http://hl7.org/fhir/tag/profile";
    public static final String HL7_ORG_SECURITY_TAG = "http://hl7.org/fhir/tag/security";
    private String myLabel;
    private String myScheme;
    private String myTerm;

    @Deprecated
    public Tag() {
    }

    @Deprecated
    public Tag(String theTerm) {
        this((String)null, theTerm, null);
    }

    public Tag(String theScheme, String theTerm) {
        this.myScheme = theScheme;
        this.myTerm = theTerm;
    }

    public Tag(String theScheme, String theTerm, String theLabel) {
        this.myTerm = theTerm;
        this.myLabel = theLabel;
        this.myScheme = theScheme;
    }

    public Tag(URI theScheme, URI theTerm, String theLabel) {
        if (theScheme != null) {
            this.myScheme = theScheme.toASCIIString();
        }
        if (theTerm != null) {
            this.myTerm = theTerm.toASCIIString();
        }
        this.myLabel = theLabel;
    }

    public String getLabel() {
        return this.myLabel;
    }

    public String getScheme() {
        return this.myScheme;
    }

    public String getTerm() {
        return this.myTerm;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tag other = (Tag)obj;
        if (this.myScheme == null ? other.myScheme != null : !this.myScheme.equals(other.myScheme)) {
            return false;
        }
        return !(this.myTerm == null ? other.myTerm != null : !this.myTerm.equals(other.myTerm));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myScheme == null ? 0 : this.myScheme.hashCode());
        result = 31 * result + (this.myTerm == null ? 0 : this.myTerm.hashCode());
        return result;
    }

    @Override
    public boolean isEmpty() {
        return StringUtils.isBlank((CharSequence)this.myLabel) && StringUtils.isBlank((CharSequence)this.myScheme) && StringUtils.isBlank((CharSequence)this.myTerm);
    }

    @Deprecated
    public Tag setLabel(String theLabel) {
        this.myLabel = theLabel;
        return this;
    }

    @Deprecated
    public Tag setScheme(String theScheme) {
        this.myScheme = theScheme;
        return this;
    }

    @Deprecated
    public Tag setTerm(String theTerm) {
        this.myTerm = theTerm;
        return this;
    }

    public String toHeaderValue() {
        StringBuilder b = new StringBuilder();
        b.append(this.getTerm());
        if (StringUtils.isNotBlank((CharSequence)this.getLabel())) {
            b.append("; label=\"").append(this.getLabel()).append('\"');
        }
        if (StringUtils.isNotBlank((CharSequence)this.getScheme())) {
            b.append("; scheme=\"").append(this.getScheme()).append('\"');
        }
        return b.toString();
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("Scheme", (Object)this.myScheme);
        b.append("Term", (Object)this.myTerm);
        b.append("Label", (Object)this.myLabel);
        return b.toString();
    }
}

