/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.api;

import ca.uhn.fhir.model.api.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.instance.model.IBase;

public class TagList
implements Set<Tag>,
Serializable,
IBase {
    public static final String ATTR_CATEGORY = "category";
    public static final String ELEMENT_NAME = "TagList";
    public static final String ELEMENT_NAME_LC = "TagList".toLowerCase();
    private static final long serialVersionUID = 1L;
    private transient List<Tag> myOrderedTags;
    private LinkedHashSet<Tag> myTagSet = new LinkedHashSet();

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TagList[").append(this.size()).append(" tag(s)]");
        for (Tag next : this) {
            b.append("\n * ").append(next.toString());
        }
        return b.toString();
    }

    @Override
    public boolean add(Tag theE) {
        this.myOrderedTags = null;
        return this.myTagSet.add(theE);
    }

    @Override
    public boolean addAll(Collection<? extends Tag> theC) {
        this.myOrderedTags = null;
        return this.myTagSet.addAll(theC);
    }

    @Deprecated
    public Tag addTag() {
        this.myOrderedTags = null;
        return this.addTag(null, null, null);
    }

    public Tag addTag(String theScheme, String theTerm) {
        Tag retVal = new Tag(theScheme, theTerm);
        this.add(retVal);
        this.myOrderedTags = null;
        return retVal;
    }

    public Tag addTag(String theScheme, String theTerm, String theLabel) {
        Tag retVal = new Tag(theScheme, theTerm, theLabel);
        this.add(retVal);
        this.myOrderedTags = null;
        return retVal;
    }

    @Override
    public void clear() {
        this.myOrderedTags = null;
        this.myTagSet.clear();
    }

    @Override
    public boolean contains(Object theO) {
        return this.myTagSet.contains(theO);
    }

    @Override
    public boolean containsAll(Collection<?> theC) {
        return this.myTagSet.containsAll(theC);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TagList other = (TagList)obj;
        return !(this.myTagSet == null ? other.myTagSet != null : !this.myTagSet.equals(other.myTagSet));
    }

    public Tag get(int theIndex) {
        if (this.myOrderedTags == null) {
            this.myOrderedTags = new ArrayList<Tag>();
            for (Tag next : this.myTagSet) {
                this.myOrderedTags.add(next);
            }
        }
        return this.myOrderedTags.get(theIndex);
    }

    public Tag getTag(String theScheme, String theTerm) {
        for (Tag next : this) {
            if (!theScheme.equals(next.getScheme()) || !theTerm.equals(next.getTerm())) continue;
            return next;
        }
        return null;
    }

    public List<Tag> getTagsWithScheme(String theScheme) {
        ArrayList<Tag> retVal = new ArrayList<Tag>();
        for (Tag next : this) {
            if (!theScheme.equals(next.getScheme())) continue;
            retVal.add(next);
        }
        return retVal;
    }

    @Override
    public int hashCode() {
        return this.myTagSet.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.myTagSet.isEmpty();
    }

    @Override
    public Iterator<Tag> iterator() {
        return this.myTagSet.iterator();
    }

    @Override
    public boolean remove(Object theO) {
        this.myOrderedTags = null;
        return this.myTagSet.remove(theO);
    }

    @Override
    public boolean removeAll(Collection<?> theC) {
        this.myOrderedTags = null;
        return this.myTagSet.removeAll(theC);
    }

    @Override
    public boolean retainAll(Collection<?> theC) {
        this.myOrderedTags = null;
        return this.myTagSet.retainAll(theC);
    }

    @Override
    public int size() {
        return this.myTagSet.size();
    }

    @Override
    public Object[] toArray() {
        return this.myTagSet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] theA) {
        return this.myTagSet.toArray(theA);
    }
}

