/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.base.composite;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.client.BaseClient;
import ca.uhn.fhir.rest.client.api.IRestfulClient;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResourceReferenceDt
extends BaseIdentifiableElement
implements IBaseDatatype {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseResourceReferenceDt.class);
    private IResource myResource;

    public BaseResourceReferenceDt() {
    }

    public BaseResourceReferenceDt(IResource theResource) {
        this.myResource = theResource;
        this.setReference(theResource.getId());
    }

    public abstract StringDt getDisplayElement();

    public abstract IdDt getReference();

    public IResource getResource() {
        return this.myResource;
    }

    @Override
    protected boolean isBaseEmpty() {
        return super.isBaseEmpty() && this.myResource == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResource loadResource(IRestfulClient theClient) throws IOException {
        if (this.myResource != null) {
            return this.myResource;
        }
        IdDt resourceId = this.getReference();
        if (resourceId == null) {
            throw new IllegalStateException("Reference has no resource ID defined");
        }
        String resourceUrl = resourceId.getValue();
        ourLog.debug("Loading resource at URL: {}", (Object)resourceUrl);
        HttpClient httpClient = theClient.getHttpClient();
        FhirContext context = theClient.getFhirContext();
        if (!resourceUrl.startsWith("http")) {
            resourceUrl = theClient.getServerBase() + resourceUrl;
        }
        HttpGet get = new HttpGet(resourceUrl);
        HttpResponse response = httpClient.execute((HttpUriRequest)get);
        try {
            IParser parser = context.newXmlParser();
            Reader responseReader = BaseClient.createReaderFromResponse(response);
            this.myResource = parser.parseResource(responseReader);
        }
        finally {
            if (response instanceof CloseableHttpResponse) {
                ((CloseableHttpResponse)response).close();
            }
        }
        return this.myResource;
    }

    public abstract BaseResourceReferenceDt setReference(IdDt var1);

    public void setResource(IResource theResource) {
        this.myResource = theResource;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("reference", (Object)this.getReference().getValueAsString());
        b.append("loaded", this.getResource() != null);
        return b.toString();
    }
}

