/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum SecurityEventObjectSensitivityEnum {

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/security-event-sensitivity";
    public static final String VALUESET_NAME = "Security Event Object Sensitivity";
    private static Map<String, SecurityEventObjectSensitivityEnum> CODE_TO_ENUM = new HashMap<String, SecurityEventObjectSensitivityEnum>();
    private static Map<String, Map<String, SecurityEventObjectSensitivityEnum>> SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, SecurityEventObjectSensitivityEnum>>();
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<SecurityEventObjectSensitivityEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public SecurityEventObjectSensitivityEnum forCode(String theCode) {
        SecurityEventObjectSensitivityEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private SecurityEventObjectSensitivityEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        for (SecurityEventObjectSensitivityEnum next : SecurityEventObjectSensitivityEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<SecurityEventObjectSensitivityEnum>(){

            @Override
            public String toCodeString(SecurityEventObjectSensitivityEnum theEnum) {
                return theEnum.getCode();
            }

            @Override
            public String toSystemString(SecurityEventObjectSensitivityEnum theEnum) {
                return theEnum.getSystem();
            }

            @Override
            public SecurityEventObjectSensitivityEnum fromCodeString(String theCodeString) {
                return (SecurityEventObjectSensitivityEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            @Override
            public SecurityEventObjectSensitivityEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (SecurityEventObjectSensitivityEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

