/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.primitive;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.primitive.CodeDt;

@DatatypeDef(name="code", isSpecialization=true)
public class BoundCodeDt<T extends Enum<?>>
extends CodeDt {
    private IValueSetEnumBinder<T> myBinder;

    public BoundCodeDt(IValueSetEnumBinder<T> theBinder) {
        this.myBinder = theBinder;
    }

    public BoundCodeDt(IValueSetEnumBinder<T> theBinder, T theValue) {
        this.myBinder = theBinder;
        this.setValueAsEnum(theValue);
    }

    public void setValueAsEnum(T theValue) {
        if (theValue == null) {
            this.setValue(null);
        } else {
            this.setValue(this.myBinder.toCodeString(theValue));
        }
    }

    public T getValueAsEnum() {
        T retVal = this.myBinder.fromCodeString((String)this.getValue());
        if (retVal == null) {
            // empty if block
        }
        return retVal;
    }
}

