/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.primitive;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.SimpleSetter;
import ca.uhn.fhir.model.primitive.BaseDateTimeDt;
import java.util.Date;

@DatatypeDef(name="date")
public class DateDt
extends BaseDateTimeDt {
    public static final TemporalPrecisionEnum DEFAULT_PRECISION = TemporalPrecisionEnum.DAY;

    public DateDt() {
    }

    @SimpleSetter(suffix="WithDayPrecision")
    public DateDt(@SimpleSetter.Parameter(name="theDate") Date theDate) {
        super(theDate, DEFAULT_PRECISION);
    }

    @SimpleSetter
    public DateDt(@SimpleSetter.Parameter(name="theDate") Date theDate, @SimpleSetter.Parameter(name="thePrecision") TemporalPrecisionEnum thePrecision) {
        super(theDate, thePrecision);
    }

    public DateDt(String theDate) {
        super(theDate);
    }

    @Override
    boolean isPrecisionAllowed(TemporalPrecisionEnum thePrecision) {
        switch (thePrecision) {
            case YEAR: 
            case MONTH: 
            case DAY: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected TemporalPrecisionEnum getDefaultPrecisionForDatatype() {
        return DEFAULT_PRECISION;
    }
}

