/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.primitive;

import ca.uhn.fhir.model.api.IPrimitiveDatatype;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.SimpleSetter;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.util.UrlUtil;
import java.math.BigDecimal;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hl7.fhir.instance.model.IBaseResource;
import org.hl7.fhir.instance.model.api.IAnyResource;

@DatatypeDef(name="id")
public class IdDt
extends UriDt
implements IPrimitiveDatatype<String> {
    private String myBaseUrl;
    private boolean myHaveComponentParts;
    private String myResourceType;
    private String myUnqualifiedId;
    private String myUnqualifiedVersionId;
    private volatile String myValue;

    public IdDt() {
    }

    public IdDt(BigDecimal thePid) {
        if (thePid != null) {
            this.setValue(IdDt.toPlainStringWithNpeThrowIfNeeded(thePid));
        } else {
            this.setValue(null);
        }
    }

    public IdDt(long theId) {
        this.setValue(Long.toString(theId));
    }

    @SimpleSetter
    public IdDt(@SimpleSetter.Parameter(name="theId") String theValue) {
        this.setValue(theValue);
    }

    public IdDt(String theResourceType, BigDecimal theIdPart) {
        this(theResourceType, IdDt.toPlainStringWithNpeThrowIfNeeded(theIdPart));
    }

    public IdDt(String theResourceType, Long theIdPart) {
        this(theResourceType, IdDt.toPlainStringWithNpeThrowIfNeeded(theIdPart));
    }

    public IdDt(String theResourceType, String theId) {
        this(theResourceType, theId, null);
    }

    public IdDt(String theResourceType, String theId, String theVersionId) {
        this(null, theResourceType, theId, theVersionId);
    }

    public IdDt(String theBaseUrl, String theResourceType, String theId, String theVersionId) {
        this.myBaseUrl = theBaseUrl;
        this.myResourceType = theResourceType;
        this.myUnqualifiedId = theId;
        this.myUnqualifiedVersionId = (String)StringUtils.defaultIfBlank((CharSequence)theVersionId, null);
        this.myHaveComponentParts = true;
    }

    public IdDt(UriDt theUrl) {
        this.setValue(theUrl.getValueAsString());
    }

    @Deprecated
    public BigDecimal asBigDecimal() {
        return this.getIdPartAsBigDecimal();
    }

    public boolean equalsIgnoreBase(IdDt theId) {
        if (theId == null) {
            return false;
        }
        if (theId.isEmpty()) {
            return this.isEmpty();
        }
        return ObjectUtils.equals((Object)this.getResourceType(), (Object)theId.getResourceType()) && ObjectUtils.equals((Object)this.getIdPart(), (Object)theId.getIdPart()) && ObjectUtils.equals((Object)this.getVersionIdPart(), (Object)theId.getVersionIdPart());
    }

    @Override
    public boolean equals(Object theArg0) {
        if (!(theArg0 instanceof IdDt)) {
            return false;
        }
        IdDt id = (IdDt)theArg0;
        return StringUtils.equals((CharSequence)this.getValueAsString(), (CharSequence)id.getValueAsString());
    }

    @Override
    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.getValueAsString());
        return b.toHashCode();
    }

    public String getBaseUrl() {
        return this.myBaseUrl;
    }

    public String getIdPart() {
        return this.myUnqualifiedId;
    }

    public BigDecimal getIdPartAsBigDecimal() {
        String val = this.getIdPart();
        if (StringUtils.isBlank((CharSequence)val)) {
            return null;
        }
        return new BigDecimal(val);
    }

    public Long getIdPartAsLong() {
        String val = this.getIdPart();
        if (StringUtils.isBlank((CharSequence)val)) {
            return null;
        }
        return Long.parseLong(val);
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    @Override
    public String getValue() {
        if (this.myValue == null && this.myHaveComponentParts) {
            String value;
            StringBuilder b = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)this.myBaseUrl)) {
                b.append(this.myBaseUrl);
                if (this.myBaseUrl.charAt(this.myBaseUrl.length() - 1) != '/') {
                    b.append('/');
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.myResourceType)) {
                b.append(this.myResourceType);
            }
            if (b.length() > 0) {
                b.append('/');
            }
            b.append(this.myUnqualifiedId);
            if (StringUtils.isNotBlank((CharSequence)this.myUnqualifiedVersionId)) {
                b.append('/');
                b.append("_history");
                b.append('/');
                b.append(this.myUnqualifiedVersionId);
            }
            this.myValue = value = b.toString();
        }
        return this.myValue;
    }

    @Override
    public String getValueAsString() {
        return this.getValue();
    }

    public String getVersionIdPart() {
        return this.myUnqualifiedVersionId;
    }

    public Long getVersionIdPartAsLong() {
        if (!this.hasVersionIdPart()) {
            return null;
        }
        return Long.parseLong(this.getVersionIdPart());
    }

    public boolean hasBaseUrl() {
        return StringUtils.isNotBlank((CharSequence)this.myBaseUrl);
    }

    public boolean hasIdPart() {
        return StringUtils.isNotBlank((CharSequence)this.getIdPart());
    }

    public boolean hasResourceType() {
        return StringUtils.isNotBlank((CharSequence)this.myResourceType);
    }

    public boolean hasVersionIdPart() {
        return StringUtils.isNotBlank((CharSequence)this.getVersionIdPart());
    }

    public boolean isAbsolute() {
        if (StringUtils.isBlank((CharSequence)this.getValue())) {
            return false;
        }
        return UrlUtil.isAbsolute(this.getValue());
    }

    public boolean isIdPartValidLong() {
        String id = this.getIdPart();
        if (StringUtils.isBlank((CharSequence)id)) {
            return false;
        }
        for (int i = 0; i < id.length(); ++i) {
            if (Character.isDigit(id.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isLocal() {
        return this.myUnqualifiedId != null && !this.myUnqualifiedId.isEmpty() && this.myUnqualifiedId.charAt(0) == '#';
    }

    @Override
    public void setId(IdDt theId) {
        this.setValue(theId.getValue());
    }

    public IdDt setValue(String theValue) throws DataFormatException {
        this.myValue = theValue;
        this.myHaveComponentParts = false;
        if (StringUtils.isBlank((CharSequence)theValue)) {
            this.myBaseUrl = null;
            this.myValue = null;
            this.myUnqualifiedId = null;
            this.myUnqualifiedVersionId = null;
            this.myResourceType = null;
        } else if (theValue.charAt(0) == '#') {
            this.myValue = theValue;
            this.myUnqualifiedId = theValue;
            this.myUnqualifiedVersionId = null;
            this.myResourceType = null;
            this.myHaveComponentParts = true;
        } else {
            int idIndex;
            int vidIndex = theValue.indexOf("/_history/");
            if (vidIndex != -1) {
                this.myUnqualifiedVersionId = theValue.substring(vidIndex + "/_history/".length());
                idIndex = theValue.lastIndexOf(47, vidIndex - 1);
                this.myUnqualifiedId = theValue.substring(idIndex + 1, vidIndex);
            } else {
                idIndex = theValue.lastIndexOf(47);
                this.myUnqualifiedId = theValue.substring(idIndex + 1);
                this.myUnqualifiedVersionId = null;
            }
            this.myBaseUrl = null;
            if (idIndex <= 0) {
                this.myResourceType = null;
            } else {
                int typeIndex = theValue.lastIndexOf(47, idIndex - 1);
                if (typeIndex == -1) {
                    this.myResourceType = theValue.substring(0, idIndex);
                } else {
                    this.myResourceType = theValue.substring(typeIndex + 1, idIndex);
                    if (typeIndex > 4) {
                        this.myBaseUrl = theValue.substring(0, typeIndex);
                    }
                }
            }
        }
        return this;
    }

    @Override
    public void setValueAsString(String theValue) throws DataFormatException {
        this.setValue(theValue);
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    public IdDt toUnqualified() {
        return new IdDt(this.getResourceType(), this.getIdPart(), this.getVersionIdPart());
    }

    public IdDt toUnqualifiedVersionless() {
        return new IdDt(this.getResourceType(), this.getIdPart());
    }

    public IdDt toVersionless() {
        return new IdDt(this.getBaseUrl(), this.getResourceType(), this.getIdPart(), null);
    }

    public IdDt withResourceType(String theResourceName) {
        return new IdDt(theResourceName, this.getIdPart(), this.getVersionIdPart());
    }

    public IdDt withServerBase(String theServerBase, String theResourceType) {
        return new IdDt(theServerBase, theResourceType, this.getIdPart(), this.getVersionIdPart());
    }

    public IdDt withVersion(String theVersion) {
        Validate.notBlank((CharSequence)theVersion, (String)"Version may not be null or empty", (Object[])new Object[0]);
        String existingValue = this.getValue();
        int i = existingValue.indexOf("_history");
        String value = i > 1 ? existingValue.substring(0, i - 1) : existingValue;
        return new IdDt(value + '/' + "_history" + '/' + theVersion);
    }

    private static String toPlainStringWithNpeThrowIfNeeded(BigDecimal theIdPart) {
        if (theIdPart == null) {
            throw new NullPointerException("BigDecimal ID can not be null");
        }
        return theIdPart.toPlainString();
    }

    private static String toPlainStringWithNpeThrowIfNeeded(Long theIdPart) {
        if (theIdPart == null) {
            throw new NullPointerException("Long ID can not be null");
        }
        return theIdPart.toString();
    }

    @Override
    public boolean isEmpty() {
        return StringUtils.isBlank((CharSequence)this.getValue());
    }

    public void applyTo(IBaseResource theResouce) {
        if (theResouce == null) {
            throw new NullPointerException("theResource can not be null");
        }
        if (theResouce instanceof IResource) {
            ((IResource)theResouce).setId(new IdDt(this.getValue()));
        } else if (theResouce instanceof IAnyResource) {
            ((IAnyResource)theResouce).setId(this.getIdPart());
        } else {
            throw new IllegalArgumentException("Unknown resource class type, does not implement IResource or extend Resource");
        }
    }

    public static IdDt of(IBaseResource theResouce) {
        if (theResouce == null) {
            throw new NullPointerException("theResource can not be null");
        }
        if (theResouce instanceof IResource) {
            return ((IResource)theResouce).getId();
        }
        if (theResouce instanceof IAnyResource) {
            throw new UnsupportedOperationException();
        }
        throw new IllegalArgumentException("Unknown resource class type, does not implement IResource or extend Resource");
    }
}

