/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.primitive;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.model.api.BasePrimitive;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.SimpleSetter;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.util.XmlUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

@DatatypeDef(name="xhtml")
public class XhtmlDt
extends BasePrimitive<List<XMLEvent>> {
    public XhtmlDt() {
    }

    @Override
    public boolean isEmpty() {
        return super.isBaseEmpty() && (this.getValue() == null || ((List)this.getValue()).isEmpty());
    }

    @SimpleSetter
    public XhtmlDt(@SimpleSetter.Parameter(name="theTextDiv") String theTextDiv) {
        this.setValueAsString(theTextDiv);
    }

    @Override
    public void setValueAsString(String theValue) throws DataFormatException {
        if (theValue == null || theValue.isEmpty()) {
            super.setValueAsString(null);
        } else {
            String value = theValue.trim();
            if (value.charAt(0) != '<') {
                value = "<div>" + value + "</div>";
            }
            super.setValueAsString(value);
        }
    }

    public boolean hasContent() {
        return this.getValue() != null && ((List)this.getValue()).size() > 0;
    }

    @Override
    protected List<XMLEvent> parse(String theValue) {
        String val = theValue.trim();
        if (!val.startsWith("<")) {
            val = "<div>" + val + "</div>";
        }
        if (val.startsWith("<?") && val.endsWith("?>")) {
            return null;
        }
        try {
            ArrayList<XMLEvent> value = new ArrayList<XMLEvent>();
            StringReader reader = new StringReader(val);
            XMLEventReader er = XmlUtil.createXmlReader(reader);
            boolean first = true;
            while (er.hasNext()) {
                XMLEvent next = er.nextEvent();
                if (first) {
                    first = false;
                    continue;
                }
                if (!er.hasNext()) continue;
                value.add(next);
            }
            return value;
        }
        catch (XMLStreamException e) {
            throw new DataFormatException("String does not appear to be valid XML/XHTML (error is \"" + e.getMessage() + "\"): " + theValue, e);
        }
        catch (FactoryConfigurationError e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    protected String encode(List<XMLEvent> theValue) {
        try {
            StringWriter w = new StringWriter();
            XMLEventWriter ew = XmlUtil.createXmlWriter(w);
            for (XMLEvent next : (List)this.getValue()) {
                if (next.isCharacters()) {
                    ew.add(next);
                    continue;
                }
                ew.add(next);
            }
            ew.close();
            return w.toString();
        }
        catch (XMLStreamException e) {
            throw new DataFormatException("Problem with the contained XML events", e);
        }
        catch (FactoryConfigurationError e) {
            throw new ConfigurationException(e);
        }
    }
}

