/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeChildChoiceDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.BundleEntry;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.base.composite.BaseResourceReferenceDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.IBase;
import org.hl7.fhir.instance.model.IBaseResource;
import org.hl7.fhir.instance.model.IPrimitiveType;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseParser
implements IParser {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseParser.class);
    private ContainedResources myContainedResources;
    private FhirContext myContext;
    private boolean mySuppressNarratives;
    private String myServerBaseUrl;

    public BaseParser(FhirContext theContext) {
        this.myContext = theContext;
    }

    private void containResourcesForEncoding(ContainedResources theContained, IBaseResource theResource, IBaseResource theTarget) {
        IBaseResource potentialTarget;
        IBaseResource resource;
        String nextId;
        List<IBaseResource> containedResources;
        HashSet<String> allIds = new HashSet<String>();
        HashMap<String, IBaseResource> existingIdToContainedResource = null;
        if (theTarget instanceof IResource) {
            containedResources = ((IResource)theTarget).getContained().getContainedResources();
            for (IResource iResource : containedResources) {
                nextId = iResource.getId().getValue();
                if (!StringUtils.isNotBlank((CharSequence)nextId)) continue;
                if (!nextId.startsWith("#")) {
                    nextId = '#' + nextId;
                }
                allIds.add(nextId);
                if (existingIdToContainedResource == null) {
                    existingIdToContainedResource = new HashMap();
                }
                existingIdToContainedResource.put(nextId, iResource);
            }
        } else if (theTarget instanceof IDomainResource) {
            containedResources = ((IDomainResource)((Object)theTarget)).getContained();
            for (IAnyResource iAnyResource : containedResources) {
                nextId = iAnyResource.getId();
                if (!StringUtils.isNotBlank((CharSequence)nextId)) continue;
                allIds.add(nextId);
                if (existingIdToContainedResource == null) {
                    existingIdToContainedResource = new HashMap<String, IBaseResource>();
                }
                existingIdToContainedResource.put(nextId, iAnyResource);
            }
        }
        List<IBase> allElements = this.myContext.newTerser().getAllPopulatedChildElementsOfType(theResource, BaseResourceReferenceDt.class);
        for (BaseResourceReferenceDt baseResourceReferenceDt : allElements) {
            resource = baseResourceReferenceDt.getResource();
            if (resource != null) {
                if (!resource.getId().isEmpty() && !resource.getId().isLocal()) continue;
                theContained.addContained(resource);
                this.containResourcesForEncoding(theContained, resource, theTarget);
                continue;
            }
            if (!baseResourceReferenceDt.getReference().isLocal() || existingIdToContainedResource == null || (potentialTarget = (IBaseResource)existingIdToContainedResource.remove(baseResourceReferenceDt.getReference().getValue())) == null) continue;
            theContained.addContained(baseResourceReferenceDt.getReference(), potentialTarget);
            this.containResourcesForEncoding(theContained, potentialTarget, theTarget);
        }
        allElements = this.myContext.newTerser().getAllPopulatedChildElementsOfType(theResource, IReference.class);
        for (IReference iReference : allElements) {
            resource = iReference.getResource();
            if (resource != null) {
                if (!resource.getIdElement().isEmpty() && !resource.getId().startsWith("#")) continue;
                theContained.addContained(resource);
                this.containResourcesForEncoding(theContained, resource, theTarget);
                continue;
            }
            if (iReference.getReference() == null || !iReference.getReference().startsWith("#") || existingIdToContainedResource == null || (potentialTarget = (IBaseResource)existingIdToContainedResource.remove(iReference.getReference())) == null) continue;
            theContained.addContained(potentialTarget);
            this.containResourcesForEncoding(theContained, potentialTarget, theTarget);
        }
    }

    protected void containResourcesForEncoding(IBaseResource theResource) {
        ContainedResources contained = new ContainedResources();
        this.containResourcesForEncoding(contained, theResource, theResource);
        this.myContainedResources = contained;
    }

    protected String determineReferenceText(BaseResourceReferenceDt theRef) {
        IdDt ref = theRef.getReference();
        if (StringUtils.isBlank((CharSequence)ref.getIdPart())) {
            String reference = ref.getValue();
            if (theRef.getResource() != null) {
                IdDt containedId = this.getContainedResources().getResourceId(theRef.getResource());
                if (containedId != null && !containedId.isEmpty()) {
                    reference = containedId.isLocal() ? containedId.getValue() : "#" + containedId.getValue();
                } else if (theRef.getResource().getId() != null && theRef.getResource().getId().hasIdPart()) {
                    reference = theRef.getResource().getId().getValue();
                }
            }
            return reference;
        }
        if (StringUtils.isNotBlank((CharSequence)this.myServerBaseUrl) && StringUtils.equals((CharSequence)this.myServerBaseUrl, (CharSequence)ref.getBaseUrl())) {
            String reference = ref.toUnqualifiedVersionless().getValue();
            return reference;
        }
        String reference = ref.toVersionless().getValue();
        return reference;
    }

    @Override
    public IParser setServerBaseUrl(String theUrl) {
        this.myServerBaseUrl = StringUtils.isNotBlank((CharSequence)theUrl) ? theUrl : null;
        return this;
    }

    protected String determineResourceBaseUrl(String bundleBaseUrl, BundleEntry theEntry) {
        IResource resource = theEntry.getResource();
        if (resource == null) {
            return null;
        }
        String resourceBaseUrl = null;
        if (resource.getId() != null && resource.getId().hasBaseUrl() && !resource.getId().getBaseUrl().equals(bundleBaseUrl)) {
            resourceBaseUrl = resource.getId().getBaseUrl();
        }
        return resourceBaseUrl;
    }

    protected abstract <T extends IBaseResource> T doParseResource(Class<T> var1, Reader var2) throws DataFormatException;

    @Override
    public String encodeBundleToString(Bundle theBundle) throws DataFormatException {
        if (theBundle == null) {
            throw new NullPointerException("Bundle can not be null");
        }
        StringWriter stringWriter = new StringWriter();
        try {
            this.encodeBundleToWriter(theBundle, stringWriter);
        }
        catch (IOException e) {
            throw new Error("Encountered IOException during write to string - This should not happen!");
        }
        return stringWriter.toString();
    }

    @Override
    public String encodeResourceToString(IBaseResource theResource) throws DataFormatException {
        StringWriter stringWriter = new StringWriter();
        try {
            this.encodeResourceToWriter(theResource, stringWriter);
        }
        catch (IOException e) {
            throw new Error("Encountered IOException during write to string - This should not happen!");
        }
        return ((Object)stringWriter).toString();
    }

    @Override
    public String encodeTagListToString(TagList theTagList) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.encodeTagListToWriter(theTagList, stringWriter);
        }
        catch (IOException e) {
            throw new Error("Encountered IOException during write to string - This should not happen!");
        }
        return ((Object)stringWriter).toString();
    }

    protected String fixContainedResourceId(String theValue) {
        if (StringUtils.isNotBlank((CharSequence)theValue) && theValue.charAt(0) == '#') {
            return theValue.substring(1);
        }
        return theValue;
    }

    ContainedResources getContainedResources() {
        return this.myContainedResources;
    }

    public boolean getSuppressNarratives() {
        return this.mySuppressNarratives;
    }

    @Override
    public Bundle parseBundle(Reader theReader) {
        return this.parseBundle(null, theReader);
    }

    @Override
    public Bundle parseBundle(String theXml) throws ConfigurationException, DataFormatException {
        StringReader reader = new StringReader(theXml);
        return this.parseBundle(reader);
    }

    @Override
    public <T extends IBaseResource> T parseResource(Class<T> theResourceType, Reader theReader) throws DataFormatException {
        T retVal = this.doParseResource(theResourceType, theReader);
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition((IBaseResource)retVal);
        if ("Bundle".equals(def.getName())) {
            List<IBase> base = def.getChildByName("base").getAccessor().getValues(retVal);
            if (base != null && base.size() > 0) {
                IPrimitiveType baseType = (IPrimitiveType)base.get(0);
                IResource res = (IResource)retVal;
                res.setId(new IdDt(baseType.getValueAsString(), def.getName(), res.getId().getIdPart(), res.getId().getVersionIdPart()));
            }
            BaseRuntimeChildDefinition entryChild = def.getChildByName("entry");
            BaseRuntimeElementCompositeDefinition entryDef = (BaseRuntimeElementCompositeDefinition)entryChild.getChildByName("entry");
            List<IBase> entries = entryChild.getAccessor().getValues(retVal);
            if (entries != null) {
                for (IBase nextEntry : entries) {
                    List<IBase> entryBase = entryDef.getChildByName("base").getAccessor().getValues(nextEntry);
                    if (entryBase == null || entryBase.isEmpty()) {
                        entryBase = base;
                    }
                    if (entryBase == null || entryBase.size() <= 0) continue;
                    IPrimitiveType baseType = (IPrimitiveType)entryBase.get(0);
                    List<IBase> entryResources = entryDef.getChildByName("resource").getAccessor().getValues(nextEntry);
                    if (entryResources == null || entryResources.size() <= 0) continue;
                    IResource res = (IResource)entryResources.get(0);
                    RuntimeResourceDefinition resDef = this.myContext.getResourceDefinition(res);
                    String versionIdPart = res.getId().getVersionIdPart();
                    if (StringUtils.isBlank((CharSequence)versionIdPart)) {
                        versionIdPart = ResourceMetadataKeyEnum.VERSION.get(res);
                    }
                    res.setId(new IdDt(baseType.getValueAsString(), resDef.getName(), res.getId().getIdPart(), versionIdPart));
                }
            }
        }
        return retVal;
    }

    @Override
    public <T extends IBaseResource> T parseResource(Class<T> theResourceType, String theMessageString) {
        StringReader reader = new StringReader(theMessageString);
        return this.parseResource(theResourceType, reader);
    }

    @Override
    public IResource parseResource(Reader theReader) throws ConfigurationException, DataFormatException {
        return (IResource)this.parseResource(null, theReader);
    }

    @Override
    public IResource parseResource(String theMessageString) throws ConfigurationException, DataFormatException {
        return (IResource)this.parseResource(null, theMessageString);
    }

    @Override
    public TagList parseTagList(String theString) {
        return this.parseTagList(new StringReader(theString));
    }

    @Override
    public IParser setSuppressNarratives(boolean theSuppressNarratives) {
        this.mySuppressNarratives = theSuppressNarratives;
        return this;
    }

    protected void throwExceptionForUnknownChildType(BaseRuntimeChildDefinition nextChild, Class<? extends IBase> theType) {
        if (nextChild instanceof BaseRuntimeDeclaredChildDefinition) {
            StringBuilder b = new StringBuilder();
            b.append(((BaseRuntimeDeclaredChildDefinition)nextChild).getElementName());
            b.append(" has type ");
            b.append(theType.getName());
            b.append(" but this is not a valid type for this element");
            if (nextChild instanceof RuntimeChildChoiceDefinition) {
                RuntimeChildChoiceDefinition choice = (RuntimeChildChoiceDefinition)nextChild;
                b.append(" - Expected one of: " + choice.getValidChildTypes());
            }
            throw new DataFormatException(b.toString());
        }
        throw new DataFormatException(nextChild + " has no child of type " + theType);
    }

    protected static <T> List<T> extractMetadataListNotNull(IResource resource, ResourceMetadataKeyEnum<List<T>> key) {
        List<T> securityLabels = key.get(resource);
        if (securityLabels == null) {
            securityLabels = Collections.emptyList();
        }
        return securityLabels;
    }

    static class ContainedResources {
        private long myNextContainedId = 1L;
        private List<IBaseResource> myResources = new ArrayList<IBaseResource>();
        private IdentityHashMap<IBaseResource, IdDt> myResourceToId = new IdentityHashMap();

        ContainedResources() {
        }

        public void addContained(IBaseResource theResource) {
            if (this.myResourceToId.containsKey(theResource)) {
                return;
            }
            IdDt newId = theResource instanceof IResource && ((IResource)theResource).getId().isLocal() ? ((IResource)theResource).getId() : (theResource instanceof IAnyResource && ((IAnyResource)theResource).getId() != null && ((IAnyResource)theResource).getId().startsWith("#") ? new IdDt(((IAnyResource)theResource).getId()) : new IdDt(this.myNextContainedId++));
            this.myResourceToId.put(theResource, newId);
            this.myResources.add(theResource);
        }

        public void addContained(IdDt theId, IBaseResource theResource) {
            this.myResourceToId.put(theResource, theId);
            this.myResources.add(theResource);
        }

        public List<IBaseResource> getContainedResources() {
            return this.myResources;
        }

        public IdDt getResourceId(IBaseResource theNext) {
            return this.myResourceToId.get(theNext);
        }

        public boolean isEmpty() {
            return this.myResourceToId.isEmpty();
        }
    }
}

