/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.base.resource.BaseOperationOutcome;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.IClientInterceptor;
import ca.uhn.fhir.rest.client.RestfulClientFactory;
import ca.uhn.fhir.rest.client.api.IRestfulClient;
import ca.uhn.fhir.rest.client.exceptions.FhirClientConnectionException;
import ca.uhn.fhir.rest.method.IClientResponseHandler;
import ca.uhn.fhir.rest.method.IClientResponseHandlerHandlesBinary;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseClient
implements IRestfulClient {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseClient.class);
    private final HttpClient myClient;
    private boolean myDontValidateConformance;
    private EncodingEnum myEncoding = null;
    private final RestfulClientFactory myFactory;
    private List<IClientInterceptor> myInterceptors = new ArrayList<IClientInterceptor>();
    private boolean myKeepResponses = false;
    private HttpResponse myLastResponse;
    private String myLastResponseBody;
    private Boolean myPrettyPrint = false;
    private final String myUrlBase;

    BaseClient(HttpClient theClient, String theUrlBase, RestfulClientFactory theFactory) {
        this.myClient = theClient;
        this.myUrlBase = theUrlBase;
        this.myFactory = theFactory;
    }

    protected Map<String, List<String>> createExtraParams() {
        LinkedHashMap<String, List<String>> retVal = new LinkedHashMap<String, List<String>>();
        if (this.getEncoding() == EncodingEnum.XML) {
            retVal.put("_format", Collections.singletonList("xml"));
        } else if (this.getEncoding() == EncodingEnum.JSON) {
            retVal.put("_format", Collections.singletonList("json"));
        }
        if (this.isPrettyPrint()) {
            retVal.put("_pretty", Collections.singletonList("true"));
        }
        return retVal;
    }

    public EncodingEnum getEncoding() {
        return this.myEncoding;
    }

    @Override
    public HttpClient getHttpClient() {
        return this.myClient;
    }

    public HttpResponse getLastResponse() {
        return this.myLastResponse;
    }

    public String getLastResponseBody() {
        return this.myLastResponseBody;
    }

    public Boolean getPrettyPrint() {
        return this.myPrettyPrint;
    }

    @Override
    public String getServerBase() {
        return this.myUrlBase;
    }

    public String getUrlBase() {
        return this.myUrlBase;
    }

    <T> T invokeClient(FhirContext theContext, IClientResponseHandler<T> binding, BaseHttpClientInvocation clientInvocation) {
        return this.invokeClient(theContext, binding, clientInvocation, false);
    }

    <T> T invokeClient(FhirContext theContext, IClientResponseHandler<T> binding, BaseHttpClientInvocation clientInvocation, boolean theLogRequestAndResponse) {
        return this.invokeClient(theContext, binding, clientInvocation, null, null, theLogRequestAndResponse);
    }

    void forceConformanceCheck() {
        this.myFactory.validateServerBase(this.myUrlBase, this.myClient, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> T invokeClient(FhirContext theContext, IClientResponseHandler<T> binding, BaseHttpClientInvocation clientInvocation, EncodingEnum theEncoding, Boolean thePrettyPrint, boolean theLogRequestAndResponse) {
        T t;
        InputStream reader;
        IClientResponseHandlerHandlesBinary handlesBinary;
        ContentType ct;
        HttpResponse response;
        if (!this.myDontValidateConformance) {
            this.myFactory.validateServerBaseIfConfiguredToDoSo(this.myUrlBase, this.myClient, this);
        }
        try {
            Map<String, List<String>> params = this.createExtraParams();
            if (theEncoding == EncodingEnum.XML) {
                params.put("_format", Collections.singletonList("xml"));
            } else if (theEncoding == EncodingEnum.JSON) {
                params.put("_format", Collections.singletonList("json"));
            }
            if (thePrettyPrint == Boolean.TRUE) {
                params.put("_pretty", Collections.singletonList("true"));
            }
            EncodingEnum encoding = this.getEncoding();
            if (theEncoding != null) {
                encoding = theEncoding;
            }
            HttpRequestBase httpRequest = clientInvocation.asHttpRequest(this.myUrlBase, params, encoding);
            if (theLogRequestAndResponse) {
                Object entity;
                ourLog.info("Client invoking: {}", (Object)httpRequest);
                if (httpRequest instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)httpRequest).getEntity()).isRepeatable()) {
                    String content = IOUtils.toString((InputStream)entity.getContent());
                    ourLog.info("Client request body: {}", (Object)content);
                }
            }
            for (IClientInterceptor nextInterceptor : this.myInterceptors) {
                nextInterceptor.interceptRequest(httpRequest);
            }
            response = this.myClient.execute((HttpUriRequest)httpRequest);
            for (IClientInterceptor nextInterceptor : this.myInterceptors) {
                nextInterceptor.interceptResponse(response);
            }
        }
        catch (DataFormatException e) {
            throw new FhirClientConnectionException(e);
        }
        catch (IOException e) {
            throw new FhirClientConnectionException(e);
        }
        String mimeType = 204 == response.getStatusLine().getStatusCode() ? null : ((ct = ContentType.get((HttpEntity)response.getEntity())) != null ? ct.getMimeType() : null);
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        if (response.getAllHeaders() != null) {
            for (Header next : response.getAllHeaders()) {
                String name = next.getName().toLowerCase();
                ArrayList<String> list = (ArrayList<String>)headers.get(name);
                if (list == null) {
                    list = new ArrayList<String>();
                    headers.put(name, list);
                }
                list.add(next.getValue());
            }
        }
        if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() > 299) {
            String body = null;
            Reader reader2 = null;
            try {
                reader2 = BaseClient.createReaderFromResponse(response);
                body = IOUtils.toString((Reader)reader2);
            }
            catch (Exception e) {
                ourLog.debug("Failed to read input stream", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((Reader)reader2);
            }
            String message = "HTTP " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase();
            BaseOperationOutcome oo = null;
            if ("text/plain".equals(mimeType)) {
                message = message + ": " + body;
            } else {
                EncodingEnum enc = EncodingEnum.forContentType(mimeType);
                if (enc != null) {
                    IParser p = enc.newParser(theContext);
                    try {
                        oo = (BaseOperationOutcome)p.parseResource(body);
                        if (!oo.getIssueFirstRep().getDetailsElement().isEmpty()) {
                            message = message + ": " + (String)oo.getIssueFirstRep().getDetailsElement().getValue();
                        }
                    }
                    catch (Exception e) {
                        ourLog.debug("Failed to process OperationOutcome response");
                    }
                }
            }
            this.keepResponseAndLogIt(theLogRequestAndResponse, response, body);
            BaseServerResponseException exception = BaseServerResponseException.newInstance(response.getStatusLine().getStatusCode(), message);
            exception.setOperationOutcome(oo);
            if (body == null) throw exception;
            exception.setResponseBody(body);
            throw exception;
        }
        if (binding instanceof IClientResponseHandlerHandlesBinary && (handlesBinary = (IClientResponseHandlerHandlesBinary)binding).isBinary()) {
            reader = response.getEntity().getContent();
            if (ourLog.isTraceEnabled() || this.myKeepResponses || theLogRequestAndResponse) {
                byte[] responseBytes = IOUtils.toByteArray((InputStream)reader);
                if (this.myKeepResponses) {
                    this.myLastResponse = response;
                    this.myLastResponseBody = null;
                }
                String message = "HTTP " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase();
                if (theLogRequestAndResponse) {
                    ourLog.info("Client response: {} - {} bytes", (Object)message, (Object)responseBytes.length);
                } else {
                    ourLog.trace("Client response: {} - {} bytes", (Object)message, (Object)responseBytes.length);
                }
                reader = new ByteArrayInputStream(responseBytes);
            }
            Object responseBytes = handlesBinary.invokeClient(mimeType, reader, response.getStatusLine().getStatusCode(), headers);
            return responseBytes;
        }
        Reader reader3 = BaseClient.createReaderFromResponse(response);
        if (ourLog.isTraceEnabled() || this.myKeepResponses || theLogRequestAndResponse) {
            String responseString = IOUtils.toString((Reader)reader3);
            this.keepResponseAndLogIt(theLogRequestAndResponse, response, responseString);
            reader3 = new StringReader(responseString);
        }
        try {
            t = binding.invokeClient(mimeType, reader3, response.getStatusLine().getStatusCode(), headers);
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((Reader)reader3);
                throw throwable;
            }
            catch (IllegalStateException e) {
                throw new FhirClientConnectionException(e);
            }
            catch (IOException e) {}
            throw new FhirClientConnectionException(e);
            finally {
                IOUtils.closeQuietly((InputStream)reader);
            }
        }
        finally {
            if (response instanceof CloseableHttpResponse) {
                try {
                    ((CloseableHttpResponse)response).close();
                }
                catch (IOException e) {
                    ourLog.debug("Failed to close response", (Throwable)e);
                }
            }
        }
        IOUtils.closeQuietly((Reader)reader3);
        return t;
    }

    public boolean isKeepResponses() {
        return this.myKeepResponses;
    }

    public boolean isPrettyPrint() {
        return Boolean.TRUE.equals(this.myPrettyPrint);
    }

    private void keepResponseAndLogIt(boolean theLogRequestAndResponse, HttpResponse response, String responseString) {
        if (this.myKeepResponses) {
            this.myLastResponse = response;
            this.myLastResponseBody = responseString;
        }
        if (theLogRequestAndResponse) {
            String message = "HTTP " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase();
            if (StringUtils.isNotBlank((CharSequence)responseString)) {
                ourLog.info("Client response: {}\n{}", (Object)message, (Object)responseString);
            } else {
                ourLog.info("Client response: {}", (Object)message, (Object)responseString);
            }
        } else {
            ourLog.trace("FHIR response:\n{}\n{}", (Object)response, (Object)responseString);
        }
    }

    @Override
    public void registerInterceptor(IClientInterceptor theInterceptor) {
        Validate.notNull((Object)theInterceptor, (String)"Interceptor can not be null", (Object[])new Object[0]);
        this.myInterceptors.add(theInterceptor);
    }

    public void setDontValidateConformance(boolean theDontValidateConformance) {
        this.myDontValidateConformance = theDontValidateConformance;
    }

    @Override
    public void setEncoding(EncodingEnum theEncoding) {
        this.myEncoding = theEncoding;
    }

    public void setKeepResponses(boolean theKeepResponses) {
        this.myKeepResponses = theKeepResponses;
    }

    public void setLastResponse(HttpResponse theLastResponse) {
        this.myLastResponse = theLastResponse;
    }

    public void setLastResponseBody(String theLastResponseBody) {
        this.myLastResponseBody = theLastResponseBody;
    }

    @Override
    public void setPrettyPrint(Boolean thePrettyPrint) {
        this.myPrettyPrint = thePrettyPrint;
    }

    @Override
    public void unregisterInterceptor(IClientInterceptor theInterceptor) {
        Validate.notNull((Object)theInterceptor, (String)"Interceptor can not be null", (Object[])new Object[0]);
        this.myInterceptors.remove(theInterceptor);
    }

    public static Reader createReaderFromResponse(HttpResponse theResponse) throws IllegalStateException, IOException {
        HttpEntity entity = theResponse.getEntity();
        if (entity == null) {
            return new StringReader("");
        }
        Charset charset = null;
        if (entity.getContentType() != null && entity.getContentType().getElements() != null && entity.getContentType().getElements().length > 0) {
            ContentType ct = ContentType.get((HttpEntity)entity);
            charset = ct.getCharset();
        }
        if (charset == null) {
            if (204 != theResponse.getStatusLine().getStatusCode()) {
                ourLog.warn("Response did not specify a charset.");
            }
            charset = Charset.forName("UTF-8");
        }
        InputStreamReader reader = new InputStreamReader(theResponse.getEntity().getContent(), charset);
        return reader;
    }

    public List<IClientInterceptor> getInterceptors() {
        return Collections.unmodifiableList(this.myInterceptors);
    }
}

