/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.base.resource.BaseConformance;
import ca.uhn.fhir.model.base.resource.BaseOperationOutcome;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.client.BaseClient;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.IGenericClient;
import ca.uhn.fhir.rest.client.RestfulClientFactory;
import ca.uhn.fhir.rest.client.exceptions.NonFhirResponseException;
import ca.uhn.fhir.rest.gclient.IClientExecutable;
import ca.uhn.fhir.rest.gclient.ICreate;
import ca.uhn.fhir.rest.gclient.ICreateTyped;
import ca.uhn.fhir.rest.gclient.ICreateWithQuery;
import ca.uhn.fhir.rest.gclient.ICreateWithQueryTyped;
import ca.uhn.fhir.rest.gclient.ICriterion;
import ca.uhn.fhir.rest.gclient.ICriterionInternal;
import ca.uhn.fhir.rest.gclient.IDelete;
import ca.uhn.fhir.rest.gclient.IDeleteTyped;
import ca.uhn.fhir.rest.gclient.IDeleteWithQuery;
import ca.uhn.fhir.rest.gclient.IDeleteWithQueryTyped;
import ca.uhn.fhir.rest.gclient.IGetPage;
import ca.uhn.fhir.rest.gclient.IGetPageTyped;
import ca.uhn.fhir.rest.gclient.IGetTags;
import ca.uhn.fhir.rest.gclient.IHistory;
import ca.uhn.fhir.rest.gclient.IHistoryTyped;
import ca.uhn.fhir.rest.gclient.IHistoryUntyped;
import ca.uhn.fhir.rest.gclient.IOperation;
import ca.uhn.fhir.rest.gclient.IOperationUnnamed;
import ca.uhn.fhir.rest.gclient.IOperationUntyped;
import ca.uhn.fhir.rest.gclient.IOperationUntypedWithInput;
import ca.uhn.fhir.rest.gclient.IParam;
import ca.uhn.fhir.rest.gclient.IQuery;
import ca.uhn.fhir.rest.gclient.IRead;
import ca.uhn.fhir.rest.gclient.IReadExecutable;
import ca.uhn.fhir.rest.gclient.IReadIfNoneMatch;
import ca.uhn.fhir.rest.gclient.IReadTyped;
import ca.uhn.fhir.rest.gclient.ISort;
import ca.uhn.fhir.rest.gclient.ITransaction;
import ca.uhn.fhir.rest.gclient.ITransactionTyped;
import ca.uhn.fhir.rest.gclient.IUntypedQuery;
import ca.uhn.fhir.rest.gclient.IUpdate;
import ca.uhn.fhir.rest.gclient.IUpdateExecutable;
import ca.uhn.fhir.rest.gclient.IUpdateTyped;
import ca.uhn.fhir.rest.gclient.IUpdateWithQuery;
import ca.uhn.fhir.rest.gclient.IUpdateWithQueryTyped;
import ca.uhn.fhir.rest.method.DeleteMethodBinding;
import ca.uhn.fhir.rest.method.HistoryMethodBinding;
import ca.uhn.fhir.rest.method.HttpDeleteClientInvocation;
import ca.uhn.fhir.rest.method.HttpGetClientInvocation;
import ca.uhn.fhir.rest.method.HttpPostClientInvocation;
import ca.uhn.fhir.rest.method.HttpPutClientInvocation;
import ca.uhn.fhir.rest.method.HttpSimpleGetClientInvocation;
import ca.uhn.fhir.rest.method.IClientResponseHandler;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.OperationMethodBinding;
import ca.uhn.fhir.rest.method.ReadMethodBinding;
import ca.uhn.fhir.rest.method.SearchMethodBinding;
import ca.uhn.fhir.rest.method.SearchStyleEnum;
import ca.uhn.fhir.rest.method.TransactionMethodBinding;
import ca.uhn.fhir.rest.method.ValidateMethodBinding;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.NotModifiedException;
import ca.uhn.fhir.util.ICallable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.hl7.fhir.instance.model.IBase;
import org.hl7.fhir.instance.model.IBaseResource;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericClient
extends BaseClient
implements IGenericClient {
    private static final String I18N_CANNOT_DETEMINE_RESOURCE_TYPE = "ca.uhn.fhir.rest.client.GenericClient.cannotDetermineResourceTypeFromUri";
    private static final String I18N_INCOMPLETE_URI_FOR_READ = "ca.uhn.fhir.rest.client.GenericClient.incompleteUriForRead";
    private static final String I18N_NO_VERSION_ID_FOR_VREAD = "ca.uhn.fhir.rest.client.GenericClient.noVersionIdForVread";
    private static final Logger ourLog = LoggerFactory.getLogger(GenericClient.class);
    private FhirContext myContext;
    private HttpRequestBase myLastRequest;
    private boolean myLogRequestAndResponse;

    public GenericClient(FhirContext theContext, HttpClient theHttpClient, String theServerBase, RestfulClientFactory theFactory) {
        super(theHttpClient, theServerBase, theFactory);
        this.myContext = theContext;
    }

    @Override
    public BaseConformance conformance() {
        HttpGetClientInvocation invocation = MethodUtil.createConformanceInvocation();
        if (this.isKeepResponses()) {
            this.myLastRequest = invocation.asHttpRequest(this.getServerBase(), this.createExtraParams(), this.getEncoding());
        }
        Class conformance = this.myContext.getResourceDefinition("Conformance").getImplementingClass();
        ResourceResponseHandler binding = new ResourceResponseHandler(conformance, null);
        BaseConformance resp = (BaseConformance)this.invokeClient(this.myContext, binding, invocation, this.myLogRequestAndResponse);
        return resp;
    }

    @Override
    public void forceConformanceCheck() {
        super.forceConformanceCheck();
    }

    @Override
    public ICreate create() {
        return new CreateInternal();
    }

    @Override
    public FhirContext getFhirContext() {
        return this.myContext;
    }

    @Override
    public MethodOutcome create(IResource theResource) {
        HttpPostClientInvocation invocation = MethodUtil.createCreateInvocation(theResource, this.myContext);
        if (this.isKeepResponses()) {
            this.myLastRequest = ((BaseHttpClientInvocation)invocation).asHttpRequest(this.getServerBase(), this.createExtraParams(), this.getEncoding());
        }
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        String resourceName = def.getName();
        OutcomeResponseHandler binding = new OutcomeResponseHandler(resourceName);
        MethodOutcome resp = this.invokeClient(this.myContext, binding, invocation, this.myLogRequestAndResponse);
        return resp;
    }

    @Override
    public IDelete delete() {
        return new DeleteInternal();
    }

    @Override
    public MethodOutcome delete(Class<? extends IResource> theType, IdDt theId) {
        HttpDeleteClientInvocation invocation = DeleteMethodBinding.createDeleteInvocation(theId.withResourceType(this.toResourceName(theType)));
        if (this.isKeepResponses()) {
            this.myLastRequest = invocation.asHttpRequest(this.getServerBase(), this.createExtraParams(), this.getEncoding());
        }
        String resourceName = this.myContext.getResourceDefinition(theType).getName();
        OutcomeResponseHandler binding = new OutcomeResponseHandler(resourceName);
        MethodOutcome resp = this.invokeClient(this.myContext, binding, invocation, this.myLogRequestAndResponse);
        return resp;
    }

    @Override
    public MethodOutcome delete(Class<? extends IResource> theType, String theId) {
        return this.delete(theType, new IdDt(theId));
    }

    private <T extends IBaseResource> T doReadOrVRead(Class<T> theType, IdDt theId, boolean theVRead, ICallable<T> theNotModifiedHandler, String theIfVersionMatches) {
        String resName = this.toResourceName(theType);
        IdDt id = theId;
        if (!id.hasBaseUrl()) {
            id = new IdDt(resName, id.getIdPart(), id.getVersionIdPart());
        }
        HttpGetClientInvocation invocation = id.hasBaseUrl() ? (theVRead ? ReadMethodBinding.createAbsoluteVReadInvocation(id) : ReadMethodBinding.createAbsoluteReadInvocation(id)) : (theVRead ? ReadMethodBinding.createVReadInvocation(id, resName) : ReadMethodBinding.createReadInvocation(id, resName));
        if (this.isKeepResponses()) {
            this.myLastRequest = invocation.asHttpRequest(this.getServerBase(), this.createExtraParams(), this.getEncoding());
        }
        if (theIfVersionMatches != null) {
            invocation.addHeader("If-None-Match", '\"' + theIfVersionMatches + '\"');
        }
        ResourceResponseHandler<T> binding = new ResourceResponseHandler<T>(theType, id);
        if (theNotModifiedHandler == null) {
            return (T)((IBaseResource)this.invokeClient(this.myContext, binding, invocation, this.myLogRequestAndResponse));
        }
        try {
            return (T)((IBaseResource)this.invokeClient(this.myContext, binding, invocation, this.myLogRequestAndResponse));
        }
        catch (NotModifiedException e) {
            return (T)((IBaseResource)theNotModifiedHandler.call());
        }
    }

    public HttpRequestBase getLastRequest() {
        return this.myLastRequest;
    }

    protected String getPreferredId(IResource theResource, String theId) {
        if (StringUtils.isNotBlank((CharSequence)theId)) {
            return theId;
        }
        return theResource.getId().getIdPart();
    }

    @Override
    public IGetTags getTags() {
        return new GetTagsInternal();
    }

    @Override
    public IHistory history() {
        return new HistoryInternal();
    }

    @Override
    public <T extends IResource> Bundle history(Class<T> theType, IdDt theIdDt, DateTimeDt theSince, Integer theLimit) {
        String resourceName = theType != null ? this.toResourceName(theType) : null;
        String id = theIdDt != null && !theIdDt.isEmpty() ? theIdDt.getValue() : null;
        HttpGetClientInvocation invocation = HistoryMethodBinding.createHistoryInvocation(resourceName, id, theSince, theLimit);
        if (this.isKeepResponses()) {
            this.myLastRequest = invocation.asHttpRequest(this.getServerBase(), this.createExtraParams(), this.getEncoding());
        }
        BundleResponseHandler binding = new BundleResponseHandler(theType);
        Bundle resp = this.invokeClient(this.myContext, binding, invocation, this.myLogRequestAndResponse);
        return resp;
    }

    @Override
    public <T extends IResource> Bundle history(Class<T> theType, String theId, DateTimeDt theSince, Integer theLimit) {
        return this.history(theType, new IdDt(theId), theSince, theLimit);
    }

    private Class<? extends IBaseResource> inferResourceClass(UriDt theUrl) {
        String urlString = theUrl.getValueAsString();
        int i = urlString.indexOf(63);
        if (i >= 0) {
            urlString = urlString.substring(0, i);
        }
        if ((i = urlString.indexOf("://")) >= 0) {
            urlString = urlString.substring(i + 3);
        }
        String[] pcs = urlString.split("\\/");
        for (i = pcs.length - 1; i >= 0; --i) {
            RuntimeResourceDefinition def;
            String s = pcs[i].trim();
            if (s.isEmpty() || (def = this.myContext.getResourceDefinition(s)) == null) continue;
            return def.getImplementingClass();
        }
        throw new RuntimeException(this.myContext.getLocalizer().getMessage(I18N_CANNOT_DETEMINE_RESOURCE_TYPE, theUrl.getValueAsString()));
    }

    public boolean isLogRequestAndResponse() {
        return this.myLogRequestAndResponse;
    }

    @Override
    public IGetPage loadPage() {
        return new LoadPageInternal();
    }

    @Override
    public IOperation operation() {
        if (!this.myContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU1)) {
            throw new IllegalStateException("Operations are only supported in FHIR DSTU2 and later. This client was created using a context configured for " + this.myContext.getVersion().getVersion().name());
        }
        return new OperationInternal();
    }

    @Override
    public IRead read() {
        return new ReadInternal();
    }

    @Override
    public <T extends IBaseResource> T read(Class<T> theType, String theId) {
        return this.read(theType, new IdDt(theId));
    }

    @Override
    public <T extends IBaseResource> T read(Class<T> theType, UriDt theUrl) {
        IdDt id = theUrl instanceof IdDt ? (IdDt)theUrl : new IdDt(theUrl);
        return this.doReadOrVRead(theType, id, false, null, null);
    }

    @Override
    public IResource read(UriDt theUrl) {
        IdDt id = new IdDt(theUrl);
        String resourceType = id.getResourceType();
        if (StringUtils.isBlank((CharSequence)resourceType)) {
            throw new IllegalArgumentException(this.myContext.getLocalizer().getMessage(I18N_INCOMPLETE_URI_FOR_READ, theUrl.getValueAsString()));
        }
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(resourceType);
        if (def == null) {
            throw new IllegalArgumentException(this.myContext.getLocalizer().getMessage(I18N_CANNOT_DETEMINE_RESOURCE_TYPE, theUrl.getValueAsString()));
        }
        return (IResource)this.read(def.getImplementingClass(), id);
    }

    @Override
    public IUntypedQuery search() {
        return new SearchInternal();
    }

    @Override
    public <T extends IBaseResource> Bundle search(Class<T> theType, Map<String, List<IQueryParameterType>> theParams) {
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, List<IQueryParameterType>> nextEntry : theParams.entrySet()) {
            ArrayList<String> valueList = new ArrayList<String>();
            String qualifier = null;
            for (IQueryParameterType nextValue : nextEntry.getValue()) {
                valueList.add(nextValue.getValueAsQueryToken());
                qualifier = nextValue.getQueryParameterQualifier();
            }
            qualifier = StringUtils.defaultString(qualifier);
            params.put(nextEntry.getKey() + qualifier, valueList);
        }
        BaseHttpClientInvocation invocation = SearchMethodBinding.createSearchInvocation(this.myContext, this.toResourceName(theType), params, null, null, null);
        if (this.isKeepResponses()) {
            this.myLastRequest = invocation.asHttpRequest(this.getServerBase(), this.createExtraParams(), this.getEncoding());
        }
        BundleResponseHandler binding = new BundleResponseHandler(theType);
        Bundle resp = this.invokeClient(this.myContext, binding, invocation, this.myLogRequestAndResponse);
        return resp;
    }

    @Override
    public <T extends IBaseResource> Bundle search(Class<T> theType, UriDt theUrl) {
        HttpGetClientInvocation invocation = new HttpGetClientInvocation(theUrl.getValueAsString());
        return this.invokeClient(this.myContext, new BundleResponseHandler(theType), invocation);
    }

    @Override
    public Bundle search(UriDt theUrl) {
        return this.search(this.inferResourceClass(theUrl), theUrl);
    }

    public void setLastRequest(HttpRequestBase theLastRequest) {
        this.myLastRequest = theLastRequest;
    }

    @Override
    public void setLogRequestAndResponse(boolean theLogRequestAndResponse) {
        this.myLogRequestAndResponse = theLogRequestAndResponse;
    }

    private String toResourceName(Class<? extends IBaseResource> theType) {
        return this.myContext.getResourceDefinition(theType).getName();
    }

    @Override
    public ITransaction transaction() {
        return new TransactionInternal();
    }

    @Override
    public List<IResource> transaction(List<IResource> theResources) {
        BaseHttpClientInvocation invocation = TransactionMethodBinding.createTransactionInvocation(theResources, this.myContext);
        if (this.isKeepResponses()) {
            this.myLastRequest = invocation.asHttpRequest(this.getServerBase(), this.createExtraParams(), this.getEncoding());
        }
        Bundle resp = this.invokeClient(this.myContext, new BundleResponseHandler(null), invocation, this.myLogRequestAndResponse);
        return resp.toListOfResources();
    }

    @Override
    public IUpdate update() {
        return new UpdateInternal();
    }

    @Override
    public MethodOutcome update(IdDt theIdDt, IResource theResource) {
        HttpPutClientInvocation invocation = MethodUtil.createUpdateInvocation(theResource, null, theIdDt, this.myContext);
        if (this.isKeepResponses()) {
            this.myLastRequest = ((BaseHttpClientInvocation)invocation).asHttpRequest(this.getServerBase(), this.createExtraParams(), this.getEncoding());
        }
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        String resourceName = def.getName();
        OutcomeResponseHandler binding = new OutcomeResponseHandler(resourceName);
        MethodOutcome resp = this.invokeClient(this.myContext, binding, invocation, this.myLogRequestAndResponse);
        return resp;
    }

    @Override
    public MethodOutcome update(String theId, IResource theResource) {
        return this.update(new IdDt(theId), theResource);
    }

    @Override
    public MethodOutcome validate(IResource theResource) {
        HttpPostClientInvocation invocation = ValidateMethodBinding.createValidateInvocation(theResource, null, this.myContext);
        if (this.isKeepResponses()) {
            this.myLastRequest = ((BaseHttpClientInvocation)invocation).asHttpRequest(this.getServerBase(), this.createExtraParams(), this.getEncoding());
        }
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        String resourceName = def.getName();
        OutcomeResponseHandler binding = new OutcomeResponseHandler(resourceName);
        MethodOutcome resp = this.invokeClient(this.myContext, binding, invocation, this.myLogRequestAndResponse);
        return resp;
    }

    @Override
    public <T extends IBaseResource> T vread(Class<T> theType, IdDt theId) {
        if (!theId.hasVersionIdPart()) {
            throw new IllegalArgumentException(this.myContext.getLocalizer().getMessage(I18N_NO_VERSION_ID_FOR_VREAD, theId.getValue()));
        }
        return this.doReadOrVRead(theType, theId, true, null, null);
    }

    @Override
    @Deprecated
    public <T extends IResource> T vread(Class<T> theType, IdDt theId, IdDt theVersionId) {
        return (T)((IResource)this.vread(theType, theId.withVersion(theVersionId.getIdPart())));
    }

    @Override
    public <T extends IBaseResource> T vread(Class<T> theType, String theId, String theVersionId) {
        IdDt resId = new IdDt(this.toResourceName(theType), theId, theVersionId);
        return this.vread(theType, resId);
    }

    private static void addParam(Map<String, List<String>> params, String parameterName, String parameterValue) {
        if (!params.containsKey(parameterName)) {
            params.put(parameterName, new ArrayList());
        }
        params.get(parameterName).add(parameterValue);
    }

    private class UpdateInternal
    extends BaseClientExecutable<IUpdateExecutable, MethodOutcome>
    implements IUpdate,
    IUpdateTyped,
    IUpdateExecutable,
    IUpdateWithQuery,
    IUpdateWithQueryTyped {
        private CriterionList myCriterionList;
        private IdDt myId;
        private IResource myResource;
        private String myResourceBody;
        private String mySearchUrl;

        private UpdateInternal() {
        }

        @Override
        public IUpdateWithQueryTyped and(ICriterion<?> theCriterion) {
            this.myCriterionList.add((ICriterionInternal)((Object)theCriterion));
            return this;
        }

        @Override
        public IUpdateWithQuery conditional() {
            this.myCriterionList = new CriterionList();
            return this;
        }

        @Override
        public IUpdateTyped conditionalByUrl(String theSearchUrl) {
            this.mySearchUrl = theSearchUrl;
            return this;
        }

        @Override
        public MethodOutcome execute() {
            HttpPutClientInvocation invocation;
            if (this.myResource == null) {
                this.myResource = this.parseResourceBody(this.myResourceBody);
            }
            if (this.getParamEncoding() != null) {
                this.myResourceBody = null;
            }
            if (this.mySearchUrl != null) {
                invocation = MethodUtil.createUpdateInvocation(GenericClient.this.myContext, this.myResource, this.myResourceBody, this.mySearchUrl);
            } else if (this.myCriterionList != null) {
                invocation = MethodUtil.createUpdateInvocation(GenericClient.this.myContext, this.myResource, this.myResourceBody, this.myCriterionList.toParamList());
            } else {
                if (this.myId == null) {
                    this.myId = this.myResource.getId();
                }
                if (this.myId == null || !this.myId.hasIdPart()) {
                    throw new InvalidRequestException("No ID supplied for resource to update, can not invoke server");
                }
                invocation = MethodUtil.createUpdateInvocation(this.myResource, this.myResourceBody, this.myId, GenericClient.this.myContext);
            }
            RuntimeResourceDefinition def = GenericClient.this.myContext.getResourceDefinition(this.myResource);
            String resourceName = def.getName();
            OutcomeResponseHandler binding = new OutcomeResponseHandler(resourceName);
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            return this.invoke(params, binding, invocation);
        }

        @Override
        public IUpdateTyped resource(IResource theResource) {
            Validate.notNull((Object)theResource, (String)"Resource can not be null", (Object[])new Object[0]);
            this.myResource = theResource;
            return this;
        }

        @Override
        public IUpdateTyped resource(String theResourceBody) {
            Validate.notBlank((CharSequence)theResourceBody, (String)"Body can not be null or blank", (Object[])new Object[0]);
            this.myResourceBody = theResourceBody;
            return this;
        }

        @Override
        public IUpdateWithQueryTyped where(ICriterion<?> theCriterion) {
            this.myCriterionList.add((ICriterionInternal)((Object)theCriterion));
            return this;
        }

        @Override
        public IUpdateExecutable withId(IdDt theId) {
            if (theId == null) {
                throw new NullPointerException("theId can not be null");
            }
            if (!theId.hasIdPart()) {
                throw new NullPointerException("theId must not be blank and must contain an ID, found: " + theId.getValue());
            }
            this.myId = theId;
            return this;
        }

        @Override
        public IUpdateExecutable withId(String theId) {
            if (theId == null) {
                throw new NullPointerException("theId can not be null");
            }
            if (StringUtils.isBlank((CharSequence)theId)) {
                throw new NullPointerException("theId must not be blank and must contain an ID, found: " + theId);
            }
            this.myId = new IdDt(theId);
            return this;
        }
    }

    private final class TransactionInternal
    implements ITransaction {
        private TransactionInternal() {
        }

        @Override
        public ITransactionTyped<Bundle> withBundle(Bundle theBundle) {
            Validate.notNull((Object)theBundle, (String)"theBundle must not be null", (Object[])new Object[0]);
            return new TransactionExecutable<Bundle>(theBundle);
        }

        @Override
        public ITransactionTyped<List<IResource>> withResources(List<IResource> theResources) {
            Validate.notNull(theResources, (String)"theResources must not be null", (Object[])new Object[0]);
            return new TransactionExecutable<List<IResource>>(theResources);
        }

        @Override
        public <T extends IBaseBundle> ITransactionTyped<T> withBundle(T theBundle) {
            Validate.notNull(theBundle, (String)"theBundle must not be null", (Object[])new Object[0]);
            return new TransactionExecutable(theBundle);
        }

        @Override
        public ITransactionTyped<String> withBundle(String theBundle) {
            Validate.notBlank((CharSequence)theBundle, (String)"theBundle must not be null", (Object[])new Object[0]);
            return new TransactionExecutable<String>(theBundle);
        }
    }

    private final class TransactionExecutable<T>
    extends BaseClientExecutable<ITransactionTyped<T>, T>
    implements ITransactionTyped<T> {
        private Bundle myBundle;
        private List<IResource> myResources;
        private IBaseBundle myBaseBundle;
        private String myRawBundle;
        private EncodingEnum myRawBundleEncoding;

        public TransactionExecutable(Bundle theResources) {
            this.myBundle = theResources;
        }

        public TransactionExecutable(List<IResource> theResources) {
            this.myResources = theResources;
        }

        public TransactionExecutable(IBaseBundle theBundle) {
            this.myBaseBundle = theBundle;
        }

        public TransactionExecutable(String theBundle) {
            this.myRawBundle = theBundle;
            this.myRawBundleEncoding = MethodUtil.detectEncodingNoDefault(this.myRawBundle);
            if (this.myRawBundleEncoding == null) {
                throw new IllegalArgumentException("Can not determine encoding of raw resource body");
            }
        }

        @Override
        public T execute() {
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            if (this.myResources != null) {
                ResourceListResponseHandler binding = new ResourceListResponseHandler(null);
                BaseHttpClientInvocation invocation = TransactionMethodBinding.createTransactionInvocation(this.myResources, GenericClient.this.myContext);
                return (T)this.invoke(params, binding, invocation);
            }
            if (this.myBaseBundle != null) {
                ResourceResponseHandler binding = new ResourceResponseHandler(this.myBaseBundle.getClass(), null);
                BaseHttpClientInvocation invocation = TransactionMethodBinding.createTransactionInvocation(this.myBaseBundle, GenericClient.this.myContext);
                return (T)this.invoke(params, binding, invocation);
            }
            if (this.myRawBundle != null) {
                StringResponseHandler binding = new StringResponseHandler();
                if (this.getParamEncoding() != null && MethodUtil.detectEncodingNoDefault(this.myRawBundle) != this.getParamEncoding()) {
                    IResource parsed = this.parseResourceBody(this.myRawBundle);
                    this.myRawBundle = this.getParamEncoding().newParser(GenericClient.this.getFhirContext()).encodeResourceToString(parsed);
                }
                BaseHttpClientInvocation invocation = TransactionMethodBinding.createTransactionInvocation(this.myRawBundle, GenericClient.this.myContext);
                return (T)this.invoke(params, binding, invocation);
            }
            BundleResponseHandler binding = new BundleResponseHandler(null);
            BaseHttpClientInvocation invocation = TransactionMethodBinding.createTransactionInvocation(this.myBundle, GenericClient.this.myContext);
            return (T)this.invoke(params, binding, invocation);
        }
    }

    private final class TagListResponseHandler
    implements IClientResponseHandler<TagList> {
        private TagListResponseHandler() {
        }

        @Override
        public TagList invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws IOException, BaseServerResponseException {
            EncodingEnum respType = EncodingEnum.forContentType(theResponseMimeType);
            if (respType == null) {
                throw NonFhirResponseException.newInstance(theResponseStatusCode, theResponseMimeType, theResponseReader);
            }
            IParser parser = respType.newParser(GenericClient.this.myContext);
            return parser.parseTagList(theResponseReader);
        }
    }

    private static class SortInternal
    implements ISort {
        private SearchInternal myFor;
        private String myParamName;
        private String myParamValue;

        public SortInternal(SearchInternal theFor) {
            this.myFor = theFor;
        }

        @Override
        public IQuery ascending(IParam theParam) {
            this.myParamName = "_sort:asc";
            this.myParamValue = theParam.getParamName();
            return this.myFor;
        }

        @Override
        public IQuery defaultOrder(IParam theParam) {
            this.myParamName = "_sort";
            this.myParamValue = theParam.getParamName();
            return this.myFor;
        }

        @Override
        public IQuery descending(IParam theParam) {
            this.myParamName = "_sort:desc";
            this.myParamValue = theParam.getParamName();
            return this.myFor;
        }

        public String getParamName() {
            return this.myParamName;
        }

        public String getParamValue() {
            return this.myParamValue;
        }
    }

    private class SearchInternal
    extends BaseClientExecutable<IQuery, Bundle>
    implements IQuery,
    IUntypedQuery {
        private String myCompartmentName;
        private CriterionList myCriterion;
        private List<Include> myInclude;
        private List<Include> myRevInclude;
        private Integer myParamLimit;
        private String myResourceId;
        private String myResourceName;
        private Class<? extends IBaseResource> myResourceType;
        private SearchStyleEnum mySearchStyle;
        private List<SortInternal> mySort;

        public SearchInternal() {
            this.myCriterion = new CriterionList();
            this.myInclude = new ArrayList<Include>();
            this.myRevInclude = new ArrayList<Include>();
            this.mySort = new ArrayList<SortInternal>();
            this.myResourceType = null;
            this.myResourceName = null;
        }

        @Override
        public IQuery and(ICriterion<?> theCriterion) {
            this.myCriterion.add((ICriterionInternal)((Object)theCriterion));
            return this;
        }

        @Override
        public Bundle execute() {
            LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
            this.myCriterion.populateParamList(params);
            for (Include include : this.myInclude) {
                GenericClient.addParam(params, "_include", include.getValue());
            }
            for (Include include : this.myRevInclude) {
                GenericClient.addParam(params, "_revinclude", include.getValue());
            }
            for (SortInternal sortInternal : this.mySort) {
                GenericClient.addParam(params, sortInternal.getParamName(), sortInternal.getParamValue());
            }
            if (this.myParamLimit != null) {
                GenericClient.addParam(params, "_count", Integer.toString(this.myParamLimit));
            }
            BundleResponseHandler binding = new BundleResponseHandler(this.myResourceType);
            IdDt idDt = this.myResourceId != null ? new IdDt(this.myResourceId) : null;
            BaseHttpClientInvocation invocation = SearchMethodBinding.createSearchInvocation(GenericClient.this.myContext, this.myResourceName, params, idDt, this.myCompartmentName, this.mySearchStyle);
            return this.invoke(params, binding, invocation);
        }

        @Override
        public IQuery forAllResources() {
            return this;
        }

        @Override
        public IQuery forResource(Class<? extends IResource> theResourceType) {
            this.setType(theResourceType);
            return this;
        }

        @Override
        public IQuery forResource(String theResourceName) {
            this.setType(theResourceName);
            return this;
        }

        @Override
        public IQuery include(Include theInclude) {
            this.myInclude.add(theInclude);
            return this;
        }

        @Override
        public IQuery limitTo(int theLimitTo) {
            this.myParamLimit = theLimitTo > 0 ? Integer.valueOf(theLimitTo) : null;
            return this;
        }

        private void setType(Class<? extends IResource> theResourceType) {
            this.myResourceType = theResourceType;
            RuntimeResourceDefinition definition = GenericClient.this.myContext.getResourceDefinition(theResourceType);
            this.myResourceName = definition.getName();
        }

        private void setType(String theResourceName) {
            this.myResourceType = GenericClient.this.myContext.getResourceDefinition(theResourceName).getImplementingClass();
            this.myResourceName = theResourceName;
        }

        @Override
        public ISort sort() {
            SortInternal retVal = new SortInternal(this);
            this.mySort.add(retVal);
            return retVal;
        }

        @Override
        public IQuery usingStyle(SearchStyleEnum theStyle) {
            this.mySearchStyle = theStyle;
            return this;
        }

        @Override
        public IQuery where(ICriterion<?> theCriterion) {
            this.myCriterion.add((ICriterionInternal)((Object)theCriterion));
            return this;
        }

        @Override
        public IQuery withIdAndCompartment(String theResourceId, String theCompartmentName) {
            this.myResourceId = theResourceId;
            this.myCompartmentName = theCompartmentName;
            return this;
        }

        @Override
        public IQuery revinclude(Include theInclude) {
            this.myRevInclude.add(theInclude);
            return this;
        }
    }

    private final class ResourceResponseHandler<T extends IBaseResource>
    implements IClientResponseHandler<T> {
        private IdDt myId;
        private Class<T> myType;

        public ResourceResponseHandler(Class<T> theType, IdDt theId) {
            this.myType = theType;
            this.myId = theId;
        }

        @Override
        public T invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws IOException, BaseServerResponseException {
            EncodingEnum respType = EncodingEnum.forContentType(theResponseMimeType);
            if (respType == null) {
                throw NonFhirResponseException.newInstance(theResponseStatusCode, theResponseMimeType, theResponseReader);
            }
            IParser parser = respType.newParser(GenericClient.this.myContext);
            T retVal = parser.parseResource(this.myType, theResponseReader);
            MethodUtil.parseClientRequestResourceHeaders(this.myId, theHeaders, retVal);
            return retVal;
        }
    }

    private final class ResourceListResponseHandler
    implements IClientResponseHandler<List<IResource>> {
        private Class<? extends IResource> myType;

        public ResourceListResponseHandler(Class<? extends IResource> theType) {
            this.myType = theType;
        }

        @Override
        public List<IResource> invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws IOException, BaseServerResponseException {
            if (GenericClient.this.myContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU1)) {
                Class bundleType = GenericClient.this.myContext.getResourceDefinition("Bundle").getImplementingClass();
                ResourceResponseHandler handler = new ResourceResponseHandler(bundleType, null);
                Object response = handler.invokeClient(theResponseMimeType, theResponseReader, theResponseStatusCode, (Map)theHeaders);
                IVersionSpecificBundleFactory bundleFactory = GenericClient.this.myContext.newBundleFactory();
                bundleFactory.initializeWithBundleResource((IResource)response);
                return bundleFactory.toListOfResources();
            }
            return ((Bundle)new BundleResponseHandler(this.myType).invokeClient(theResponseMimeType, theResponseReader, theResponseStatusCode, (Map)theHeaders)).toListOfResources();
        }
    }

    private class ReadInternal
    extends BaseClientExecutable
    implements IRead,
    IReadTyped,
    IReadExecutable {
        private IdDt myId;
        private String myIfVersionMatches;
        private ICallable myNotModifiedHandler;
        private RuntimeResourceDefinition myType;

        private ReadInternal() {
        }

        @Override
        public Object execute() {
            if (this.myId.hasVersionIdPart()) {
                return GenericClient.this.doReadOrVRead(this.myType.getImplementingClass(), this.myId, true, this.myNotModifiedHandler, this.myIfVersionMatches);
            }
            return GenericClient.this.doReadOrVRead(this.myType.getImplementingClass(), this.myId, false, this.myNotModifiedHandler, this.myIfVersionMatches);
        }

        public IReadIfNoneMatch ifVersionMatches(String theVersion) {
            this.myIfVersionMatches = theVersion;
            return new IReadIfNoneMatch(){

                public IReadExecutable returnNull() {
                    ReadInternal.this.myNotModifiedHandler = new ICallable(){

                        public Object call() {
                            return null;
                        }
                    };
                    return ReadInternal.this;
                }

                public IReadExecutable returnResource(final IBaseResource theInstance) {
                    ReadInternal.this.myNotModifiedHandler = new ICallable(){

                        public Object call() {
                            return theInstance;
                        }
                    };
                    return ReadInternal.this;
                }

                public IReadExecutable throwNotModifiedException() {
                    ReadInternal.this.myNotModifiedHandler = null;
                    return ReadInternal.this;
                }
            };
        }

        private void processUrl() {
            String resourceType = this.myId.getResourceType();
            if (StringUtils.isBlank((CharSequence)resourceType)) {
                throw new IllegalArgumentException(GenericClient.this.myContext.getLocalizer().getMessage(GenericClient.I18N_INCOMPLETE_URI_FOR_READ, this.myId));
            }
            this.myType = GenericClient.this.myContext.getResourceDefinition(resourceType);
            if (this.myType == null) {
                throw new IllegalArgumentException(GenericClient.this.myContext.getLocalizer().getMessage(GenericClient.I18N_CANNOT_DETEMINE_RESOURCE_TYPE, this.myId));
            }
        }

        @Override
        public <T extends IBaseResource> IReadTyped<T> resource(Class<T> theResourceType) {
            Validate.notNull(theResourceType, (String)"theResourceType must not be null", (Object[])new Object[0]);
            this.myType = GenericClient.this.myContext.getResourceDefinition(theResourceType);
            if (this.myType == null) {
                throw new IllegalArgumentException(GenericClient.this.myContext.getLocalizer().getMessage(GenericClient.I18N_CANNOT_DETEMINE_RESOURCE_TYPE, theResourceType));
            }
            return this;
        }

        @Override
        public IReadTyped<IBaseResource> resource(String theResourceAsText) {
            Validate.notBlank((CharSequence)theResourceAsText, (String)"You must supply a value for theResourceAsText", (Object[])new Object[0]);
            this.myType = GenericClient.this.myContext.getResourceDefinition(theResourceAsText);
            if (this.myType == null) {
                throw new IllegalArgumentException(GenericClient.this.myContext.getLocalizer().getMessage(GenericClient.I18N_CANNOT_DETEMINE_RESOURCE_TYPE, theResourceAsText));
            }
            return this;
        }

        public IReadExecutable withId(IdDt theId) {
            Validate.notNull((Object)theId, (String)"The ID can not be null", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)theId.getIdPart(), (String)"The ID can not be blank", (Object[])new Object[0]);
            this.myId = theId.toUnqualified();
            return this;
        }

        public IReadExecutable withId(String theId) {
            Validate.notBlank((CharSequence)theId, (String)"The ID can not be blank", (Object[])new Object[0]);
            this.myId = new IdDt(this.myType.getName(), theId);
            return this;
        }

        public IReadExecutable withIdAndVersion(String theId, String theVersion) {
            Validate.notBlank((CharSequence)theId, (String)"The ID can not be blank", (Object[])new Object[0]);
            this.myId = new IdDt(this.myType.getName(), theId, theVersion);
            return this;
        }

        public IReadExecutable withUrl(IdDt theUrl) {
            Validate.notNull((Object)theUrl, (String)"theUrl can not be null", (Object[])new Object[0]);
            this.myId = theUrl;
            this.processUrl();
            return this;
        }

        public IReadExecutable withUrl(String theUrl) {
            this.myId = new IdDt(theUrl);
            this.processUrl();
            return this;
        }
    }

    private final class OutcomeResponseHandler
    implements IClientResponseHandler<MethodOutcome> {
        private final String myResourceName;

        private OutcomeResponseHandler(String theResourceName) {
            this.myResourceName = theResourceName;
        }

        @Override
        public MethodOutcome invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws IOException, BaseServerResponseException {
            MethodOutcome response = MethodUtil.process2xxResponse(GenericClient.this.myContext, this.myResourceName, theResponseStatusCode, theResponseMimeType, theResponseReader, theHeaders);
            if (theResponseStatusCode == 201) {
                response.setCreated(true);
            }
            return response;
        }
    }

    private final class OperationOutcomeResponseHandler
    implements IClientResponseHandler<BaseOperationOutcome> {
        private OperationOutcomeResponseHandler() {
        }

        @Override
        public BaseOperationOutcome invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws IOException, BaseServerResponseException {
            BaseOperationOutcome retVal;
            EncodingEnum respType = EncodingEnum.forContentType(theResponseMimeType);
            if (respType == null) {
                return null;
            }
            IParser parser = respType.newParser(GenericClient.this.myContext);
            try {
                retVal = (BaseOperationOutcome)parser.parseResource(theResponseReader);
            }
            catch (DataFormatException e) {
                ourLog.warn("Failed to parse OperationOutcome response", (Throwable)e);
                return null;
            }
            MethodUtil.parseClientRequestResourceHeaders(null, theHeaders, retVal);
            return retVal;
        }
    }

    private class OperationInternal
    extends BaseClientExecutable
    implements IOperation,
    IOperationUnnamed,
    IOperationUntyped,
    IOperationUntypedWithInput {
        private IdDt myId;
        private String myOperationName;
        private IBaseParameters myParameters;
        private Class<? extends IBaseResource> myType;
        private boolean myUseHttpGet;

        private OperationInternal() {
        }

        @Override
        public Object execute() {
            String id;
            String resourceName;
            if (this.myType != null) {
                resourceName = GenericClient.this.myContext.getResourceDefinition(this.myType).getName();
                id = null;
            } else if (this.myId != null) {
                resourceName = this.myId.getResourceType();
                id = this.myId.getIdPart();
            } else {
                resourceName = null;
                id = null;
            }
            BaseHttpClientInvocation invocation = OperationMethodBinding.createOperationInvocation(GenericClient.this.myContext, resourceName, id, this.myOperationName, this.myParameters, this.myUseHttpGet);
            ResourceResponseHandler handler = new ResourceResponseHandler(this.myParameters.getClass(), null);
            Object retVal = this.invoke(null, handler, invocation);
            if (GenericClient.this.myContext.getResourceDefinition((IBaseResource)retVal).getName().equals("Parameters")) {
                return retVal;
            }
            RuntimeResourceDefinition def = GenericClient.this.myContext.getResourceDefinition("Parameters");
            IBaseResource parameters = (IBaseResource)def.newInstance();
            BaseRuntimeChildDefinition paramChild = def.getChildByName("parameter");
            BaseRuntimeElementCompositeDefinition paramChildElem = (BaseRuntimeElementCompositeDefinition)paramChild.getChildByName("parameter");
            Object parameter = paramChildElem.newInstance();
            paramChild.getMutator().addValue(parameters, (IBase)parameter);
            BaseRuntimeChildDefinition resourceElem = paramChildElem.getChildByName("resource");
            resourceElem.getMutator().addValue(parameter, (IBase)retVal);
            return parameters;
        }

        @Override
        public IOperationUntyped named(String theName) {
            Validate.notBlank((CharSequence)theName, (String)"theName can not be null", (Object[])new Object[0]);
            this.myOperationName = theName;
            return this;
        }

        @Override
        public IOperationUnnamed onInstance(IdDt theId) {
            this.myId = theId;
            return this;
        }

        @Override
        public IOperationUnnamed onServer() {
            return this;
        }

        @Override
        public IOperationUnnamed onType(Class<? extends IBaseResource> theResourceType) {
            this.myType = theResourceType;
            return this;
        }

        public IOperationUntypedWithInput withParameters(IBaseParameters theParameters) {
            Validate.notNull((Object)theParameters, (String)"theParameters can not be null", (Object[])new Object[0]);
            this.myParameters = theParameters;
            return this;
        }

        @Override
        public <T extends IBaseParameters> IOperationUntypedWithInput<T> withNoParameters(Class<T> theOutputParameterType) {
            Validate.notNull(theOutputParameterType, (String)"theOutputParameterType may not be null", (Object[])new Object[0]);
            RuntimeResourceDefinition def = GenericClient.this.myContext.getResourceDefinition(theOutputParameterType);
            if (def == null) {
                throw new IllegalArgumentException("theOutputParameterType must refer to a HAPI FHIR Resource type: " + theOutputParameterType.getName());
            }
            if (!"Parameters".equals(def.getName())) {
                throw new IllegalArgumentException("theOutputParameterType must refer to a HAPI FHIR Resource type for a resource named Parameters - " + theOutputParameterType.getName() + " is a resource named: " + def.getName());
            }
            this.myParameters = (IBaseParameters)def.newInstance();
            return this;
        }

        public IOperationUntypedWithInput useHttpGet() {
            this.myUseHttpGet = true;
            return this;
        }
    }

    private final class LoadPageInternal
    implements IGetPage {
        private LoadPageInternal() {
        }

        @Override
        public IGetPageTyped next(Bundle theBundle) {
            return new GetPageInternal((String)theBundle.getLinkNext().getValue());
        }

        @Override
        public IGetPageTyped previous(Bundle theBundle) {
            return new GetPageInternal((String)theBundle.getLinkPrevious().getValue());
        }

        @Override
        public IGetPageTyped url(String thePageUrl) {
            return new GetPageInternal(thePageUrl);
        }
    }

    private class HistoryInternal
    extends BaseClientExecutable
    implements IHistory,
    IHistoryUntyped,
    IHistoryTyped {
        private Integer myCount;
        private IdDt myId;
        private Class<? extends IBaseBundle> myReturnType;
        private InstantDt mySince;
        private Class<? extends IBaseResource> myType;

        private HistoryInternal() {
        }

        public IHistoryTyped andReturnBundle(Class theType) {
            this.myReturnType = theType;
            return this;
        }

        public IHistoryTyped andReturnDstu1Bundle() {
            return this;
        }

        public IHistoryTyped count(Integer theCount) {
            this.myCount = theCount;
            return this;
        }

        @Override
        public Object execute() {
            String id;
            String resourceName;
            if (this.myType != null) {
                resourceName = GenericClient.this.myContext.getResourceDefinition(this.myType).getName();
                id = null;
            } else if (this.myId != null) {
                resourceName = this.myId.getResourceType();
                id = this.myId.getIdPart();
            } else {
                resourceName = null;
                id = null;
            }
            HttpGetClientInvocation invocation = HistoryMethodBinding.createHistoryInvocation(resourceName, id, this.mySince, this.myCount);
            IClientResponseHandler<Bundle> handler = this.myReturnType != null ? new ResourceResponseHandler<IBaseBundle>(this.myReturnType, null) : new BundleResponseHandler(null);
            return this.invoke(null, handler, invocation);
        }

        @Override
        public IHistoryUntyped onInstance(IdDt theId) {
            if (!theId.hasResourceType()) {
                throw new IllegalArgumentException("Resource ID does not have a resource type: " + theId.getValue());
            }
            this.myId = theId;
            return this;
        }

        @Override
        public IHistoryUntyped onServer() {
            return this;
        }

        @Override
        public IHistoryUntyped onType(Class<? extends IBaseResource> theResourceType) {
            this.myType = theResourceType;
            return this;
        }

        public IHistoryTyped since(Date theCutoff) {
            this.mySince = theCutoff != null ? new InstantDt(theCutoff) : null;
            return this;
        }

        public IHistoryTyped since(InstantDt theCutoff) {
            this.mySince = theCutoff;
            return this;
        }
    }

    private class GetTagsInternal
    extends BaseClientExecutable<IGetTags, TagList>
    implements IGetTags {
        private String myId;
        private String myResourceName;
        private String myVersionId;

        private GetTagsInternal() {
        }

        @Override
        public TagList execute() {
            LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
            Map<String, List<String>> initial = GenericClient.this.createExtraParams();
            if (initial != null) {
                params.putAll(initial);
            }
            TagListResponseHandler binding = new TagListResponseHandler();
            ArrayList<String> urlFragments = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)this.myResourceName)) {
                urlFragments.add(this.myResourceName);
                if (StringUtils.isNotBlank((CharSequence)this.myId)) {
                    urlFragments.add(this.myId);
                    if (StringUtils.isNotBlank((CharSequence)this.myVersionId)) {
                        urlFragments.add("_history");
                        urlFragments.add(this.myVersionId);
                    }
                }
            }
            urlFragments.add("_tags");
            HttpGetClientInvocation invocation = new HttpGetClientInvocation(params, urlFragments);
            return this.invoke(params, binding, invocation);
        }

        @Override
        public IGetTags forResource(Class<? extends IResource> theClass) {
            this.setResourceClass(theClass);
            return this;
        }

        @Override
        public IGetTags forResource(Class<? extends IResource> theClass, String theId) {
            this.setResourceClass(theClass);
            this.myId = theId;
            return this;
        }

        @Override
        public IGetTags forResource(Class<? extends IResource> theClass, String theId, String theVersionId) {
            this.setResourceClass(theClass);
            this.myId = theId;
            this.myVersionId = theVersionId;
            return this;
        }

        private void setResourceClass(Class<? extends IResource> theClass) {
            this.myResourceName = theClass != null ? GenericClient.this.myContext.getResourceDefinition(theClass).getName() : null;
        }
    }

    private class GetPageInternal
    extends BaseClientExecutable<IGetPageTyped, Bundle>
    implements IGetPageTyped {
        private String myUrl;

        public GetPageInternal(String theUrl) {
            this.myUrl = theUrl;
        }

        @Override
        public Bundle execute() {
            BundleResponseHandler binding = new BundleResponseHandler(null);
            HttpSimpleGetClientInvocation invocation = new HttpSimpleGetClientInvocation(this.myUrl);
            Map<String, List<String>> params = null;
            return this.invoke(params, binding, invocation);
        }
    }

    private class DeleteInternal
    extends BaseClientExecutable<IDeleteTyped, BaseOperationOutcome>
    implements IDelete,
    IDeleteTyped,
    IDeleteWithQuery,
    IDeleteWithQueryTyped {
        private CriterionList myCriterionList;
        private IdDt myId;
        private String myResourceType;
        private String mySearchUrl;

        private DeleteInternal() {
        }

        @Override
        public IDeleteWithQueryTyped and(ICriterion<?> theCriterion) {
            this.myCriterionList.add((ICriterionInternal)((Object)theCriterion));
            return this;
        }

        @Override
        public BaseOperationOutcome execute() {
            HttpDeleteClientInvocation invocation;
            if (this.myId != null) {
                invocation = DeleteMethodBinding.createDeleteInvocation(this.myId);
            } else if (this.myCriterionList != null) {
                Map<String, List<String>> params = this.myCriterionList.toParamList();
                invocation = DeleteMethodBinding.createDeleteInvocation(this.myResourceType, params);
            } else {
                invocation = DeleteMethodBinding.createDeleteInvocation(this.mySearchUrl);
            }
            OperationOutcomeResponseHandler binding = new OperationOutcomeResponseHandler();
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            return this.invoke(params, binding, invocation);
        }

        @Override
        public IDeleteTyped resource(IResource theResource) {
            Validate.notNull((Object)theResource, (String)"theResource can not be null", (Object[])new Object[0]);
            IdDt id = theResource.getId();
            Validate.notNull((Object)id, (String)"theResource.getId() can not be null", (Object[])new Object[0]);
            if (!id.hasResourceType() || !id.hasIdPart()) {
                throw new IllegalArgumentException("theResource.getId() must contain a resource type and logical ID at a minimum (e.g. Patient/1234), found: " + id.getValue());
            }
            this.myId = id;
            return this;
        }

        @Override
        public IDeleteTyped resourceById(IdDt theId) {
            Validate.notNull((Object)theId, (String)"theId can not be null", (Object[])new Object[0]);
            if (!theId.hasResourceType() || !theId.hasIdPart()) {
                throw new IllegalArgumentException("theId must contain a resource type and logical ID at a minimum (e.g. Patient/1234)found: " + theId.getValue());
            }
            this.myId = theId;
            return this;
        }

        @Override
        public IDeleteTyped resourceById(String theResourceType, String theLogicalId) {
            Validate.notBlank((CharSequence)theResourceType, (String)"theResourceType can not be blank/null", (Object[])new Object[0]);
            if (GenericClient.this.myContext.getResourceDefinition(theResourceType) == null) {
                throw new IllegalArgumentException("Unknown resource type");
            }
            Validate.notBlank((CharSequence)theLogicalId, (String)"theLogicalId can not be blank/null", (Object[])new Object[0]);
            if (theLogicalId.contains("/")) {
                throw new IllegalArgumentException("LogicalId can not contain '/' (should only be the logical ID portion, not a qualified ID)");
            }
            this.myId = new IdDt(theResourceType, theLogicalId);
            return this;
        }

        @Override
        public IDeleteWithQuery resourceConditionalByType(String theResourceType) {
            Validate.notBlank((CharSequence)theResourceType, (String)"theResourceType can not be blank/null", (Object[])new Object[0]);
            if (GenericClient.this.myContext.getResourceDefinition(theResourceType) == null) {
                throw new IllegalArgumentException("Unknown resource type: " + theResourceType);
            }
            this.myResourceType = theResourceType;
            this.myCriterionList = new CriterionList();
            return this;
        }

        @Override
        public IDeleteTyped resourceConditionalByUrl(String theSearchUrl) {
            Validate.notBlank((CharSequence)theSearchUrl, (String)"theSearchUrl can not be blank/null", (Object[])new Object[0]);
            this.mySearchUrl = theSearchUrl;
            return this;
        }

        @Override
        public IDeleteWithQueryTyped where(ICriterion<?> theCriterion) {
            this.myCriterionList.add((ICriterionInternal)((Object)theCriterion));
            return this;
        }
    }

    private static class CriterionList
    extends ArrayList<ICriterionInternal> {
        private static final long serialVersionUID = 1L;

        private CriterionList() {
        }

        public void populateParamList(Map<String, List<String>> theParams) {
            for (ICriterionInternal next : this) {
                String parameterName = next.getParameterName();
                String parameterValue = next.getParameterValue();
                GenericClient.addParam(theParams, parameterName, parameterValue);
            }
        }

        public Map<String, List<String>> toParamList() {
            LinkedHashMap<String, List<String>> retVal = new LinkedHashMap<String, List<String>>();
            this.populateParamList(retVal);
            return retVal;
        }
    }

    private class CreateInternal
    extends BaseClientExecutable<ICreateTyped, MethodOutcome>
    implements ICreate,
    ICreateTyped,
    ICreateWithQuery,
    ICreateWithQueryTyped {
        private CriterionList myCriterionList;
        private String myId;
        private IResource myResource;
        private String myResourceBody;
        private String mySearchUrl;

        private CreateInternal() {
        }

        @Override
        public ICreateWithQueryTyped and(ICriterion<?> theCriterion) {
            this.myCriterionList.add((ICriterionInternal)((Object)theCriterion));
            return this;
        }

        @Override
        public ICreateWithQuery conditional() {
            this.myCriterionList = new CriterionList();
            return this;
        }

        @Override
        public ICreateTyped conditionalByUrl(String theSearchUrl) {
            this.mySearchUrl = theSearchUrl;
            return this;
        }

        @Override
        public MethodOutcome execute() {
            if (this.myResource == null) {
                this.myResource = this.parseResourceBody(this.myResourceBody);
            }
            this.myId = GenericClient.this.getPreferredId(this.myResource, this.myId);
            if (this.getParamEncoding() != null) {
                this.myResourceBody = null;
            }
            HttpPostClientInvocation invocation = this.mySearchUrl != null ? MethodUtil.createCreateInvocation(this.myResource, this.myResourceBody, this.myId, GenericClient.this.myContext, this.mySearchUrl) : (this.myCriterionList != null ? MethodUtil.createCreateInvocation(this.myResource, this.myResourceBody, this.myId, GenericClient.this.myContext, this.myCriterionList.toParamList()) : MethodUtil.createCreateInvocation(this.myResource, this.myResourceBody, this.myId, GenericClient.this.myContext));
            RuntimeResourceDefinition def = GenericClient.this.myContext.getResourceDefinition(this.myResource);
            String resourceName = def.getName();
            OutcomeResponseHandler binding = new OutcomeResponseHandler(resourceName);
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            return this.invoke(params, binding, invocation);
        }

        @Override
        public ICreateTyped resource(IResource theResource) {
            Validate.notNull((Object)theResource, (String)"Resource can not be null", (Object[])new Object[0]);
            this.myResource = theResource;
            return this;
        }

        @Override
        public ICreateTyped resource(String theResourceBody) {
            Validate.notBlank((CharSequence)theResourceBody, (String)"Body can not be null or blank", (Object[])new Object[0]);
            this.myResourceBody = theResourceBody;
            return this;
        }

        @Override
        public ICreateWithQueryTyped where(ICriterion<?> theCriterion) {
            this.myCriterionList.add((ICriterionInternal)((Object)theCriterion));
            return this;
        }

        @Override
        public CreateInternal withId(IdDt theId) {
            this.myId = theId.getIdPart();
            return this;
        }

        @Override
        public CreateInternal withId(String theId) {
            this.myId = theId;
            return this;
        }
    }

    private final class StringResponseHandler
    implements IClientResponseHandler<String> {
        private StringResponseHandler() {
        }

        @Override
        public String invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws IOException, BaseServerResponseException {
            return IOUtils.toString((Reader)theResponseReader);
        }
    }

    private final class BundleResponseHandler
    implements IClientResponseHandler<Bundle> {
        private Class<? extends IBaseResource> myType;

        public BundleResponseHandler(Class<? extends IBaseResource> theType) {
            this.myType = theType;
        }

        @Override
        public Bundle invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws IOException, BaseServerResponseException {
            EncodingEnum respType = EncodingEnum.forContentType(theResponseMimeType);
            if (respType == null) {
                throw NonFhirResponseException.newInstance(theResponseStatusCode, theResponseMimeType, theResponseReader);
            }
            IParser parser = respType.newParser(GenericClient.this.myContext);
            return parser.parseBundle(this.myType, theResponseReader);
        }
    }

    private abstract class BaseClientExecutable<T extends IClientExecutable<?, ?>, Y>
    implements IClientExecutable<T, Y> {
        private EncodingEnum myParamEncoding;
        private Boolean myPrettyPrint;
        private boolean myQueryLogRequestAndResponse;

        private BaseClientExecutable() {
        }

        @Override
        public T andLogRequestAndResponse(boolean theLogRequestAndResponse) {
            this.myQueryLogRequestAndResponse = theLogRequestAndResponse;
            return (T)this;
        }

        @Override
        public T encodedJson() {
            this.myParamEncoding = EncodingEnum.JSON;
            return (T)this;
        }

        @Override
        public T encodedXml() {
            this.myParamEncoding = EncodingEnum.XML;
            return (T)this;
        }

        protected EncodingEnum getParamEncoding() {
            return this.myParamEncoding;
        }

        protected <Z> Z invoke(Map<String, List<String>> theParams, IClientResponseHandler<Z> theHandler, BaseHttpClientInvocation theInvocation) {
            if (GenericClient.this.isKeepResponses()) {
                GenericClient.this.myLastRequest = theInvocation.asHttpRequest(GenericClient.this.getServerBase(), theParams, GenericClient.this.getEncoding());
            }
            Z resp = GenericClient.this.invokeClient(GenericClient.this.myContext, theHandler, theInvocation, this.myParamEncoding, this.myPrettyPrint, this.myQueryLogRequestAndResponse || GenericClient.this.myLogRequestAndResponse);
            return resp;
        }

        protected IResource parseResourceBody(String theResourceBody) {
            EncodingEnum encoding = MethodUtil.detectEncodingNoDefault(theResourceBody);
            if (encoding == null) {
                throw new InvalidRequestException("FHIR client can't determine resource encoding");
            }
            return encoding.newParser(GenericClient.this.myContext).parseResource(theResourceBody);
        }

        @Override
        public T prettyPrint() {
            this.myPrettyPrint = true;
            return (T)this;
        }
    }
}

