/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.gclient;

import ca.uhn.fhir.model.dstu.valueset.QuantityCompararatorEnum;
import ca.uhn.fhir.rest.gclient.BaseClientParam;
import ca.uhn.fhir.rest.gclient.ICriterion;
import ca.uhn.fhir.rest.gclient.IParam;
import ca.uhn.fhir.rest.gclient.NumberClientParam;
import ca.uhn.fhir.rest.gclient.QuantityCriterion;
import org.apache.commons.lang3.StringUtils;

public class QuantityClientParam
extends BaseClientParam
implements IParam {
    private String myParamName;

    public QuantityClientParam(String theParamName) {
        this.myParamName = theParamName;
    }

    public NumberClientParam.IMatches<IAndUnits> approximately() {
        return new NumberClientParam.IMatches<IAndUnits>(){

            @Override
            public IAndUnits number(long theNumber) {
                return new AndUnits("~", Long.toString(theNumber));
            }

            @Override
            public IAndUnits number(String theNumber) {
                return new AndUnits("~", theNumber);
            }
        };
    }

    public NumberClientParam.IMatches<IAndUnits> exactly() {
        return new NumberClientParam.IMatches<IAndUnits>(){

            @Override
            public IAndUnits number(long theNumber) {
                return new AndUnits("", Long.toString(theNumber));
            }

            @Override
            public IAndUnits number(String theNumber) {
                return new AndUnits("", theNumber);
            }
        };
    }

    @Override
    public String getParamName() {
        return this.myParamName;
    }

    public NumberClientParam.IMatches<IAndUnits> greaterThan() {
        return new NumberClientParam.IMatches<IAndUnits>(){

            @Override
            public IAndUnits number(long theNumber) {
                return new AndUnits(">", Long.toString(theNumber));
            }

            @Override
            public IAndUnits number(String theNumber) {
                return new AndUnits(">", theNumber);
            }
        };
    }

    public NumberClientParam.IMatches<IAndUnits> greaterThanOrEquals() {
        return new NumberClientParam.IMatches<IAndUnits>(){

            @Override
            public IAndUnits number(long theNumber) {
                return new AndUnits(">=", Long.toString(theNumber));
            }

            @Override
            public IAndUnits number(String theNumber) {
                return new AndUnits(">=", theNumber);
            }
        };
    }

    public NumberClientParam.IMatches<IAndUnits> lessThan() {
        return new NumberClientParam.IMatches<IAndUnits>(){

            @Override
            public IAndUnits number(long theNumber) {
                return new AndUnits("<", Long.toString(theNumber));
            }

            @Override
            public IAndUnits number(String theNumber) {
                return new AndUnits("<", theNumber);
            }
        };
    }

    public NumberClientParam.IMatches<IAndUnits> lessThanOrEquals() {
        return new NumberClientParam.IMatches<IAndUnits>(){

            @Override
            public IAndUnits number(long theNumber) {
                return new AndUnits("<=", Long.toString(theNumber));
            }

            @Override
            public IAndUnits number(String theNumber) {
                return new AndUnits("<=", theNumber);
            }
        };
    }

    public NumberClientParam.IMatches<IAndUnits> withComparator(QuantityCompararatorEnum theComparator) {
        final String cmp = theComparator != null ? theComparator.getCode() : "";
        return new NumberClientParam.IMatches<IAndUnits>(){

            @Override
            public IAndUnits number(long theNumber) {
                return new AndUnits(cmp, Long.toString(theNumber));
            }

            @Override
            public IAndUnits number(String theNumber) {
                return new AndUnits(cmp, theNumber);
            }
        };
    }

    private class AndUnits
    implements IAndUnits {
        private String myToken1;

        public AndUnits(String theComparator, String theNumber) {
            this.myToken1 = StringUtils.defaultString((String)theComparator) + StringUtils.defaultString((String)theNumber);
        }

        @Override
        public ICriterion<QuantityClientParam> andNoUnits() {
            return this.andUnits(null, null);
        }

        @Override
        public ICriterion<QuantityClientParam> andUnits(String theUnits) {
            return this.andUnits(theUnits, null);
        }

        @Override
        public ICriterion<QuantityClientParam> andUnits(String theSystem, String theUnits) {
            return new QuantityCriterion(QuantityClientParam.this.getParamName(), this.myToken1, StringUtils.defaultString((String)theSystem), StringUtils.defaultString((String)theUnits));
        }
    }

    public static interface IAndUnits {
        public ICriterion<QuantityClientParam> andNoUnits();

        public ICriterion<QuantityClientParam> andUnits(String var1);

        public ICriterion<QuantityClientParam> andUnits(String var1, String var2);
    }
}

