/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.dstu.valueset.RestfulOperationSystemEnum;
import ca.uhn.fhir.model.dstu.valueset.RestfulOperationTypeEnum;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.TagListParam;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.method.BaseMethodBinding;
import ca.uhn.fhir.rest.method.HttpPostClientInvocation;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.Request;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.instance.model.IBaseResource;

abstract class BaseAddOrDeleteTagsMethodBinding
extends BaseMethodBinding<Void> {
    private Class<? extends IBaseResource> myType;
    private Integer myIdParamIndex;
    private Integer myVersionIdParamIndex;
    private String myResourceName;
    private Integer myTagListParamIndex;

    public BaseAddOrDeleteTagsMethodBinding(Method theMethod, FhirContext theConetxt, Object theProvider, Class<? extends IResource> theTypeFromMethodAnnotation) {
        super(theMethod, theConetxt, theProvider);
        this.myType = theProvider instanceof IResourceProvider ? ((IResourceProvider)theProvider).getResourceType() : theTypeFromMethodAnnotation;
        if (Modifier.isInterface(this.myType.getModifiers())) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' does not specify a resource type, but has an @" + IdParam.class.getSimpleName() + " parameter. Please specity a resource type in the method annotation on this method");
        }
        this.myResourceName = theConetxt.getResourceDefinition(this.myType).getName();
        this.myIdParamIndex = MethodUtil.findIdParameterIndex(theMethod);
        this.myVersionIdParamIndex = MethodUtil.findVersionIdParameterIndex(theMethod);
        this.myTagListParamIndex = MethodUtil.findTagListParameterIndex(theMethod);
        if (this.myIdParamIndex == null) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' does not have an @" + IdParam.class.getSimpleName() + " parameter.");
        }
        if (this.myTagListParamIndex == null) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' does not have a parameter of type " + TagList.class.getSimpleName() + ", or paramater is not annotated with the @" + TagListParam.class.getSimpleName() + " annotation");
        }
    }

    @Override
    public Void invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws IOException, BaseServerResponseException {
        switch (theResponseStatusCode) {
            case 200: 
            case 201: 
            case 204: {
                return null;
            }
        }
        throw this.processNon2xxResponseAndReturnExceptionToThrow(theResponseStatusCode, theResponseMimeType, theResponseReader);
    }

    @Override
    public String getResourceName() {
        return this.myResourceName;
    }

    @Override
    public RestfulOperationTypeEnum getResourceOperationType() {
        return null;
    }

    @Override
    public RestfulOperationSystemEnum getSystemOperationType() {
        return null;
    }

    protected abstract boolean isDelete();

    @Override
    public BaseHttpClientInvocation invokeClient(Object[] theArgs) throws InternalErrorException {
        IdDt id = (IdDt)theArgs[this.myIdParamIndex];
        if (id == null || id.isEmpty()) {
            throw new InvalidRequestException("ID must not be null or empty for this operation");
        }
        IdDt versionId = null;
        if (this.myVersionIdParamIndex != null) {
            versionId = (IdDt)theArgs[this.myVersionIdParamIndex];
        }
        TagList tagList = (TagList)theArgs[this.myTagListParamIndex];
        Class<? extends IBaseResource> type = this.myType;
        assert (type != null);
        HttpPostClientInvocation retVal = this.isDelete() ? (versionId != null ? new HttpPostClientInvocation(this.getContext(), tagList, this.getResourceName(), id.getValue(), "_history", versionId.getValue(), "_tags", "_delete") : new HttpPostClientInvocation(this.getContext(), tagList, this.getResourceName(), id.getValue(), "_tags", "_delete")) : (versionId != null ? new HttpPostClientInvocation(this.getContext(), tagList, this.getResourceName(), id.getValue(), "_history", versionId.getValue(), "_tags") : new HttpPostClientInvocation(this.getContext(), tagList, this.getResourceName(), id.getValue(), "_tags"));
        for (int idx = 0; idx < theArgs.length; ++idx) {
            IParameter nextParam = this.getParameters().get(idx);
            nextParam.translateClientArgumentIntoQueryArgument(this.getContext(), theArgs[idx], null, null);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeServer(RestfulServer theServer, Request theRequest) throws BaseServerResponseException, IOException {
        Object[] params = this.createParametersForServerRequest(theRequest, null);
        params[this.myIdParamIndex.intValue()] = theRequest.getId();
        if (this.myVersionIdParamIndex != null) {
            params[this.myVersionIdParamIndex.intValue()] = theRequest.getId();
        }
        IParser parser = this.createAppropriateParserForParsingServerRequest(theRequest);
        BufferedReader reader = theRequest.getServletRequest().getReader();
        try {
            TagList tagList = parser.parseTagList(reader);
            params[this.myTagListParamIndex.intValue()] = tagList;
        }
        finally {
            ((Reader)reader).close();
        }
        this.invokeServerMethod(params);
        for (int i = theServer.getInterceptors().size() - 1; i >= 0; --i) {
            IServerInterceptor next = theServer.getInterceptors().get(i);
            boolean continueProcessing = next.outgoingResponse(theRequest, theRequest.getServletRequest(), theRequest.getServletResponse());
            if (continueProcessing) continue;
            return;
        }
        HttpServletResponse response = theRequest.getServletResponse();
        response.setContentType("text/plain");
        response.setStatus(200);
        response.setCharacterEncoding("UTF-8");
        theServer.addHeadersToResponse(response);
        PrintWriter writer = response.getWriter();
        writer.close();
    }

    @Override
    public boolean incomingServerRequestMatchesMethod(Request theRequest) {
        if (theRequest.getRequestType() != RequestTypeEnum.POST) {
            return false;
        }
        if (!"_tags".equals(theRequest.getOperation())) {
            return false;
        }
        if (!this.myResourceName.equals(theRequest.getResourceName())) {
            return false;
        }
        if (theRequest.getId() == null) {
            return false;
        }
        return !(this.isDelete() ? !"_delete".equals(theRequest.getSecondaryOperation()) : theRequest.getSecondaryOperation() != null);
    }
}

