/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.base.resource.BaseOperationOutcome;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.method.BaseMethodBinding;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.Request;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseOutcomeReturningMethodBinding
extends BaseMethodBinding<MethodOutcome> {
    static final Logger ourLog = LoggerFactory.getLogger(BaseOutcomeReturningMethodBinding.class);
    private boolean myReturnVoid;

    public BaseOutcomeReturningMethodBinding(Method theMethod, FhirContext theContext, Class<?> theMethodAnnotation, Object theProvider) {
        super(theMethod, theContext, theProvider);
        if (!theMethod.getReturnType().equals(MethodOutcome.class)) {
            if (!this.allowVoidReturnType()) {
                throw new ConfigurationException("Method " + theMethod.getName() + " in type " + theMethod.getDeclaringClass().getCanonicalName() + " is a @" + theMethodAnnotation.getSimpleName() + " method but it does not return " + MethodOutcome.class);
            }
            if (theMethod.getReturnType() == Void.TYPE) {
                this.myReturnVoid = true;
            }
        }
    }

    private void addLocationHeader(Request theRequest, HttpServletResponse theResponse, MethodOutcome response, String headerLocation) {
        StringBuilder b = new StringBuilder();
        b.append(theRequest.getFhirServerBase());
        b.append('/');
        b.append(this.getResourceName());
        b.append('/');
        b.append(response.getId().getIdPart());
        if (response.getId().hasVersionIdPart()) {
            b.append("/_history/");
            b.append(response.getId().getVersionIdPart());
        } else if (response.getVersionId() != null && !response.getVersionId().isEmpty()) {
            b.append("/_history/");
            b.append(response.getVersionId().getValue());
        }
        theResponse.addHeader(headerLocation, b.toString());
    }

    protected abstract void addParametersForServerRequest(Request var1, Object[] var2);

    protected boolean allowVoidReturnType() {
        return false;
    }

    protected abstract BaseHttpClientInvocation createClientInvocation(Object[] var1, IResource var2);

    protected abstract String getMatchingOperation();

    @Override
    public boolean incomingServerRequestMatchesMethod(Request theRequest) {
        RequestTypeEnum requestType;
        Set<RequestTypeEnum> allowableRequestTypes = this.provideAllowableRequestTypes();
        if (!allowableRequestTypes.contains((Object)(requestType = theRequest.getRequestType()))) {
            return false;
        }
        if (!this.getResourceName().equals(theRequest.getResourceName())) {
            return false;
        }
        if (this.getMatchingOperation() == null && StringUtils.isNotBlank((CharSequence)theRequest.getOperation())) {
            return false;
        }
        return this.getMatchingOperation() == null || this.getMatchingOperation().equals(theRequest.getOperation());
    }

    @Override
    public MethodOutcome invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws IOException, BaseServerResponseException {
        switch (theResponseStatusCode) {
            case 200: 
            case 201: 
            case 204: {
                if (this.myReturnVoid) {
                    return null;
                }
                MethodOutcome retVal = MethodUtil.process2xxResponse(this.getContext(), this.getResourceName(), theResponseStatusCode, theResponseMimeType, theResponseReader, theHeaders);
                return retVal;
            }
        }
        throw this.processNon2xxResponseAndReturnExceptionToThrow(theResponseStatusCode, theResponseMimeType, theResponseReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeServer(RestfulServer theServer, Request theRequest) throws BaseServerResponseException, IOException {
        MethodOutcome response;
        IResource resource;
        if (this.requestContainsResource()) {
            resource = this.parseIncomingServerResource(theRequest);
            TagList tagList = new TagList();
            Enumeration enumeration = theRequest.getServletRequest().getHeaders("Category");
            while (enumeration.hasMoreElements()) {
                String nextTagComplete = (String)enumeration.nextElement();
                MethodUtil.parseTagValue(tagList, nextTagComplete);
            }
            if (!tagList.isEmpty()) {
                resource.getResourceMetadata().put(ResourceMetadataKeyEnum.TAG_LIST, tagList);
            }
        } else {
            resource = null;
        }
        Object[] params = this.createParametersForServerRequest(theRequest, resource);
        this.addParametersForServerRequest(theRequest, params);
        HttpServletResponse servletResponse = theRequest.getServletResponse();
        try {
            response = (MethodOutcome)this.invokeServerMethod(params);
        }
        catch (InternalErrorException e) {
            ourLog.error("Internal error during method invocation", (Throwable)e);
            EncodingEnum encodingNotNull = RestfulServerUtils.determineResponseEncodingWithDefault(theServer, theRequest.getServletRequest());
            this.streamOperationOutcome(e, theServer, encodingNotNull, servletResponse, theRequest);
            return;
        }
        catch (BaseServerResponseException e) {
            ourLog.info("Exception during method invocation: " + e.getMessage());
            EncodingEnum encodingNotNull = RestfulServerUtils.determineResponseEncodingWithDefault(theServer, theRequest.getServletRequest());
            this.streamOperationOutcome(e, theServer, encodingNotNull, servletResponse, theRequest);
            return;
        }
        if (response != null && response.getId() != null && response.getId().hasResourceType() && this.getContext().getResourceDefinition(response.getId().getResourceType()) == null) {
            throw new InternalErrorException("Server method returned invalid resource ID: " + response.getId().getValue());
        }
        BaseOperationOutcome outcome = response != null ? response.getOperationOutcome() : null;
        for (int i = theServer.getInterceptors().size() - 1; i >= 0; --i) {
            IServerInterceptor next = theServer.getInterceptors().get(i);
            boolean continueProcessing = next.outgoingResponse((RequestDetails)theRequest, outcome, theRequest.getServletRequest(), theRequest.getServletResponse());
            if (continueProcessing) continue;
            return;
        }
        switch (this.getResourceOperationType()) {
            case CREATE: {
                if (response == null) {
                    throw new InternalErrorException("Method " + this.getMethod().getName() + " in type " + this.getMethod().getDeclaringClass().getCanonicalName() + " returned null, which is not allowed for create operation");
                }
                if (response.getCreated() == null || Boolean.TRUE.equals(response.getCreated())) {
                    servletResponse.setStatus(201);
                } else {
                    servletResponse.setStatus(200);
                }
                this.addContentLocationHeaders(theRequest, servletResponse, response);
                break;
            }
            case UPDATE: {
                if (response == null || response.getCreated() == null || Boolean.FALSE.equals(response.getCreated())) {
                    servletResponse.setStatus(200);
                } else {
                    servletResponse.setStatus(201);
                }
                this.addContentLocationHeaders(theRequest, servletResponse, response);
                break;
            }
            default: {
                if (response == null) {
                    if (!this.isReturnVoid()) {
                        throw new InternalErrorException("Method " + this.getMethod().getName() + " in type " + this.getMethod().getDeclaringClass().getCanonicalName() + " returned null");
                    }
                    servletResponse.setStatus(204);
                    break;
                }
                if (response.getOperationOutcome() == null) {
                    servletResponse.setStatus(204);
                    break;
                }
                servletResponse.setStatus(200);
            }
        }
        theServer.addHeadersToResponse(servletResponse);
        if (outcome != null) {
            EncodingEnum encoding = RestfulServerUtils.determineResponseEncodingWithDefault(theServer, theRequest.getServletRequest());
            servletResponse.setContentType(encoding.getResourceContentType());
            PrintWriter writer = servletResponse.getWriter();
            IParser parser = encoding.newParser(this.getContext());
            parser.setPrettyPrint(RestfulServerUtils.prettyPrintResponse(theServer, theRequest));
            try {
                parser.encodeResourceToWriter(response.getOperationOutcome(), writer);
            }
            finally {
                ((Writer)writer).close();
            }
        } else {
            servletResponse.setContentType("text/plain; charset=UTF-8");
            PrintWriter writer = servletResponse.getWriter();
            ((Writer)writer).close();
        }
    }

    private void addContentLocationHeaders(Request theRequest, HttpServletResponse servletResponse, MethodOutcome response) {
        if (response != null && response.getId() != null) {
            this.addLocationHeader(theRequest, servletResponse, response, "Location");
            this.addLocationHeader(theRequest, servletResponse, response, "Content-Location");
        }
    }

    public boolean isReturnVoid() {
        return this.myReturnVoid;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected IResource parseIncomingServerResource(Request theRequest) throws IOException {
        void var2_10;
        EncodingEnum encoding = RestfulServerUtils.determineRequestEncodingNoDefault(theRequest);
        if (encoding == null) {
            String ctValue = theRequest.getServletRequest().getHeader("Content-Type");
            if (ctValue != null && ctValue.startsWith("application/x-www-form-urlencoded")) {
                String msg = this.getContext().getLocalizer().getMessage(BaseOutcomeReturningMethodBinding.class, "invalidContentTypeInRequest", ctValue, this.getResourceOrSystemOperationType());
                throw new InvalidRequestException(msg);
            }
            if (!StringUtils.isBlank((CharSequence)ctValue)) {
                String msg = this.getContext().getLocalizer().getMessage(BaseOutcomeReturningMethodBinding.class, "invalidContentTypeInRequest", ctValue, this.getResourceOrSystemOperationType());
                throw new InvalidRequestException(msg);
            }
            BufferedReader bufferedReader = theRequest.getServletRequest().getReader();
            String body = IOUtils.toString((Reader)bufferedReader);
            encoding = MethodUtil.detectEncodingNoDefault(body);
            if (encoding == null) {
                String msg = this.getContext().getLocalizer().getMessage(BaseOutcomeReturningMethodBinding.class, "noContentTypeInRequest", this.getResourceOrSystemOperationType());
                throw new InvalidRequestException(msg);
            }
            StringReader stringReader = new StringReader(body);
        } else {
            BufferedReader bufferedReader = theRequest.getServletRequest().getReader();
        }
        IParser parser = encoding.newParser(this.getContext());
        Class<? extends IBaseResource> wantedResourceType = this.requestContainsResourceType();
        IResource retVal = wantedResourceType != null ? (IResource)parser.parseResource(wantedResourceType, (Reader)var2_10) : parser.parseResource((Reader)var2_10);
        retVal.setId(theRequest.getId());
        return retVal;
    }

    protected abstract Set<RequestTypeEnum> provideAllowableRequestTypes();

    protected boolean requestContainsResource() {
        return true;
    }

    protected Class<? extends IBaseResource> requestContainsResourceType() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void streamOperationOutcome(BaseServerResponseException theE, RestfulServer theServer, EncodingEnum theEncodingNotNull, HttpServletResponse theResponse, Request theRequest) throws IOException {
        theResponse.setStatus(theE.getStatusCode());
        theServer.addHeadersToResponse(theResponse);
        if (theE.getOperationOutcome() != null) {
            theResponse.setContentType(theEncodingNotNull.getResourceContentType());
            IParser parser = theEncodingNotNull.newParser(theServer.getFhirContext());
            parser.setPrettyPrint(RestfulServerUtils.prettyPrintResponse(theServer, theRequest));
            PrintWriter writer = theResponse.getWriter();
            try {
                parser.encodeResourceToWriter(theE.getOperationOutcome(), writer);
            }
            finally {
                ((Writer)writer).close();
            }
        }
        theResponse.setContentType("text/plain");
        PrintWriter writer = theResponse.getWriter();
        try {
            ((Writer)writer).append(theE.getMessage());
        }
        finally {
            ((Writer)writer).close();
        }
    }

    protected static void parseContentLocation(MethodOutcome theOutcomeToPopulate, String theResourceName, String theLocationHeader) {
        String versionIdPart;
        int historyIdStart;
        int idIndexStart;
        int idIndexEnd;
        if (StringUtils.isBlank((CharSequence)theLocationHeader)) {
            return;
        }
        theOutcomeToPopulate.setId(new IdDt(theLocationHeader));
        String resourceNamePart = "/" + theResourceName + "/";
        int resourceIndex = theLocationHeader.lastIndexOf(resourceNamePart);
        if (resourceIndex > -1 && (idIndexEnd = theLocationHeader.indexOf(47, idIndexStart = resourceIndex + resourceNamePart.length())) != -1 && (historyIdStart = theLocationHeader.indexOf(versionIdPart = "/_history/", idIndexEnd)) != -1) {
            theOutcomeToPopulate.setVersionId(new IdDt(theLocationHeader.substring(historyIdStart + versionIdPart.length())));
        }
    }
}

