/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.rest.annotation.ResourceParam;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.method.BaseOutcomeReturningMethodBinding;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.Request;
import ca.uhn.fhir.rest.param.ResourceParameter;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.instance.model.IBaseResource;
import org.hl7.fhir.instance.model.api.IBaseBinary;

abstract class BaseOutcomeReturningMethodBindingWithResourceParam
extends BaseOutcomeReturningMethodBinding {
    private int myResourceParameterIndex;
    private String myResourceName;
    private boolean myBinary;
    private Class<? extends IBaseResource> myResourceType;
    private Integer myIdParamIndex;

    public BaseOutcomeReturningMethodBindingWithResourceParam(Method theMethod, FhirContext theContext, Class<?> theMethodAnnotation, Object theProvider) {
        super(theMethod, theContext, theMethodAnnotation, theProvider);
        ResourceParameter resourceParameter = null;
        int index = 0;
        for (IParameter next : this.getParameters()) {
            if (next instanceof ResourceParameter) {
                if (this.myResourceType != null) {
                    throw new ConfigurationException("Method " + theMethod.getName() + " on type " + theMethod.getDeclaringClass() + " has more than one @ResourceParam. Only one is allowed.");
                }
                resourceParameter = (ResourceParameter)next;
                Class<IBaseResource> providerResourceType = resourceParameter.getResourceType();
                if (theProvider instanceof IResourceProvider) {
                    providerResourceType = ((IResourceProvider)theProvider).getResourceType();
                }
                if (IBaseBinary.class.isAssignableFrom(providerResourceType)) {
                    this.myBinary = true;
                }
                this.myResourceType = resourceParameter.getResourceType();
                if (Modifier.isAbstract(this.myResourceType.getModifiers())) {
                    this.myResourceType = providerResourceType;
                }
                this.myResourceName = theContext.getResourceDefinition(providerResourceType).getName();
                this.myResourceParameterIndex = index;
            }
            ++index;
        }
        this.myIdParamIndex = MethodUtil.findIdParameterIndex(theMethod);
        if (resourceParameter == null) {
            throw new ConfigurationException("Method " + theMethod.getName() + " in type " + theMethod.getDeclaringClass().getCanonicalName() + " does not have a parameter annotated with @" + ResourceParam.class.getSimpleName());
        }
    }

    @Override
    protected Class<? extends IBaseResource> requestContainsResourceType() {
        return this.myResourceType;
    }

    @Override
    protected IResource parseIncomingServerResource(Request theRequest) throws IOException {
        if (this.myBinary) {
            String ct = theRequest.getServletRequest().getHeader("Content-Type");
            byte[] contents = IOUtils.toByteArray((InputStream)theRequest.getServletRequest().getInputStream());
            IBaseBinary binary = (IBaseBinary)this.getContext().getResourceDefinition("Binary").newInstance();
            binary.setContentType(ct);
            binary.setContent(contents);
            return (IResource)((Object)binary);
        }
        return super.parseIncomingServerResource(theRequest);
    }

    @Override
    protected void addParametersForServerRequest(Request theRequest, Object[] theParams) {
        if (this.myIdParamIndex != null) {
            theParams[this.myIdParamIndex.intValue()] = theRequest.getId();
        }
    }

    @Override
    public String getResourceName() {
        return this.myResourceName;
    }

    @Override
    public BaseHttpClientInvocation invokeClient(Object[] theArgs) throws InternalErrorException {
        IResource resource = (IResource)theArgs[this.myResourceParameterIndex];
        if (resource == null) {
            throw new NullPointerException("Resource can not be null");
        }
        BaseHttpClientInvocation retVal = this.createClientInvocation(theArgs, resource);
        return retVal;
    }
}

