/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.client.exceptions.InvalidResponseException;
import ca.uhn.fhir.rest.method.BaseMethodBinding;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.Request;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.IBundleProvider;
import ca.uhn.fhir.rest.server.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.util.ReflectionUtil;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.instance.model.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseResourceReturningMethodBinding
extends BaseMethodBinding<Object> {
    protected static final Set<String> ALLOWED_PARAMS;
    private static final Logger ourLog;
    private MethodReturnTypeEnum myMethodReturnType;
    private Class<?> myResourceListCollectionType;
    private String myResourceName;
    private Class<? extends IResource> myResourceType;

    public BaseResourceReturningMethodBinding(Class<?> theReturnResourceType, Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod, theContext, theProvider);
        Class<?> methodReturnType = theMethod.getReturnType();
        if (Collection.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = MethodReturnTypeEnum.LIST_OF_RESOURCES;
            Class<?> collectionType = ReflectionUtil.getGenericCollectionTypeOfMethodReturnType(theMethod);
            if (collectionType != null && !Object.class.equals(collectionType) && !IResource.class.isAssignableFrom(collectionType)) {
                throw new ConfigurationException("Method " + theMethod.getDeclaringClass().getSimpleName() + "#" + theMethod.getName() + " returns an invalid collection generic type: " + collectionType);
            }
            this.myResourceListCollectionType = collectionType;
        } else if (IBaseResource.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = !Modifier.isAbstract(methodReturnType.getModifiers()) && theContext.getResourceDefinition(methodReturnType).isBundle() ? MethodReturnTypeEnum.BUNDLE_RESOURCE : MethodReturnTypeEnum.RESOURCE;
        } else if (Bundle.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = MethodReturnTypeEnum.BUNDLE;
        } else if (IBundleProvider.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = MethodReturnTypeEnum.BUNDLE_PROVIDER;
        } else {
            throw new ConfigurationException("Invalid return type '" + methodReturnType.getCanonicalName() + "' on method '" + theMethod.getName() + "' on type: " + theMethod.getDeclaringClass().getCanonicalName());
        }
        if (theReturnResourceType != null && IResource.class.isAssignableFrom(theReturnResourceType)) {
            ResourceDef resourceDefAnnotation = theReturnResourceType.getAnnotation(ResourceDef.class);
            if (resourceDefAnnotation == null) {
                if (!Modifier.isAbstract(theReturnResourceType.getModifiers())) {
                    throw new ConfigurationException(theReturnResourceType.getCanonicalName() + " has no @" + ResourceDef.class.getSimpleName() + " annotation");
                }
            } else {
                this.myResourceType = theReturnResourceType;
                this.myResourceName = resourceDefAnnotation.name();
            }
        }
    }

    public MethodReturnTypeEnum getMethodReturnType() {
        return this.myMethodReturnType;
    }

    @Override
    public String getResourceName() {
        return this.myResourceName;
    }

    protected abstract BundleTypeEnum getResponseBundleType();

    public abstract ReturnTypeEnum getReturnType();

    @Override
    public Object invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws IOException {
        IParser parser = this.createAppropriateParserForParsingResponse(theResponseMimeType, theResponseReader, theResponseStatusCode);
        switch (this.getReturnType()) {
            case BUNDLE: {
                Bundle bundle = this.myResourceType != null ? parser.parseBundle(this.myResourceType, theResponseReader) : parser.parseBundle(theResponseReader);
                switch (this.getMethodReturnType()) {
                    case BUNDLE: {
                        return bundle;
                    }
                    case LIST_OF_RESOURCES: {
                        List<IResource> listOfResources;
                        if (this.myResourceListCollectionType != null) {
                            listOfResources = new ArrayList<IResource>();
                            for (IResource next : bundle.toListOfResources()) {
                                if (!this.myResourceListCollectionType.isAssignableFrom(next.getClass())) {
                                    ourLog.debug("Not returning resource of type {} because it is not a subclass or instance of {}", next.getClass(), this.myResourceListCollectionType);
                                    continue;
                                }
                                listOfResources.add(next);
                            }
                        } else {
                            listOfResources = bundle.toListOfResources();
                        }
                        return listOfResources;
                    }
                    case RESOURCE: {
                        List<IResource> list = bundle.toListOfResources();
                        if (list.size() == 0) {
                            return null;
                        }
                        if (list.size() == 1) {
                            return list.get(0);
                        }
                        throw new InvalidResponseException(theResponseStatusCode, "FHIR server call returned a bundle with multiple resources, but this method is only able to returns one.");
                    }
                    case BUNDLE_PROVIDER: {
                        throw new IllegalStateException("Return type of " + IBundleProvider.class.getSimpleName() + " is not supported in clients");
                    }
                }
                break;
            }
            case RESOURCE: {
                IResource resource = this.myResourceType != null ? parser.parseResource(this.myResourceType, theResponseReader) : parser.parseResource(theResponseReader);
                MethodUtil.parseClientRequestResourceHeaders(null, theHeaders, resource);
                switch (this.getMethodReturnType()) {
                    case BUNDLE: {
                        return Bundle.withSingleResource(resource);
                    }
                    case LIST_OF_RESOURCES: {
                        return Collections.singletonList(resource);
                    }
                    case RESOURCE: {
                        return resource;
                    }
                    case BUNDLE_PROVIDER: {
                        throw new IllegalStateException("Return type of " + IBundleProvider.class.getSimpleName() + " is not supported in clients");
                    }
                }
                break;
            }
        }
        throw new IllegalStateException("Should not get here!");
    }

    public abstract Object invokeServer(RequestDetails var1, Object[] var2) throws InvalidRequestException, InternalErrorException;

    @Override
    public void invokeServer(RestfulServer theServer, Request theRequest) throws BaseServerResponseException, IOException {
        boolean prettyPrint = RestfulServerUtils.prettyPrintResponse(theServer, theRequest);
        RestfulServer.NarrativeModeEnum narrativeMode = RestfulServerUtils.determineNarrativeMode(theRequest);
        EncodingEnum responseEncoding = RestfulServerUtils.determineResponseEncodingNoDefault(theRequest.getServletRequest());
        String uaHeader = theRequest.getServletRequest().getHeader("user-agent");
        boolean requestIsBrowser = false;
        if (uaHeader != null && uaHeader.contains("Mozilla")) {
            requestIsBrowser = true;
        }
        Object requestObject = this.parseRequestObject(theRequest);
        Object[] params = new Object[this.getParameters().size()];
        for (int i = 0; i < this.getParameters().size(); ++i) {
            IParameter param = this.getParameters().get(i);
            if (param == null) continue;
            params[i] = param.translateQueryParametersIntoServerArgument(theRequest, requestObject);
        }
        Object resultObj = this.invokeServer(theRequest, params);
        Integer count = RestfulServerUtils.extractCountParameter(theRequest.getServletRequest());
        boolean respondGzip = theRequest.isRespondGzip();
        HttpServletResponse response = theRequest.getServletResponse();
        switch (this.getReturnType()) {
            case BUNDLE: {
                if (this.getMethodReturnType() == MethodReturnTypeEnum.BUNDLE_RESOURCE) {
                    IResource resource;
                    if (resultObj instanceof IBundleProvider) {
                        IBundleProvider result = (IBundleProvider)resultObj;
                        resource = result.getResources(0, 1).get(0);
                    } else {
                        resource = (IResource)resultObj;
                    }
                    IVersionSpecificBundleFactory bundleFactory = theServer.getFhirContext().newBundleFactory();
                    bundleFactory.initializeWithBundleResource(resource);
                    bundleFactory.addRootPropertiesToBundle(null, theRequest.getFhirServerBase(), theRequest.getCompleteUrl(), count, this.getResponseBundleType());
                    for (int i = theServer.getInterceptors().size() - 1; i >= 0; --i) {
                        IServerInterceptor next = theServer.getInterceptors().get(i);
                        boolean continueProcessing = next.outgoingResponse((RequestDetails)theRequest, resource, theRequest.getServletRequest(), theRequest.getServletResponse());
                        if (continueProcessing) continue;
                        ourLog.debug("Interceptor {} returned false, not continuing processing");
                        return;
                    }
                    RestfulServerUtils.streamResponseAsResource(theServer, response, resource, responseEncoding, prettyPrint, requestIsBrowser, narrativeMode, 200, respondGzip, theRequest.getFhirServerBase(), this.isAddContentLocationHeader());
                    break;
                }
                Set<Include> includes = this.getRequestIncludesFromParams(params);
                IBundleProvider result = (IBundleProvider)resultObj;
                if (count == null) {
                    count = result.preferredPageSize();
                }
                IVersionSpecificBundleFactory bundleFactory = theServer.getFhirContext().newBundleFactory();
                bundleFactory.initializeBundleFromBundleProvider(theServer, result, responseEncoding, theRequest.getFhirServerBase(), theRequest.getCompleteUrl(), prettyPrint, 0, count, null, this.getResponseBundleType(), includes);
                Bundle bundle = bundleFactory.getDstu1Bundle();
                if (bundle != null) {
                    for (int i = theServer.getInterceptors().size() - 1; i >= 0; --i) {
                        IServerInterceptor next = theServer.getInterceptors().get(i);
                        boolean continueProcessing = next.outgoingResponse((RequestDetails)theRequest, bundle, theRequest.getServletRequest(), theRequest.getServletResponse());
                        if (continueProcessing) continue;
                        ourLog.debug("Interceptor {} returned false, not continuing processing");
                        return;
                    }
                    RestfulServerUtils.streamResponseAsBundle(theServer, response, bundle, responseEncoding, theRequest.getFhirServerBase(), prettyPrint, narrativeMode, respondGzip, requestIsBrowser);
                    break;
                }
                IResource resBundle = bundleFactory.getResourceBundle();
                for (int i = theServer.getInterceptors().size() - 1; i >= 0; --i) {
                    IServerInterceptor next = theServer.getInterceptors().get(i);
                    boolean continueProcessing = next.outgoingResponse((RequestDetails)theRequest, resBundle, theRequest.getServletRequest(), theRequest.getServletResponse());
                    if (continueProcessing) continue;
                    ourLog.debug("Interceptor {} returned false, not continuing processing");
                    return;
                }
                RestfulServerUtils.streamResponseAsResource(theServer, response, resBundle, responseEncoding, prettyPrint, requestIsBrowser, narrativeMode, 200, theRequest.isRespondGzip(), theRequest.getFhirServerBase(), this.isAddContentLocationHeader());
                break;
            }
            case RESOURCE: {
                IBundleProvider result = (IBundleProvider)resultObj;
                if (result.size() == 0) {
                    throw new ResourceNotFoundException(theRequest.getId());
                }
                if (result.size() > 1) {
                    throw new InternalErrorException("Method returned multiple resources");
                }
                IResource resource = result.getResources(0, 1).get(0);
                for (int i = theServer.getInterceptors().size() - 1; i >= 0; --i) {
                    IServerInterceptor next = theServer.getInterceptors().get(i);
                    boolean continueProcessing = next.outgoingResponse((RequestDetails)theRequest, resource, theRequest.getServletRequest(), theRequest.getServletResponse());
                    if (continueProcessing) continue;
                    return;
                }
                RestfulServerUtils.streamResponseAsResource(theServer, response, resource, responseEncoding, prettyPrint, requestIsBrowser, narrativeMode, 200, respondGzip, theRequest.getFhirServerBase(), this.isAddContentLocationHeader());
                break;
            }
        }
    }

    protected boolean isAddContentLocationHeader() {
        return true;
    }

    protected Object parseRequestObject(Request theRequest) throws IOException {
        return null;
    }

    protected void setResourceName(String theResourceName) {
        this.myResourceName = theResourceName;
    }

    static {
        ourLog = LoggerFactory.getLogger(BaseResourceReturningMethodBinding.class);
        HashSet<String> set = new HashSet<String>();
        set.add("_format");
        set.add("_narrative");
        set.add("_pretty");
        set.add("_sort");
        set.add("_sort:asc");
        set.add("_sort:desc");
        set.add("_count");
        ALLOWED_PARAMS = Collections.unmodifiableSet(set);
    }

    public static enum ReturnTypeEnum {
        BUNDLE,
        RESOURCE;

    }

    public static enum MethodReturnTypeEnum {
        BUNDLE,
        BUNDLE_PROVIDER,
        BUNDLE_RESOURCE,
        LIST_OF_RESOURCES,
        RESOURCE;

    }
}

