/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.dstu.valueset.RestfulOperationTypeEnum;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.Request;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.IBaseResource;

class ConditionalParamBinder
implements IParameter {
    private RestfulOperationTypeEnum myOperationType;

    ConditionalParamBinder(RestfulOperationTypeEnum theOperationType) {
        Validate.notNull((Object)((Object)theOperationType), (String)"theOperationType can not be null", (Object[])new Object[0]);
        this.myOperationType = theOperationType;
    }

    @Override
    public void translateClientArgumentIntoQueryArgument(FhirContext theContext, Object theSourceClientArgument, Map<String, List<String>> theTargetQueryArguments, IBaseResource theTargetResource) throws InternalErrorException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object translateQueryParametersIntoServerArgument(Request theRequest, Object theRequestContents) throws InternalErrorException, InvalidRequestException {
        if (this.myOperationType == RestfulOperationTypeEnum.CREATE) {
            String retVal = theRequest.getServletRequest().getHeader("If-None-Exist");
            if (StringUtils.isBlank((CharSequence)retVal)) {
                return null;
            }
            if (retVal.startsWith(theRequest.getFhirServerBase())) {
                retVal = retVal.substring(theRequest.getFhirServerBase().length());
            }
            return retVal;
        }
        if (this.myOperationType != RestfulOperationTypeEnum.DELETE && this.myOperationType != RestfulOperationTypeEnum.UPDATE) {
            return null;
        }
        if (theRequest.getId() != null && theRequest.getId().hasIdPart()) {
            return null;
        }
        boolean haveParam = false;
        for (String next : theRequest.getParameters().keySet()) {
            if (next.startsWith("_")) continue;
            haveParam = true;
            break;
        }
        if (!haveParam) {
            return null;
        }
        int questionMarkIndex = theRequest.getCompleteUrl().indexOf(63);
        return theRequest.getResourceName() + theRequest.getCompleteUrl().substring(questionMarkIndex);
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
    }
}

