/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.dstu.valueset.RestfulOperationSystemEnum;
import ca.uhn.fhir.model.dstu.valueset.RestfulOperationTypeEnum;
import ca.uhn.fhir.rest.annotation.Create;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.method.BaseOutcomeReturningMethodBindingWithResourceParam;
import ca.uhn.fhir.rest.method.HttpPostClientInvocation;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.Request;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;

public class CreateMethodBinding
extends BaseOutcomeReturningMethodBindingWithResourceParam {
    public CreateMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod, theContext, Create.class, theProvider);
    }

    @Override
    public RestfulOperationTypeEnum getResourceOperationType() {
        return RestfulOperationTypeEnum.CREATE;
    }

    @Override
    public RestfulOperationSystemEnum getSystemOperationType() {
        return null;
    }

    @Override
    protected Set<RequestTypeEnum> provideAllowableRequestTypes() {
        return Collections.singleton(RequestTypeEnum.POST);
    }

    @Override
    protected IResource parseIncomingServerResource(Request theRequest) throws IOException {
        IResource retVal = super.parseIncomingServerResource(theRequest);
        if (theRequest.getId() != null && theRequest.getId().hasIdPart()) {
            retVal.setId(theRequest.getId());
        }
        return retVal;
    }

    @Override
    protected BaseHttpClientInvocation createClientInvocation(Object[] theArgs, IResource theResource) {
        FhirContext context = this.getContext();
        HttpPostClientInvocation retVal = MethodUtil.createCreateInvocation(theResource, context);
        if (theArgs != null) {
            for (int idx = 0; idx < theArgs.length; ++idx) {
                IParameter nextParam = this.getParameters().get(idx);
                nextParam.translateClientArgumentIntoQueryArgument(this.getContext(), theArgs[idx], null, null);
            }
        }
        return retVal;
    }

    @Override
    protected String getMatchingOperation() {
        return null;
    }
}

