/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.PathSpecification;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.Tag;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.base.resource.BaseOperationOutcome;
import ca.uhn.fhir.model.dstu.valueset.RestfulOperationTypeEnum;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.annotation.ConditionalUrlParam;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RequiredParam;
import ca.uhn.fhir.rest.annotation.ResourceParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.ServerBase;
import ca.uhn.fhir.rest.annotation.Since;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.annotation.TagListParam;
import ca.uhn.fhir.rest.annotation.TransactionParam;
import ca.uhn.fhir.rest.annotation.VersionIdParam;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.method.BaseOutcomeReturningMethodBinding;
import ca.uhn.fhir.rest.method.ConditionalParamBinder;
import ca.uhn.fhir.rest.method.CountParameter;
import ca.uhn.fhir.rest.method.DynamicSearchParameter;
import ca.uhn.fhir.rest.method.HttpGetClientInvocation;
import ca.uhn.fhir.rest.method.HttpPostClientInvocation;
import ca.uhn.fhir.rest.method.HttpPutClientInvocation;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.IncludeParameter;
import ca.uhn.fhir.rest.method.NarrativeModeParameter;
import ca.uhn.fhir.rest.method.NullParameter;
import ca.uhn.fhir.rest.method.OperationParamBinder;
import ca.uhn.fhir.rest.method.QualifiedParamList;
import ca.uhn.fhir.rest.method.QueryParameterAndBinder;
import ca.uhn.fhir.rest.method.SearchParameter;
import ca.uhn.fhir.rest.method.ServerBaseParamBinder;
import ca.uhn.fhir.rest.method.ServletRequestParameter;
import ca.uhn.fhir.rest.method.ServletResponseParameter;
import ca.uhn.fhir.rest.method.SinceParameter;
import ca.uhn.fhir.rest.method.SortParameter;
import ca.uhn.fhir.rest.method.TransactionParamBinder;
import ca.uhn.fhir.rest.param.CollectionBinder;
import ca.uhn.fhir.rest.param.DateAndListParam;
import ca.uhn.fhir.rest.param.NumberAndListParam;
import ca.uhn.fhir.rest.param.QuantityAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.ResourceParameter;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.server.Constants;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.IDynamicSearchResourceProvider;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.SearchParameterMap;
import ca.uhn.fhir.util.ReflectionUtil;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.DateUtils;
import org.hl7.fhir.instance.model.IBaseResource;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IMetaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodUtil {
    private static final String LABEL = "label=\"";
    private static final Logger ourLog = LoggerFactory.getLogger(MethodUtil.class);
    private static final String SCHEME = "scheme=\"";

    static void addTagsToPostOrPut(IResource resource, BaseHttpClientInvocation retVal) {
        TagList list = (TagList)resource.getResourceMetadata().get(ResourceMetadataKeyEnum.TAG_LIST);
        if (list != null) {
            for (Tag tag : list) {
                if (!StringUtils.isNotBlank((CharSequence)tag.getTerm())) continue;
                retVal.addHeader("Category", tag.toHeaderValue());
            }
        }
    }

    public static HttpGetClientInvocation createConformanceInvocation() {
        return new HttpGetClientInvocation("metadata");
    }

    public static HttpPostClientInvocation createCreateInvocation(IResource theResource, FhirContext theContext) {
        return MethodUtil.createCreateInvocation(theResource, null, null, theContext);
    }

    public static HttpPostClientInvocation createCreateInvocation(IResource theResource, String theResourceBody, String theId, FhirContext theContext) {
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theResource);
        String resourceName = def.getName();
        StringBuilder urlExtension = new StringBuilder();
        urlExtension.append(resourceName);
        if (StringUtils.isNotBlank((CharSequence)theId)) {
            urlExtension.append('/');
            urlExtension.append(theId);
        }
        HttpPostClientInvocation retVal = StringUtils.isBlank((CharSequence)theResourceBody) ? new HttpPostClientInvocation(theContext, theResource, urlExtension.toString()) : new HttpPostClientInvocation(theContext, theResourceBody, false, urlExtension.toString());
        MethodUtil.addTagsToPostOrPut(theResource, retVal);
        return retVal;
    }

    public static HttpPostClientInvocation createCreateInvocation(IResource theResource, String theResourceBody, String theId, FhirContext theContext, Map<String, List<String>> theIfNoneExistParams) {
        HttpPostClientInvocation retVal = MethodUtil.createCreateInvocation(theResource, theResourceBody, theId, theContext);
        retVal.setIfNoneExistParams((Map)theIfNoneExistParams);
        return retVal;
    }

    public static HttpPostClientInvocation createCreateInvocation(IResource theResource, String theResourceBody, String theId, FhirContext theContext, String theIfNoneExistUrl) {
        HttpPostClientInvocation retVal = MethodUtil.createCreateInvocation(theResource, theResourceBody, theId, theContext);
        retVal.setIfNoneExistString(theIfNoneExistUrl);
        return retVal;
    }

    public static HttpPutClientInvocation createUpdateInvocation(IResource theResource, String theResourceBody, IdDt theId, FhirContext theContext) {
        String resourceName = theContext.getResourceDefinition(theResource).getName();
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(resourceName);
        urlBuilder.append('/');
        urlBuilder.append(theId.getIdPart());
        String urlExtension = urlBuilder.toString();
        HttpPutClientInvocation retVal = StringUtils.isBlank((CharSequence)theResourceBody) ? new HttpPutClientInvocation(theContext, theResource, urlExtension) : new HttpPutClientInvocation(theContext, theResourceBody, false, urlExtension);
        if (theId.hasVersionIdPart()) {
            if (theContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU1)) {
                retVal.addHeader("If-Match", '\"' + theId.getVersionIdPart() + '\"');
            } else {
                String versionId = theId.getVersionIdPart();
                if (StringUtils.isNotBlank((CharSequence)versionId)) {
                    urlBuilder.append('/');
                    urlBuilder.append("_history");
                    urlBuilder.append('/');
                    urlBuilder.append(versionId);
                    retVal.addHeader("Content-Location", urlBuilder.toString());
                }
            }
        }
        MethodUtil.addTagsToPostOrPut(theResource, retVal);
        return retVal;
    }

    public static HttpPutClientInvocation createUpdateInvocation(FhirContext theContext, IResource theResource, String theResourceBody, Map<String, List<String>> theMatchParams) {
        StringBuilder b = new StringBuilder();
        String resourceType = theContext.getResourceDefinition(theResource).getName();
        b.append(resourceType);
        boolean haveQuestionMark = false;
        for (Map.Entry<String, List<String>> nextEntry : theMatchParams.entrySet()) {
            for (String nextValue : nextEntry.getValue()) {
                b.append(haveQuestionMark ? (char)'&' : '?');
                haveQuestionMark = true;
                try {
                    b.append(URLEncoder.encode(nextEntry.getKey(), "UTF-8"));
                    b.append('=');
                    b.append(URLEncoder.encode(nextValue, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new ConfigurationException("UTF-8 not supported on this platform");
                }
            }
        }
        HttpPutClientInvocation retVal = StringUtils.isBlank((CharSequence)theResourceBody) ? new HttpPutClientInvocation(theContext, theResource, b.toString()) : new HttpPutClientInvocation(theContext, theResourceBody, false, b.toString());
        MethodUtil.addTagsToPostOrPut(theResource, retVal);
        return retVal;
    }

    public static HttpPutClientInvocation createUpdateInvocation(FhirContext theContext, IResource theResource, String theResourceBody, String theMatchUrl) {
        HttpPutClientInvocation retVal = StringUtils.isBlank((CharSequence)theResourceBody) ? new HttpPutClientInvocation(theContext, theResource, theMatchUrl) : new HttpPutClientInvocation(theContext, theResourceBody, false, theMatchUrl);
        MethodUtil.addTagsToPostOrPut(theResource, retVal);
        return retVal;
    }

    public static EncodingEnum detectEncoding(String theBody) {
        EncodingEnum retVal = MethodUtil.detectEncodingNoDefault(theBody);
        if (retVal == null) {
            retVal = EncodingEnum.XML;
        }
        return retVal;
    }

    public static EncodingEnum detectEncodingNoDefault(String theBody) {
        EncodingEnum retVal = null;
        block4: for (int i = 0; i < theBody.length() && retVal == null; ++i) {
            switch (theBody.charAt(i)) {
                case '<': {
                    retVal = EncodingEnum.XML;
                    continue block4;
                }
                case '{': {
                    retVal = EncodingEnum.JSON;
                }
            }
        }
        return retVal;
    }

    public static void extractDescription(SearchParameter theParameter, Annotation[] theAnnotations) {
        for (Annotation annotation : theAnnotations) {
            if (!(annotation instanceof Description)) continue;
            Description desc = (Description)annotation;
            if (StringUtils.isNotBlank((CharSequence)desc.formalDefinition())) {
                theParameter.setDescription(desc.formalDefinition());
                continue;
            }
            theParameter.setDescription(desc.shortDefinition());
        }
    }

    public static Integer findIdParameterIndex(Method theMethod) {
        return MethodUtil.findParamAnnotationIndex(theMethod, IdParam.class);
    }

    public static Integer findParamAnnotationIndex(Method theMethod, Class<?> toFind) {
        int paramIndex = 0;
        for (Annotation[] annotations : theMethod.getParameterAnnotations()) {
            for (int annotationIndex = 0; annotationIndex < annotations.length; ++annotationIndex) {
                Annotation nextAnnotation = annotations[annotationIndex];
                Class<?> class1 = nextAnnotation.getClass();
                if (!toFind.isAssignableFrom(class1)) continue;
                return paramIndex;
            }
            ++paramIndex;
        }
        return null;
    }

    public static Integer findTagListParameterIndex(Method theMethod) {
        return MethodUtil.findParamAnnotationIndex(theMethod, TagListParam.class);
    }

    public static Integer findConditionalOperationParameterIndex(Method theMethod) {
        return MethodUtil.findParamAnnotationIndex(theMethod, ConditionalUrlParam.class);
    }

    public static Integer findVersionIdParameterIndex(Method theMethod) {
        return MethodUtil.findParamAnnotationIndex(theMethod, VersionIdParam.class);
    }

    public static List<IParameter> getResourceParameters(FhirContext theContext, Method theMethod, Object theProvider, RestfulOperationTypeEnum theRestfulOperationTypeEnum) {
        ArrayList<IParameter> parameters = new ArrayList<IParameter>();
        Class<?>[] parameterTypes = theMethod.getParameterTypes();
        int paramIndex = 0;
        for (Annotation[] annotations : theMethod.getParameterAnnotations()) {
            IParameter param = null;
            Class<?> parameterType = parameterTypes[paramIndex];
            Class<?> outerCollectionType = null;
            Class<?> innerCollectionType = null;
            if (SearchParameterMap.class.equals(parameterType)) {
                Search searchAnnotation;
                if (theProvider instanceof IDynamicSearchResourceProvider && (searchAnnotation = theMethod.getAnnotation(Search.class)) != null && searchAnnotation.dynamic()) {
                    param = new DynamicSearchParameter((IDynamicSearchResourceProvider)theProvider);
                }
            } else if (TagList.class.isAssignableFrom(parameterType)) {
                param = new NullParameter();
            } else {
                if (Collection.class.isAssignableFrom(parameterType)) {
                    innerCollectionType = parameterType;
                    parameterType = ReflectionUtil.getGenericCollectionTypeOfMethodParameter(theMethod, paramIndex);
                }
                if (Collection.class.isAssignableFrom(parameterType)) {
                    outerCollectionType = innerCollectionType;
                    innerCollectionType = parameterType;
                    parameterType = ReflectionUtil.getGenericCollectionTypeOfMethodParameter(theMethod, paramIndex);
                }
                if (Collection.class.isAssignableFrom(parameterType)) {
                    throw new ConfigurationException("Argument #" + paramIndex + " of Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is of an invalid generic type (can not be a collection of a collection of a collection)");
                }
            }
            if (parameterType.equals(HttpServletRequest.class) || parameterType.equals(ServletRequest.class)) {
                param = new ServletRequestParameter();
            } else if (parameterType.equals(HttpServletResponse.class) || parameterType.equals(ServletResponse.class)) {
                param = new ServletResponseParameter();
            } else if (parameterType.equals(RestfulServer.NarrativeModeEnum.class)) {
                param = new NarrativeModeParameter();
            } else {
                for (int i = 0; i < annotations.length && param == null; ++i) {
                    SearchParameter parameter;
                    Annotation nextAnnotation = annotations[i];
                    if (nextAnnotation instanceof RequiredParam) {
                        parameter = new SearchParameter();
                        parameter.setName(((RequiredParam)nextAnnotation).name());
                        parameter.setRequired(true);
                        parameter.setDeclaredTypes(((RequiredParam)nextAnnotation).targetTypes());
                        parameter.setCompositeTypes(((RequiredParam)nextAnnotation).compositeTypes());
                        parameter.setChainlists(((RequiredParam)nextAnnotation).chainWhitelist(), ((RequiredParam)nextAnnotation).chainBlacklist());
                        parameter.setType(parameterType, innerCollectionType, outerCollectionType);
                        MethodUtil.extractDescription(parameter, annotations);
                        param = parameter;
                        continue;
                    }
                    if (nextAnnotation instanceof OptionalParam) {
                        parameter = new SearchParameter();
                        parameter.setName(((OptionalParam)nextAnnotation).name());
                        parameter.setRequired(false);
                        parameter.setDeclaredTypes(((OptionalParam)nextAnnotation).targetTypes());
                        parameter.setCompositeTypes(((OptionalParam)nextAnnotation).compositeTypes());
                        parameter.setChainlists(((OptionalParam)nextAnnotation).chainWhitelist(), ((OptionalParam)nextAnnotation).chainBlacklist());
                        parameter.setType(parameterType, innerCollectionType, outerCollectionType);
                        MethodUtil.extractDescription(parameter, annotations);
                        param = parameter;
                        continue;
                    }
                    if (nextAnnotation instanceof IncludeParam) {
                        Class specType;
                        Class<? extends Collection> instantiableCollectionType;
                        if (parameterType == String.class) {
                            instantiableCollectionType = null;
                            specType = String.class;
                        } else {
                            if (parameterType != Include.class && parameterType != PathSpecification.class || innerCollectionType == null || outerCollectionType != null) {
                                throw new ConfigurationException("Method '" + theMethod.getName() + "' is annotated with @" + IncludeParam.class.getSimpleName() + " but has a type other than Collection<" + Include.class.getSimpleName() + ">");
                            }
                            instantiableCollectionType = CollectionBinder.getInstantiableCollectionType(innerCollectionType, "Method '" + theMethod.getName() + "'");
                            specType = parameterType;
                        }
                        param = new IncludeParameter((IncludeParam)nextAnnotation, instantiableCollectionType, specType);
                        continue;
                    }
                    if (nextAnnotation instanceof ResourceParam) {
                        if (!IResource.class.isAssignableFrom(parameterType)) {
                            throw new ConfigurationException("Method '" + theMethod.getName() + "' is annotated with @" + ResourceParam.class.getSimpleName() + " but has a type that is not an implemtation of " + IResource.class.getCanonicalName());
                        }
                        param = new ResourceParameter(parameterType);
                        continue;
                    }
                    if (nextAnnotation instanceof IdParam || nextAnnotation instanceof VersionIdParam) {
                        param = new NullParameter();
                        continue;
                    }
                    if (nextAnnotation instanceof ServerBase) {
                        param = new ServerBaseParamBinder();
                        continue;
                    }
                    if (nextAnnotation instanceof Since) {
                        param = new SinceParameter();
                        continue;
                    }
                    if (nextAnnotation instanceof Count) {
                        param = new CountParameter();
                        continue;
                    }
                    if (nextAnnotation instanceof Sort) {
                        param = new SortParameter();
                        continue;
                    }
                    if (nextAnnotation instanceof TransactionParam) {
                        param = new TransactionParamBinder(theContext);
                        continue;
                    }
                    if (nextAnnotation instanceof ConditionalUrlParam) {
                        param = new ConditionalParamBinder(theRestfulOperationTypeEnum);
                        continue;
                    }
                    if (!(nextAnnotation instanceof OperationParam)) continue;
                    Operation op = theMethod.getAnnotation(Operation.class);
                    param = new OperationParamBinder(op.name(), (OperationParam)nextAnnotation);
                }
            }
            if (param == null) {
                throw new ConfigurationException("Parameter #" + (paramIndex + 1) + "/" + parameterTypes.length + " of method '" + theMethod.getName() + "' on type '" + theMethod.getDeclaringClass().getCanonicalName() + "' has no recognized FHIR interface parameter annotations. Don't know how to handle this parameter");
            }
            param.initializeTypes(theMethod, outerCollectionType, innerCollectionType, parameterType);
            parameters.add(param);
            ++paramIndex;
        }
        return parameters;
    }

    public static void parseClientRequestResourceHeaders(IdDt theRequestedId, Map<String, List<String>> theHeaders, IBaseResource resource) {
        List<String> categoryHeaders;
        String headerValue;
        List<String> clHeaders;
        List<String> lmHeaders = theHeaders.get(Constants.HEADER_LAST_MODIFIED_LOWERCASE);
        if (lmHeaders != null && lmHeaders.size() > 0 && StringUtils.isNotBlank((CharSequence)lmHeaders.get(0))) {
            String headerValue2 = lmHeaders.get(0);
            try {
                Date headerDateValue = DateUtils.parseDate((String)headerValue2);
                if (resource instanceof IResource) {
                    InstantDt lmValue = new InstantDt(headerDateValue);
                    ((IResource)resource).getResourceMetadata().put(ResourceMetadataKeyEnum.UPDATED, lmValue);
                } else if (resource instanceof IAnyResource) {
                    ((IAnyResource)resource).getMeta().setLastUpdated(headerDateValue);
                }
            }
            catch (Exception e) {
                ourLog.warn("Unable to parse date string '{}'. Error is: {}", (Object)headerValue2, (Object)e.toString());
            }
        }
        if ((clHeaders = theHeaders.get(Constants.HEADER_CONTENT_LOCATION_LC)) != null && clHeaders.size() > 0 && StringUtils.isNotBlank((CharSequence)clHeaders.get(0)) && StringUtils.isNotBlank((CharSequence)(headerValue = clHeaders.get(0)))) {
            new IdDt(headerValue).applyTo(resource);
        }
        IdDt existing = IdDt.of(resource);
        List<String> eTagHeaders = theHeaders.get(Constants.HEADER_ETAG_LC);
        String eTagVersion = null;
        if (eTagHeaders != null && eTagHeaders.size() > 0) {
            eTagVersion = MethodUtil.parseETagValue(eTagHeaders.get(0));
        }
        if (StringUtils.isNotBlank(eTagVersion)) {
            if (existing == null || existing.isEmpty()) {
                if (theRequestedId != null) {
                    theRequestedId.withVersion(eTagVersion).applyTo(resource);
                }
            } else if (!existing.hasVersionIdPart()) {
                existing.withVersion(eTagVersion).applyTo(resource);
            }
        } else if ((existing == null || existing.isEmpty()) && theRequestedId != null) {
            theRequestedId.applyTo(resource);
        }
        if ((categoryHeaders = theHeaders.get(Constants.HEADER_CATEGORY_LC)) != null && categoryHeaders.size() > 0 && StringUtils.isNotBlank((CharSequence)categoryHeaders.get(0))) {
            TagList tagList = new TagList();
            for (String header : categoryHeaders) {
                MethodUtil.parseTagValue(tagList, header);
            }
            if (resource instanceof IResource) {
                ResourceMetadataKeyEnum.TAG_LIST.put((IResource)resource, tagList);
            } else if (resource instanceof IAnyResource) {
                IMetaType meta = ((IAnyResource)resource).getMeta();
                for (Tag next : tagList) {
                    meta.addTag().setSystem(next.getScheme()).setCode(next.getTerm()).setDisplay(next.getLabel());
                }
            }
        }
    }

    public static String parseETagValue(String value) {
        String eTagVersion = (value = value.trim()).length() > 1 ? (value.charAt(value.length() - 1) == '\"' ? (value.charAt(0) == '\"' ? value.substring(1, value.length() - 1) : (value.length() > 3 && value.charAt(0) == 'W' && value.charAt(1) == '/' && value.charAt(2) == '\"' ? value.substring(3, value.length() - 1) : value)) : value) : value;
        return eTagVersion;
    }

    public static IQueryParameterAnd<?> parseQueryParams(RuntimeSearchParam theParamDef, String theUnqualifiedParamName, List<QualifiedParamList> theParameters) {
        QueryParameterAndBinder binder = null;
        switch (theParamDef.getParamType()) {
            case COMPOSITE: {
                throw new UnsupportedOperationException();
            }
            case DATE: {
                binder = new QueryParameterAndBinder((Class<? extends IQueryParameterAnd<?>>)DateAndListParam.class, Collections.<Class<IQueryParameterType>>emptyList());
                break;
            }
            case NUMBER: {
                binder = new QueryParameterAndBinder((Class<? extends IQueryParameterAnd<?>>)NumberAndListParam.class, Collections.<Class<IQueryParameterType>>emptyList());
                break;
            }
            case QUANTITY: {
                binder = new QueryParameterAndBinder((Class<? extends IQueryParameterAnd<?>>)QuantityAndListParam.class, Collections.<Class<IQueryParameterType>>emptyList());
                break;
            }
            case REFERENCE: {
                binder = new QueryParameterAndBinder((Class<? extends IQueryParameterAnd<?>>)ReferenceAndListParam.class, Collections.<Class<IQueryParameterType>>emptyList());
                break;
            }
            case STRING: {
                binder = new QueryParameterAndBinder((Class<? extends IQueryParameterAnd<?>>)StringAndListParam.class, Collections.<Class<IQueryParameterType>>emptyList());
                break;
            }
            case TOKEN: {
                binder = new QueryParameterAndBinder((Class<? extends IQueryParameterAnd<?>>)TokenAndListParam.class, Collections.<Class<IQueryParameterType>>emptyList());
            }
        }
        return binder.parse(theUnqualifiedParamName, (List)theParameters);
    }

    public static void parseTagValue(TagList tagList, String nextTagComplete) {
        StringBuilder next = new StringBuilder(nextTagComplete);
        MethodUtil.parseTagValue(tagList, nextTagComplete, next);
    }

    private static void parseTagValue(TagList theTagList, String theCompleteHeaderValue, StringBuilder theBuffer) {
        int deleteTo;
        int firstSemicolon = theBuffer.indexOf(";");
        if (firstSemicolon == -1) {
            firstSemicolon = theBuffer.indexOf(",");
            if (firstSemicolon == -1) {
                firstSemicolon = theBuffer.length();
                deleteTo = theBuffer.length();
            } else {
                deleteTo = firstSemicolon;
            }
        } else {
            deleteTo = firstSemicolon + 1;
        }
        String term = theBuffer.substring(0, firstSemicolon);
        String scheme = null;
        String label = null;
        if (StringUtils.isBlank((CharSequence)term)) {
            return;
        }
        theBuffer.delete(0, deleteTo);
        while (theBuffer.length() > 0 && theBuffer.charAt(0) == ' ') {
            theBuffer.deleteCharAt(0);
        }
        while (theBuffer.length() > 0) {
            int closeIdx;
            boolean foundSomething = false;
            if (theBuffer.length() > SCHEME.length() && theBuffer.substring(0, SCHEME.length()).equals(SCHEME)) {
                closeIdx = theBuffer.indexOf("\"", SCHEME.length());
                scheme = theBuffer.substring(SCHEME.length(), closeIdx);
                theBuffer.delete(0, closeIdx + 1);
                foundSomething = true;
            }
            if (theBuffer.length() > LABEL.length() && theBuffer.substring(0, LABEL.length()).equals(LABEL)) {
                closeIdx = theBuffer.indexOf("\"", LABEL.length());
                label = theBuffer.substring(LABEL.length(), closeIdx);
                theBuffer.delete(0, closeIdx + 1);
                foundSomething = true;
            }
            while (theBuffer.length() > 0 && (theBuffer.charAt(0) == ' ' || theBuffer.charAt(0) == ';')) {
                theBuffer.deleteCharAt(0);
            }
            if (foundSomething) continue;
            break;
        }
        if (theBuffer.length() > 0 && theBuffer.charAt(0) == ',') {
            theBuffer.deleteCharAt(0);
            while (theBuffer.length() > 0 && theBuffer.charAt(0) == ' ') {
                theBuffer.deleteCharAt(0);
            }
            theTagList.add(new Tag(scheme, term, label));
            MethodUtil.parseTagValue(theTagList, theCompleteHeaderValue, theBuffer);
        } else {
            theTagList.add(new Tag(scheme, term, label));
        }
        if (theBuffer.length() > 0) {
            ourLog.warn("Ignoring extra text at the end of Category tag '" + theBuffer.toString() + "' - Complete tag value was: " + theCompleteHeaderValue);
        }
    }

    public static MethodOutcome process2xxResponse(FhirContext theContext, String theResourceName, int theResponseStatusCode, String theResponseMimeType, Reader theResponseReader, Map<String, List<String>> theHeaders) {
        List<String> clh;
        ArrayList<String> locationHeaders = new ArrayList<String>();
        List<String> lh = theHeaders.get(Constants.HEADER_LOCATION_LC);
        if (lh != null) {
            locationHeaders.addAll(lh);
        }
        if ((clh = theHeaders.get(Constants.HEADER_CONTENT_LOCATION_LC)) != null) {
            locationHeaders.addAll(clh);
        }
        MethodOutcome retVal = new MethodOutcome();
        if (locationHeaders != null && locationHeaders.size() > 0) {
            String locationHeader = (String)locationHeaders.get(0);
            BaseOutcomeReturningMethodBinding.parseContentLocation(retVal, theResourceName, locationHeader);
        }
        if (theResponseStatusCode != 204) {
            EncodingEnum ct = EncodingEnum.forContentType(theResponseMimeType);
            if (ct != null) {
                IParser parser;
                IResource outcome;
                PushbackReader reader = new PushbackReader(theResponseReader);
                try {
                    int firstByte = reader.read();
                    if (firstByte == -1) {
                        BaseOutcomeReturningMethodBinding.ourLog.debug("No content in response, not going to read");
                        reader = null;
                    } else {
                        reader.unread(firstByte);
                    }
                }
                catch (IOException e) {
                    BaseOutcomeReturningMethodBinding.ourLog.debug("No content in response, not going to read", (Throwable)e);
                    reader = null;
                }
                if (reader != null && (outcome = (parser = ct.newParser(theContext)).parseResource(reader)) instanceof BaseOperationOutcome) {
                    retVal.setOperationOutcome((BaseOperationOutcome)outcome);
                }
            } else {
                BaseOutcomeReturningMethodBinding.ourLog.debug("Ignoring response content of type: {}", (Object)theResponseMimeType);
            }
        }
        return retVal;
    }

    public static IQueryParameterOr<?> singleton(final IQueryParameterType theParam) {
        return new IQueryParameterOr<IQueryParameterType>(){

            @Override
            public List<IQueryParameterType> getValuesAsQueryTokens() {
                return Collections.singletonList(theParam);
            }

            @Override
            public void setValuesAsQueryTokens(QualifiedParamList theParameters) {
                if (theParameters.isEmpty()) {
                    return;
                }
                if (theParameters.size() > 1) {
                    throw new IllegalArgumentException("Type " + theParam.getClass().getCanonicalName() + " does not support multiple values");
                }
                theParam.setValueAsQueryToken(theParameters.getQualifier(), (String)theParameters.get(0));
            }
        };
    }
}

