/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.Request;
import ca.uhn.fhir.rest.method.ServletResponseParameter;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NarrativeModeParameter
implements IParameter {
    private static final Logger ourLog = LoggerFactory.getLogger(ServletResponseParameter.class);

    NarrativeModeParameter() {
    }

    @Override
    public void translateClientArgumentIntoQueryArgument(FhirContext theContext, Object theSourceClientArgument, Map<String, List<String>> theTargetQueryArguments, IBaseResource theTargetResource) throws InternalErrorException {
        if (theSourceClientArgument != null) {
            RestfulServer.NarrativeModeEnum n = (RestfulServer.NarrativeModeEnum)((Object)theSourceClientArgument);
            theTargetQueryArguments.put("_narrative", Collections.singletonList(n.name().toLowerCase()));
        }
    }

    @Override
    public Object translateQueryParametersIntoServerArgument(Request theRequest, Object theRequestContents) throws InternalErrorException, InvalidRequestException {
        String val = theRequest.getServletRequest().getParameter("_narrative");
        if (val != null) {
            try {
                return RestfulServer.NarrativeModeEnum.valueOfCaseInsensitive(val);
            }
            catch (IllegalArgumentException e) {
                ourLog.debug("Invalid {} parameger: {}", (Object)"_narrative", (Object)val);
                return null;
            }
        }
        return null;
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
    }
}

