/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.dstu.valueset.RestfulOperationSystemEnum;
import ca.uhn.fhir.model.dstu.valueset.RestfulOperationTypeEnum;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.method.HttpGetClientInvocation;
import ca.uhn.fhir.rest.method.HttpPostClientInvocation;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.Request;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.IBundleProvider;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.util.FhirTerser;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.IBase;
import org.hl7.fhir.instance.model.IBaseResource;
import org.hl7.fhir.instance.model.IPrimitiveType;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationMethodBinding
extends BaseResourceReturningMethodBinding {
    private static final Logger ourLog = LoggerFactory.getLogger(OperationMethodBinding.class);
    private final boolean myHttpGetPermitted;
    private final Integer myIdParamIndex;
    private final String myName;
    private final BaseResourceReturningMethodBinding.ReturnTypeEnum myReturnType;

    public OperationMethodBinding(Class<?> theReturnResourceType, Class<? extends IBaseResource> theReturnTypeFromRp, Method theMethod, FhirContext theContext, Object theProvider, Operation theAnnotation) {
        super(theReturnResourceType, theMethod, theContext, theProvider);
        this.myHttpGetPermitted = theAnnotation.idempotent();
        this.myIdParamIndex = MethodUtil.findIdParameterIndex(theMethod);
        String name = theAnnotation.name();
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' on type " + theMethod.getDeclaringClass().getName() + " is annotated with @" + Operation.class.getSimpleName() + " but this annotation has no name defined");
        }
        if (!name.startsWith("$")) {
            name = "$" + name;
        }
        this.myName = name;
        if (theContext.getVersion().getVersion().isEquivalentTo(FhirVersionEnum.DSTU1)) {
            throw new ConfigurationException("@" + Operation.class.getSimpleName() + " methods are not supported on servers for FHIR version " + theContext.getVersion().getVersion().name());
        }
        if (theReturnTypeFromRp != null) {
            this.setResourceName(theContext.getResourceDefinition(theReturnTypeFromRp).getName());
        } else if (!Modifier.isAbstract(theAnnotation.type().getModifiers())) {
            this.setResourceName(theContext.getResourceDefinition(theAnnotation.type()).getName());
        } else {
            this.setResourceName(null);
        }
        if (theMethod.getReturnType().isAssignableFrom(Bundle.class)) {
            throw new ConfigurationException("Can not return a DSTU1 bundle from an @" + Operation.class.getSimpleName() + " method. Found in method " + theMethod.getName() + " defined in type " + theMethod.getDeclaringClass().getName());
        }
        this.myReturnType = theMethod.getReturnType().equals(IBundleProvider.class) ? BaseResourceReturningMethodBinding.ReturnTypeEnum.BUNDLE : BaseResourceReturningMethodBinding.ReturnTypeEnum.RESOURCE;
    }

    @Override
    public RestfulOperationTypeEnum getResourceOperationType() {
        return null;
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return null;
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return this.myReturnType;
    }

    @Override
    public RestfulOperationSystemEnum getSystemOperationType() {
        return null;
    }

    @Override
    public boolean incomingServerRequestMatchesMethod(Request theRequest) {
        if (this.getResourceName() == null ? StringUtils.isNotBlank((CharSequence)theRequest.getResourceName()) : !this.getResourceName().equals(theRequest.getResourceName())) {
            return false;
        }
        boolean requestHasId = theRequest.getId() != null;
        if (requestHasId != (this.myIdParamIndex != null)) {
            return false;
        }
        return this.myName.equals(theRequest.getOperation());
    }

    @Override
    public BaseHttpClientInvocation invokeClient(Object[] theArgs) throws InternalErrorException {
        String id = null;
        if (this.myIdParamIndex != null) {
            IdDt idDt = (IdDt)theArgs[this.myIdParamIndex];
            id = idDt.getValue();
        }
        IBaseParameters parameters = (IBaseParameters)this.getContext().getResourceDefinition("Parameters").newInstance();
        if (theArgs != null) {
            for (int idx = 0; idx < theArgs.length; ++idx) {
                IParameter nextParam = this.getParameters().get(idx);
                nextParam.translateClientArgumentIntoQueryArgument(this.getContext(), theArgs[idx], null, parameters);
            }
        }
        return OperationMethodBinding.createOperationInvocation(this.getContext(), this.getResourceName(), id, this.myName, parameters, false);
    }

    @Override
    public Object invokeServer(RequestDetails theRequest, Object[] theMethodParams) throws BaseServerResponseException {
        if (theRequest.getRequestType() != RequestTypeEnum.POST) {
            if (theRequest.getRequestType() == RequestTypeEnum.GET) {
                if (!this.myHttpGetPermitted) {
                    String message = this.getContext().getLocalizer().getMessage(OperationMethodBinding.class, "methodNotSupported", new Object[]{theRequest.getRequestType(), RequestTypeEnum.POST.name()});
                    throw new MethodNotAllowedException(message, RequestTypeEnum.POST);
                }
            } else {
                if (!this.myHttpGetPermitted) {
                    String message = this.getContext().getLocalizer().getMessage(OperationMethodBinding.class, "methodNotSupported", new Object[]{theRequest.getRequestType(), RequestTypeEnum.POST.name()});
                    throw new MethodNotAllowedException(message, RequestTypeEnum.POST);
                }
                String message = this.getContext().getLocalizer().getMessage(OperationMethodBinding.class, "methodNotSupported", new Object[]{theRequest.getRequestType(), RequestTypeEnum.GET.name(), RequestTypeEnum.POST.name()});
                throw new MethodNotAllowedException(message, RequestTypeEnum.GET, RequestTypeEnum.POST);
            }
        }
        if (this.myIdParamIndex != null) {
            theMethodParams[this.myIdParamIndex.intValue()] = theRequest.getId();
        }
        Object response = this.invokeServerMethod(theMethodParams);
        IBundleProvider retVal = OperationMethodBinding.toResourceList(response);
        return retVal;
    }

    @Override
    protected Object parseRequestObject(Request theRequest) throws IOException {
        EncodingEnum encoding = RestfulServerUtils.determineRequestEncoding(theRequest);
        IParser parser = encoding.newParser(this.getContext());
        BufferedReader requestReader = theRequest.getServletRequest().getReader();
        if (theRequest.getRequestType() == RequestTypeEnum.GET) {
            return null;
        }
        Class wantedResourceType = this.getContext().getResourceDefinition("Parameters").getImplementingClass();
        return parser.parseResource(wantedResourceType, requestReader);
    }

    public static BaseHttpClientInvocation createOperationInvocation(FhirContext theContext, String theResourceName, String theId, String theOperationName, IBaseParameters theInput, boolean theUseHttpGet) {
        StringBuilder b = new StringBuilder();
        if (theResourceName != null) {
            b.append(theResourceName);
            if (StringUtils.isNotBlank((CharSequence)theId)) {
                b.append('/');
                b.append(theId);
            }
        }
        if (b.length() > 0) {
            b.append('/');
        }
        if (!theOperationName.startsWith("$")) {
            b.append("$");
        }
        b.append(theOperationName);
        if (!theUseHttpGet) {
            return new HttpPostClientInvocation(theContext, theInput, b.toString());
        }
        FhirTerser t = theContext.newTerser();
        List<Object> parameters = t.getValues(theInput, "Parameters.parameter");
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        for (Object nextParameter : parameters) {
            IBaseDatatype value;
            StringDt nextNameDt = (StringDt)t.getSingleValueOrNull((IBase)nextParameter, "name");
            if (nextNameDt == null || nextNameDt.isEmpty()) {
                ourLog.warn("Ignoring input parameter with no value in Parameters.parameter.name in operation client invocation");
                continue;
            }
            String nextName = (String)nextNameDt.getValue();
            if (!params.containsKey(nextName)) {
                params.put(nextName, new ArrayList());
            }
            if ((value = (IBaseDatatype)t.getSingleValueOrNull((IBase)nextParameter, "value[x]")) == null) continue;
            if (!(value instanceof IPrimitiveType)) {
                throw new IllegalArgumentException("Can not invoke operation as HTTP GET when it has parameters with a composite (non priitive) datatype as the value. Found value: " + value.getClass().getName());
            }
            IPrimitiveType primitive = (IPrimitiveType)value;
            ((List)params.get(nextName)).add(primitive.getValueAsString());
        }
        return new HttpGetClientInvocation(params, b.toString());
    }
}

