/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeChildPrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.HapiLocalizer;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.Request;
import ca.uhn.fhir.rest.param.CollectionBinder;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.IBase;
import org.hl7.fhir.instance.model.IBaseResource;
import org.hl7.fhir.instance.model.IPrimitiveType;
import org.hl7.fhir.instance.model.api.IBaseDatatype;

class OperationParamBinder
implements IParameter {
    private final String myName;
    private Class<?> myParameterType;
    private Class<? extends Collection> myInnerCollectionType;
    private final String myOperationName;

    OperationParamBinder(String theOperationName, OperationParam theAnnotation) {
        this.myOperationName = theOperationName;
        this.myName = theAnnotation.name();
    }

    @Override
    public void translateClientArgumentIntoQueryArgument(FhirContext theContext, Object theSourceClientArgument, Map<String, List<String>> theTargetQueryArguments, IBaseResource theTargetResource) throws InternalErrorException {
        assert (theTargetResource != null);
        if (theSourceClientArgument == null) {
            return;
        }
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theTargetResource);
        BaseRuntimeChildDefinition paramChild = def.getChildByName("parameter");
        BaseRuntimeElementCompositeDefinition paramChildElem = (BaseRuntimeElementCompositeDefinition)paramChild.getChildByName("parameter");
        this.addClientParameter(theSourceClientArgument, theTargetResource, paramChild, paramChildElem);
    }

    private void addClientParameter(Object theSourceClientArgument, IBaseResource theTargetResource, BaseRuntimeChildDefinition paramChild, BaseRuntimeElementCompositeDefinition<?> paramChildElem) {
        if (theSourceClientArgument instanceof IBaseResource) {
            IBase parameter = this.createParameterRepetition(theTargetResource, paramChild, paramChildElem);
            paramChildElem.getChildByName("resource").getMutator().addValue(parameter, (IBaseResource)theSourceClientArgument);
        } else if (theSourceClientArgument instanceof IBaseDatatype) {
            IBase parameter = this.createParameterRepetition(theTargetResource, paramChild, paramChildElem);
            paramChildElem.getChildByName("value[x]").getMutator().addValue(parameter, (IBaseDatatype)theSourceClientArgument);
        } else if (theSourceClientArgument instanceof Collection) {
            Collection collection = (Collection)theSourceClientArgument;
            for (Object next : collection) {
                this.addClientParameter(next, theTargetResource, paramChild, paramChildElem);
            }
        } else {
            throw new IllegalArgumentException("Don't know how to handle value of type " + theSourceClientArgument.getClass() + " for paramater " + this.myName);
        }
    }

    private IBase createParameterRepetition(IBaseResource theTargetResource, BaseRuntimeChildDefinition paramChild, BaseRuntimeElementCompositeDefinition<?> paramChildElem) {
        Object parameter = paramChildElem.newInstance();
        paramChild.getMutator().addValue(theTargetResource, (IBase)parameter);
        paramChildElem.getChildByName("name").getMutator().addValue(parameter, new StringDt(this.myName));
        return parameter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object translateQueryParametersIntoServerArgument(Request theRequest, Object theRequestContents) throws InternalErrorException, InvalidRequestException {
        ArrayList<Object> matchingParamValues;
        block13: {
            block12: {
                matchingParamValues = new ArrayList<Object>();
                if (theRequest.getRequestType() != RequestTypeEnum.GET) break block12;
                String[] paramValues = theRequest.getParameters().get(this.myName);
                if (paramValues != null && paramValues.length > 0) {
                    if (!IPrimitiveType.class.isAssignableFrom(this.myParameterType)) {
                        HapiLocalizer localizer = theRequest.getServer().getFhirContext().getLocalizer();
                        String msg = localizer.getMessage(OperationParamBinder.class, "urlParamNotPrimitive", this.myOperationName, this.myName);
                        throw new MethodNotAllowedException(msg, RequestTypeEnum.POST);
                    }
                    for (String nextValue : paramValues) {
                        FhirContext ctx = theRequest.getServer().getFhirContext();
                        RuntimePrimitiveDatatypeDefinition def = (RuntimePrimitiveDatatypeDefinition)ctx.getElementDefinition(this.myParameterType);
                        IPrimitiveType instance = (IPrimitiveType)def.newInstance();
                        instance.setValueAsString(nextValue);
                        matchingParamValues.add(instance);
                    }
                }
                break block13;
            }
            if (theRequestContents == null) {
                return null;
            }
            FhirContext ctx = theRequest.getServer().getFhirContext();
            IBaseResource requestContents = (IBaseResource)theRequestContents;
            RuntimeResourceDefinition def = ctx.getResourceDefinition(requestContents);
            BaseRuntimeChildDefinition paramChild = def.getChildByName("parameter");
            BaseRuntimeElementCompositeDefinition paramChildElem = (BaseRuntimeElementCompositeDefinition)paramChild.getChildByName("parameter");
            RuntimeChildPrimitiveDatatypeDefinition nameChild = (RuntimeChildPrimitiveDatatypeDefinition)paramChildElem.getChildByName("name");
            BaseRuntimeChildDefinition valueChild = paramChildElem.getChildByName("value[x]");
            BaseRuntimeChildDefinition resourceChild = paramChildElem.getChildByName("resource");
            BaseRuntimeChildDefinition.IAccessor paramChildAccessor = paramChild.getAccessor();
            List<IBase> values = paramChildAccessor.getValues(requestContents);
            for (IBase nextParameter : values) {
                IPrimitiveType nextName;
                List<IBase> nextNames = nameChild.getAccessor().getValues(nextParameter);
                if (nextNames == null || nextNames.size() <= 0 || !this.myName.equals((nextName = (IPrimitiveType)nextNames.get(0)).getValueAsString())) continue;
                if (this.myParameterType.isAssignableFrom(nextParameter.getClass())) {
                    matchingParamValues.add(nextParameter);
                    continue;
                }
                List<IBase> paramValues = valueChild.getAccessor().getValues(nextParameter);
                List<IBase> paramResources = resourceChild.getAccessor().getValues(nextParameter);
                if (paramValues != null && paramValues.size() > 0) {
                    this.tryToAddValues(paramValues, matchingParamValues);
                    continue;
                }
                if (paramResources == null || paramResources.size() <= 0) continue;
                this.tryToAddValues(paramResources, matchingParamValues);
            }
        }
        if (matchingParamValues.isEmpty()) {
            return null;
        }
        if (this.myInnerCollectionType == null) {
            return matchingParamValues.get(0);
        }
        try {
            Collection retVal = this.myInnerCollectionType.newInstance();
            retVal.addAll(matchingParamValues);
            return retVal;
        }
        catch (InstantiationException e) {
            throw new InternalErrorException("Failed to instantiate " + this.myInnerCollectionType, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new InternalErrorException("Failed to instantiate " + this.myInnerCollectionType, (Throwable)e);
        }
    }

    private void tryToAddValues(List<IBase> theParamValues, List<Object> theMatchingParamValues) {
        for (IBase nextValue : theParamValues) {
            if (nextValue == null) continue;
            if (!this.myParameterType.isAssignableFrom(nextValue.getClass())) {
                throw new InvalidRequestException("Request has parameter " + this.myName + " of type " + nextValue.getClass().getSimpleName() + " but method expects type " + this.myParameterType.getSimpleName());
            }
            theMatchingParamValues.add(nextValue);
        }
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        this.myParameterType = theParameterType;
        if (theInnerCollectionType != null) {
            this.myInnerCollectionType = CollectionBinder.getInstantiableCollectionType(theInnerCollectionType, this.myName);
        }
    }
}

