/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class QualifiedParamList
extends ArrayList<String> {
    private static final long serialVersionUID = 1L;
    private String myQualifier;

    public QualifiedParamList() {
    }

    public QualifiedParamList(int theCapacity) {
        super(theCapacity);
    }

    public QualifiedParamList(IQueryParameterOr<?> theNextOr) {
        for (IQueryParameterType next : theNextOr.getValuesAsQueryTokens()) {
            if (this.myQualifier == null) {
                this.myQualifier = next.getQueryParameterQualifier();
            }
            this.add(next.getValueAsQueryToken());
        }
    }

    public String getQualifier() {
        return this.myQualifier;
    }

    public void setQualifier(String theQualifier) {
        this.myQualifier = theQualifier;
    }

    public static QualifiedParamList singleton(String theParamValue) {
        return QualifiedParamList.singleton(null, theParamValue);
    }

    public static QualifiedParamList singleton(String theQualifier, String theParamValue) {
        QualifiedParamList retVal = new QualifiedParamList(1);
        retVal.setQualifier(theQualifier);
        retVal.add(theParamValue);
        return retVal;
    }

    public static QualifiedParamList splitQueryStringByCommasIgnoreEscape(String theQualifier, String theParams) {
        QualifiedParamList retVal = new QualifiedParamList();
        retVal.setQualifier(theQualifier);
        StringTokenizer tok = new StringTokenizer(theParams, ",");
        String prev = null;
        while (tok.hasMoreElements()) {
            String str = tok.nextToken();
            if (prev != null && prev.endsWith("\\")) {
                int idx = retVal.size() - 1;
                String existing = (String)retVal.get(idx);
                retVal.set(idx, existing.substring(0, existing.length() - 1) + "," + str);
            } else {
                retVal.add(str);
            }
            prev = str;
        }
        return retVal;
    }
}

