/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.dstu.valueset.RestfulOperationSystemEnum;
import ca.uhn.fhir.model.dstu.valueset.RestfulOperationTypeEnum;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.method.HttpGetClientInvocation;
import ca.uhn.fhir.rest.method.IClientResponseHandlerHandlesBinary;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.Request;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.Constants;
import ca.uhn.fhir.rest.server.ETagSupportEnum;
import ca.uhn.fhir.rest.server.IBundleProvider;
import ca.uhn.fhir.rest.server.SimpleBundleProvider;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.NotModifiedException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.IBaseResource;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadMethodBinding
extends BaseResourceReturningMethodBinding
implements IClientResponseHandlerHandlesBinary<Object> {
    private static final Logger ourLog = LoggerFactory.getLogger(ReadMethodBinding.class);
    private Integer myIdIndex;
    private boolean mySupportsVersion;
    private Integer myVersionIdIndex;

    public ReadMethodBinding(Class<? extends IBaseResource> theAnnotatedResourceType, Method theMethod, FhirContext theContext, Object theProvider) {
        super(theAnnotatedResourceType, theMethod, theContext, theProvider);
        Validate.notNull((Object)theMethod, (String)"Method must not be null", (Object[])new Object[0]);
        Integer idIndex = MethodUtil.findIdParameterIndex(theMethod);
        Integer versionIdIndex = MethodUtil.findVersionIdParameterIndex(theMethod);
        this.mySupportsVersion = theMethod.getAnnotation(Read.class).version();
        this.myIdIndex = idIndex;
        this.myVersionIdIndex = versionIdIndex;
        if (this.myIdIndex == null) {
            throw new ConfigurationException("@" + Read.class.getSimpleName() + " method " + theMethod.getName() + " on type \"" + theMethod.getDeclaringClass().getName() + "\" does not have a parameter annotated with @" + IdParam.class.getSimpleName());
        }
        Class<?>[] parameterTypes = theMethod.getParameterTypes();
        if (!IdDt.class.equals(parameterTypes[this.myIdIndex])) {
            throw new ConfigurationException("ID parameter must be of type: " + IdDt.class.getCanonicalName() + " - Found: " + parameterTypes[this.myIdIndex]);
        }
        if (this.myVersionIdIndex != null && !IdDt.class.equals(parameterTypes[this.myVersionIdIndex])) {
            throw new ConfigurationException("Version ID parameter must be of type: " + IdDt.class.getCanonicalName() + " - Found: " + parameterTypes[this.myVersionIdIndex]);
        }
    }

    @Override
    public List<Class<?>> getAllowableParamAnnotations() {
        ArrayList retVal = new ArrayList();
        retVal.add(IdParam.class);
        return retVal;
    }

    @Override
    public RestfulOperationTypeEnum getResourceOperationType() {
        return this.isVread() ? RestfulOperationTypeEnum.VREAD : RestfulOperationTypeEnum.READ;
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return BaseResourceReturningMethodBinding.ReturnTypeEnum.RESOURCE;
    }

    @Override
    public RestfulOperationSystemEnum getSystemOperationType() {
        return null;
    }

    @Override
    public boolean incomingServerRequestMatchesMethod(Request theRequest) {
        if (!theRequest.getResourceName().equals(this.getResourceName())) {
            return false;
        }
        for (String next : theRequest.getParameters().keySet()) {
            if (ALLOWED_PARAMS.contains(next)) continue;
            return false;
        }
        if (theRequest.getId() == null) {
            return false;
        }
        if (!this.mySupportsVersion && theRequest.getId().hasVersionIdPart()) {
            return false;
        }
        if (theRequest.getRequestType() != RequestTypeEnum.GET) {
            ourLog.trace("Method {} doesn't match because request type is not GET: {}", (Object)theRequest.getId(), (Object)theRequest.getRequestType());
            return false;
        }
        if ("_history".equals(theRequest.getOperation())) {
            if (!this.mySupportsVersion && this.myVersionIdIndex == null) {
                return false;
            }
            if (!theRequest.getId().hasVersionIdPart()) {
                return false;
            }
        } else if (!StringUtils.isBlank((CharSequence)theRequest.getOperation())) {
            return false;
        }
        return true;
    }

    @Override
    public HttpGetClientInvocation invokeClient(Object[] theArgs) {
        HttpGetClientInvocation retVal;
        IdDt id = (IdDt)theArgs[this.myIdIndex];
        if (this.myVersionIdIndex == null) {
            String resourceName = this.getResourceName();
            retVal = id.hasVersionIdPart() ? ReadMethodBinding.createVReadInvocation(new IdDt(resourceName, id.getIdPart(), id.getVersionIdPart()), resourceName) : ReadMethodBinding.createReadInvocation(id, resourceName);
        } else {
            IdDt vid = (IdDt)theArgs[this.myVersionIdIndex];
            String resourceName = this.getResourceName();
            retVal = ReadMethodBinding.createVReadInvocation(new IdDt(resourceName, id.getIdPart(), vid.getVersionIdPart()), resourceName);
        }
        for (int idx = 0; idx < theArgs.length; ++idx) {
            IParameter nextParam = this.getParameters().get(idx);
            nextParam.translateClientArgumentIntoQueryArgument(this.getContext(), theArgs[idx], null, null);
        }
        return retVal;
    }

    @Override
    public Object invokeClient(String theResponseMimeType, InputStream theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws IOException, BaseServerResponseException {
        byte[] contents = IOUtils.toByteArray((InputStream)theResponseReader);
        IBaseBinary resource = (IBaseBinary)this.getContext().getResourceDefinition("Binary").newInstance();
        resource.setContentType(theResponseMimeType);
        resource.setContent(contents);
        switch (this.getMethodReturnType()) {
            case BUNDLE: {
                return Bundle.withSingleResource((IResource)((Object)resource));
            }
            case LIST_OF_RESOURCES: {
                return Collections.singletonList(resource);
            }
            case RESOURCE: {
                return resource;
            }
            case BUNDLE_PROVIDER: {
                return new SimpleBundleProvider((IResource)((Object)resource));
            }
        }
        throw new IllegalStateException("" + (Object)((Object)this.getMethodReturnType()));
    }

    @Override
    public IBundleProvider invokeServer(RequestDetails theRequest, Object[] theMethodParams) throws InvalidRequestException, InternalErrorException {
        theMethodParams[this.myIdIndex.intValue()] = theRequest.getId();
        if (this.myVersionIdIndex != null) {
            theMethodParams[this.myVersionIdIndex.intValue()] = new IdDt(theRequest.getId().getVersionIdPart());
        }
        Object response = this.invokeServerMethod(theMethodParams);
        IBundleProvider retVal = ReadMethodBinding.toResourceList(response);
        if (theRequest.getServer().getETagSupport() == ETagSupportEnum.ENABLED) {
            String ifNoneMatch = ((Request)theRequest).getServletRequest().getHeader(Constants.HEADER_IF_NONE_MATCH_LC);
            if (retVal.size() == 1 && StringUtils.isNotBlank((CharSequence)ifNoneMatch)) {
                List<IResource> responseResources = retVal.getResources(0, 1);
                IResource responseResource = responseResources.get(0);
                ifNoneMatch = MethodUtil.parseETagValue(ifNoneMatch);
                if (responseResource.getId() != null && responseResource.getId().hasVersionIdPart() && responseResource.getId().getVersionIdPart().equals(ifNoneMatch)) {
                    ourLog.debug("Returning HTTP 301 because request specified {}={}", (Object)"If-None-Match", (Object)ifNoneMatch);
                    throw new NotModifiedException("Not Modified");
                }
            }
        }
        return retVal;
    }

    @Override
    public boolean isBinary() {
        return "Binary".equals(this.getResourceName());
    }

    public boolean isVread() {
        return this.mySupportsVersion || this.myVersionIdIndex != null;
    }

    public static HttpGetClientInvocation createAbsoluteReadInvocation(IdDt theId) {
        return new HttpGetClientInvocation(theId.toVersionless().getValue());
    }

    public static HttpGetClientInvocation createAbsoluteVReadInvocation(IdDt theId) {
        return new HttpGetClientInvocation(theId.getValue());
    }

    public static HttpGetClientInvocation createReadInvocation(IdDt theId, String theResourceName) {
        return new HttpGetClientInvocation(new IdDt(theResourceName, theId.getIdPart()).getValue());
    }

    public static HttpGetClientInvocation createVReadInvocation(IdDt theId, String theResourceName) {
        return new HttpGetClientInvocation(new IdDt(theResourceName, theId.getIdPart(), theId.getVersionIdPart()).getValue());
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return null;
    }
}

