/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.method.RequestDetails;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Request
extends RequestDetails {
    private String myFhirServerBase;
    private String myOperation;
    private boolean myRespondGzip;
    private String mySecondaryOperation;
    private HttpServletRequest myServletRequest;
    private HttpServletResponse myServletResponse;
    private Map<String, List<String>> myUnqualifiedToQualifiedNames;

    public String getFhirServerBase() {
        return this.myFhirServerBase;
    }

    public String getOperation() {
        return this.myOperation;
    }

    public String getSecondaryOperation() {
        return this.mySecondaryOperation;
    }

    public HttpServletRequest getServletRequest() {
        return this.myServletRequest;
    }

    public HttpServletResponse getServletResponse() {
        return this.myServletResponse;
    }

    public Map<String, List<String>> getUnqualifiedToQualifiedNames() {
        return this.myUnqualifiedToQualifiedNames;
    }

    public boolean isRespondGzip() {
        return this.myRespondGzip;
    }

    public void setFhirServerBase(String theFhirServerBase) {
        this.myFhirServerBase = theFhirServerBase;
    }

    public void setOperation(String theOperation) {
        this.myOperation = theOperation;
    }

    @Override
    public void setParameters(Map<String, String[]> theParams) {
        super.setParameters(theParams);
        block0: for (String next : theParams.keySet()) {
            for (int i = 0; i < next.length(); ++i) {
                String unqualified;
                List<String> list;
                char nextChar = next.charAt(i);
                if (nextChar != ':' && nextChar != '.') continue;
                if (this.myUnqualifiedToQualifiedNames == null) {
                    this.myUnqualifiedToQualifiedNames = new HashMap<String, List<String>>();
                }
                if ((list = this.myUnqualifiedToQualifiedNames.get(unqualified = next.substring(0, i))) == null) {
                    list = new ArrayList<String>(4);
                    this.myUnqualifiedToQualifiedNames.put(unqualified, list);
                }
                list.add(next);
                continue block0;
            }
        }
        if (this.myUnqualifiedToQualifiedNames == null) {
            this.myUnqualifiedToQualifiedNames = Collections.emptyMap();
        }
    }

    public void setRespondGzip(boolean theRespondGzip) {
        this.myRespondGzip = theRespondGzip;
    }

    public void setSecondaryOperation(String theSecondaryOperation) {
        this.mySecondaryOperation = theSecondaryOperation;
    }

    public void setServletRequest(HttpServletRequest theRequest) {
        this.myServletRequest = theRequest;
    }

    public void setServletResponse(HttpServletResponse theServletResponse) {
        this.myServletResponse = theServletResponse;
    }

    public static Request withResourceAndParams(String theResourceName, RequestTypeEnum theRequestType, Set<String> theParamNames) {
        Request retVal = new Request();
        retVal.setResourceName(theResourceName);
        retVal.setRequestType(theRequestType);
        HashMap<String, String[]> paramNames = new HashMap<String, String[]>();
        for (String next : theParamNames) {
            paramNames.put(next, new String[0]);
        }
        retVal.setParameters(paramNames);
        return retVal;
    }
}

