/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.annotation.Since;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.Request;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.IBaseResource;

class SinceParameter
implements IParameter {
    private Class<?> myType;

    SinceParameter() {
    }

    @Override
    public void translateClientArgumentIntoQueryArgument(FhirContext theContext, Object theSourceClientArgument, Map<String, List<String>> theTargetQueryArguments, IBaseResource theTargetResource) throws InternalErrorException {
        InstantDt since;
        if (theSourceClientArgument != null && !(since = ParameterUtil.toInstant(theSourceClientArgument)).isEmpty()) {
            theTargetQueryArguments.put("_since", Collections.singletonList(since.getValueAsString()));
        }
    }

    @Override
    public Object translateQueryParametersIntoServerArgument(Request theRequest, Object theRequestContents) throws InternalErrorException, InvalidRequestException {
        String[] sinceParams = theRequest.getParameters().remove("_since");
        if (sinceParams != null && sinceParams.length > 0 && StringUtils.isNotBlank((CharSequence)sinceParams[0])) {
            try {
                InstantDt since = new InstantDt(sinceParams[0]);
                return ParameterUtil.fromInstant(this.myType, since);
            }
            catch (DataFormatException e) {
                throw new InvalidRequestException("Invalid _since value: " + sinceParams[0]);
            }
        }
        return ParameterUtil.fromInstant(this.myType, null);
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        if (theOuterCollectionType != null) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' in type '" + "' is annotated with @" + Since.class.getName() + " but can not be of collection type");
        }
        if (!ParameterUtil.getBindableInstantTypes().contains(theParameterType)) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' in type '" + "' is annotated with @" + Since.class.getName() + " but is an invalid type, must be one of: " + ParameterUtil.getBindableInstantTypes());
        }
        this.myType = theParameterType;
    }
}

