/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.Request;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.IBaseResource;

public class SortParameter
implements IParameter {
    @Override
    public void translateClientArgumentIntoQueryArgument(FhirContext theContext, Object theSourceClientArgument, Map<String, List<String>> theTargetQueryArguments, IBaseResource theTargetResource) throws InternalErrorException {
        for (SortSpec ss = (SortSpec)theSourceClientArgument; ss != null; ss = ss.getChain()) {
            String name = ss.getOrder() == null ? "_sort" : (ss.getOrder() == SortOrderEnum.ASC ? "_sort:asc" : "_sort:desc");
            if (ss.getParamName() == null) continue;
            if (!theTargetQueryArguments.containsKey(name)) {
                theTargetQueryArguments.put(name, new ArrayList());
            }
            theTargetQueryArguments.get(name).add(ss.getParamName());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object translateQueryParametersIntoServerArgument(Request theRequest, Object theRequestContents) throws InternalErrorException, InvalidRequestException {
        if (!(theRequest.getParameters().containsKey("_sort") || theRequest.getParameters().containsKey("_sort:asc") || theRequest.getParameters().containsKey("_sort:desc"))) {
            return null;
        }
        SortSpec outerSpec = null;
        SortSpec innerSpec = null;
        for (String nextParamName : theRequest.getParameters().keySet()) {
            String[] values;
            SortOrderEnum order;
            if ("_sort".equals(nextParamName)) {
                order = null;
            } else if ("_sort:asc".equals(nextParamName)) {
                order = SortOrderEnum.ASC;
            } else {
                if (!"_sort:desc".equals(nextParamName)) continue;
                order = SortOrderEnum.DESC;
            }
            if ((values = theRequest.getParameters().get(nextParamName)) == null) continue;
            for (String nextValue : values) {
                void var7_7;
                if (!StringUtils.isNotBlank((CharSequence)nextValue)) continue;
                SortSpec spec = new SortSpec();
                spec.setOrder((SortOrderEnum)var7_7);
                spec.setParamName(nextValue);
                if (innerSpec == null) {
                    outerSpec = spec;
                    innerSpec = spec;
                    continue;
                }
                innerSpec.setChain(spec);
                innerSpec = spec;
            }
        }
        return outerSpec;
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        if (theOuterCollectionType != null || theInnerCollectionType != null) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is annotated with @" + Sort.class.getName() + " but can not be of collection type");
        }
        if (!theParameterType.equals(SortSpec.class)) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is annotated with @" + Sort.class.getName() + " but is an invalid type, must be: " + SortSpec.class.getCanonicalName());
        }
    }
}

