/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.dstu.valueset.RestfulOperationSystemEnum;
import ca.uhn.fhir.model.dstu.valueset.RestfulOperationTypeEnum;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.annotation.Update;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.method.BaseOutcomeReturningMethodBindingWithResourceParam;
import ca.uhn.fhir.rest.method.HttpPutClientInvocation;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.Request;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

class UpdateMethodBinding
extends BaseOutcomeReturningMethodBindingWithResourceParam {
    private Integer myIdParameterIndex;

    public UpdateMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod, theContext, Update.class, theProvider);
        this.myIdParameterIndex = MethodUtil.findIdParameterIndex(theMethod);
    }

    @Override
    public RestfulOperationTypeEnum getResourceOperationType() {
        return RestfulOperationTypeEnum.UPDATE;
    }

    @Override
    public RestfulOperationSystemEnum getSystemOperationType() {
        return null;
    }

    @Override
    protected void addParametersForServerRequest(Request theRequest, Object[] theParams) {
        String locationHeader = theRequest.getServletRequest().getHeader("Content-Location");
        IdDt id = theRequest.getId();
        if (StringUtils.isNotBlank((CharSequence)locationHeader) && StringUtils.isNotBlank((CharSequence)(id = new IdDt(locationHeader)).getResourceType()) && !this.getResourceName().equals(id.getResourceType())) {
            throw new InvalidRequestException("Attempting to update '" + this.getResourceName() + "' but content-location header specifies different resource type '" + id.getResourceType() + "' - header value: " + locationHeader);
        }
        String ifMatchValue = theRequest.getServletRequest().getHeader("If-Match");
        if (StringUtils.isNotBlank((CharSequence)ifMatchValue)) {
            ifMatchValue = MethodUtil.parseETagValue(ifMatchValue);
            if (id != null && !id.hasVersionIdPart()) {
                id = id.withVersion(ifMatchValue);
            }
        }
        if (theRequest.getId() != null && !theRequest.getId().hasVersionIdPart() && id != null && id.hasVersionIdPart()) {
            theRequest.getId().setValue(id.getValue());
        }
        if (StringUtils.isNotBlank((CharSequence)locationHeader)) {
            MethodOutcome mo = new MethodOutcome();
            UpdateMethodBinding.parseContentLocation(mo, this.getResourceName(), locationHeader);
            if (mo.getId() == null || mo.getId().isEmpty()) {
                throw new InvalidRequestException("Invalid Content-Location header for resource " + this.getResourceName() + ": " + locationHeader);
            }
        }
        if (this.myIdParameterIndex != null) {
            theParams[this.myIdParameterIndex.intValue()] = theRequest.getId();
        }
    }

    @Override
    protected BaseHttpClientInvocation createClientInvocation(Object[] theArgs, IResource theResource) {
        IdDt idDt = (IdDt)theArgs[this.myIdParameterIndex];
        if (idDt == null) {
            throw new NullPointerException("ID can not be null");
        }
        FhirContext context = this.getContext();
        HttpPutClientInvocation retVal = MethodUtil.createUpdateInvocation(theResource, null, idDt, context);
        for (int idx = 0; idx < theArgs.length; ++idx) {
            IParameter nextParam = this.getParameters().get(idx);
            nextParam.translateClientArgumentIntoQueryArgument(this.getContext(), theArgs[idx], null, null);
        }
        return retVal;
    }

    @Override
    protected Set<RequestTypeEnum> provideAllowableRequestTypes() {
        return Collections.singleton(RequestTypeEnum.PUT);
    }

    @Override
    protected String getMatchingOperation() {
        return null;
    }
}

