/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.model.api.IQueryParameterType;

abstract class BaseParam
implements IQueryParameterType {
    private Boolean myMissing;

    BaseParam() {
    }

    @Override
    public Boolean getMissing() {
        return this.myMissing;
    }

    @Override
    public final String getQueryParameterQualifier() {
        if (this.myMissing != null) {
            return ":missing";
        }
        return this.doGetQueryParameterQualifier();
    }

    abstract String doGetQueryParameterQualifier();

    abstract String doGetValueAsQueryToken();

    @Override
    public final String getValueAsQueryToken() {
        if (this.myMissing != null) {
            return this.myMissing != false ? "true" : "false";
        }
        return this.doGetValueAsQueryToken();
    }

    @Override
    public void setMissing(Boolean theMissing) {
        this.myMissing = theMissing;
    }

    @Override
    public final void setValueAsQueryToken(String theQualifier, String theValue) {
        if (":missing".equals(theQualifier)) {
            this.myMissing = "true".equals(theValue);
            this.doSetValueAsQueryToken(null, null);
        } else {
            this.myMissing = null;
            this.doSetValueAsQueryToken(theQualifier, theValue);
        }
    }

    abstract void doSetValueAsQueryToken(String var1, String var2);

    static class ComposableBaseParam
    extends BaseParam {
        ComposableBaseParam() {
        }

        @Override
        String doGetQueryParameterQualifier() {
            return null;
        }

        @Override
        String doGetValueAsQueryToken() {
            return null;
        }

        @Override
        void doSetValueAsQueryToken(String theQualifier, String theValue) {
        }
    }
}

