/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.dstu.valueset.QuantityCompararatorEnum;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.method.QualifiedParamList;
import ca.uhn.fhir.rest.param.BaseParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DateParam
extends DateTimeDt
implements IQueryParameterType,
IQueryParameterOr<DateParam> {
    private QuantityCompararatorEnum myComparator;
    private BaseParam myBase = new BaseParam.ComposableBaseParam();

    public DateParam() {
    }

    public DateParam(QuantityCompararatorEnum theComparator, Date theDate) {
        this.myComparator = theComparator;
        this.setValue(theDate);
    }

    public DateParam(QuantityCompararatorEnum theComparator, String theDate) {
        this.myComparator = theComparator;
        this.setValueAsString(theDate);
    }

    public DateParam(String theString) {
        this.setValueAsQueryToken(null, theString);
    }

    public QuantityCompararatorEnum getComparator() {
        return this.myComparator;
    }

    @Override
    public String getQueryParameterQualifier() {
        if (this.myBase.getMissing() != null) {
            return this.myBase.getQueryParameterQualifier();
        }
        return null;
    }

    @Override
    public String getValueAsQueryToken() {
        if (this.myBase.getMissing() != null) {
            return this.myBase.getValueAsQueryToken();
        }
        if (this.myComparator != null && this.getValue() != null) {
            return this.myComparator.getCode() + this.getValueAsString();
        }
        if (this.myComparator == null && this.getValue() != null) {
            return this.getValueAsString();
        }
        return "";
    }

    @Override
    public List<DateParam> getValuesAsQueryTokens() {
        return Collections.singletonList(this);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    public void setComparator(QuantityCompararatorEnum theComparator) {
        this.myComparator = theComparator;
    }

    @Override
    public void setValueAsQueryToken(String theQualifier, String theValue) {
        this.myBase.setValueAsQueryToken(theQualifier, theValue);
        if (this.myBase.getMissing() != null) {
            this.setValue(null);
            this.myComparator = null;
            return;
        }
        if (theValue.length() < 2) {
            throw new DataFormatException("Invalid qualified date parameter: " + theValue);
        }
        char char0 = theValue.charAt(0);
        char char1 = theValue.charAt(1);
        if (Character.isDigit(char0)) {
            this.setValueAsString(theValue);
        } else {
            String comparatorString;
            QuantityCompararatorEnum comparator;
            int dateStart = 2;
            if (Character.isDigit(char1)) {
                dateStart = 1;
            }
            if ((comparator = QuantityCompararatorEnum.VALUESET_BINDER.fromCodeString(comparatorString = theValue.substring(0, dateStart))) == null) {
                throw new DataFormatException("Invalid date qualifier: " + comparatorString);
            }
            String dateString = theValue.substring(dateStart);
            this.setValueAsString(dateString);
            this.setComparator(comparator);
        }
    }

    @Override
    public void setValuesAsQueryTokens(QualifiedParamList theParameters) {
        this.myBase.setMissing(null);
        this.myComparator = null;
        this.setValueAsString(null);
        if (theParameters.size() == 1) {
            this.setValueAsString((String)theParameters.get(0));
        } else if (theParameters.size() > 1) {
            throw new InvalidRequestException("This server does not support multi-valued dates for this paramater: " + theParameters);
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName());
        b.append("[");
        if (this.myComparator != null) {
            b.append(this.myComparator.getCode());
        }
        b.append(this.getValueAsString());
        if (this.myBase.getMissing() != null) {
            b.append(" missing=").append(this.myBase.getMissing());
        }
        b.append("]");
        return b.toString();
    }

    public InstantDt getValueAsInstantDt() {
        return new InstantDt((Date)this.getValue());
    }

    public DateTimeDt getValueAsDateTimeDt() {
        return new DateTimeDt(this.getValueAsString());
    }

    @Override
    public Boolean getMissing() {
        return this.myBase.getMissing();
    }

    @Override
    public void setMissing(Boolean theMissing) {
        this.myBase.setMissing(theMissing);
    }
}

