/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.dstu.valueset.QuantityCompararatorEnum;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.method.QualifiedParamList;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DateRangeParam
implements IQueryParameterAnd<DateParam> {
    private DateParam myLowerBound;
    private DateParam myUpperBound;

    public DateRangeParam() {
    }

    public DateRangeParam(Date theLowerBound, Date theUpperBound) {
        this.setRangeFromDatesInclusive(theLowerBound, theUpperBound);
    }

    public DateRangeParam(DateParam theDateParam) {
        if (theDateParam == null) {
            throw new NullPointerException("theDateParam can not be null");
        }
        if (theDateParam.isEmpty()) {
            throw new IllegalArgumentException("theDateParam can not be empty");
        }
        if (theDateParam.getComparator() == null) {
            this.setRangeFromDatesInclusive(theDateParam.getValueAsString(), theDateParam.getValueAsString());
        } else {
            switch (theDateParam.getComparator()) {
                case GREATERTHAN: 
                case GREATERTHAN_OR_EQUALS: {
                    this.myLowerBound = theDateParam;
                    this.myUpperBound = null;
                    break;
                }
                case LESSTHAN: 
                case LESSTHAN_OR_EQUALS: {
                    this.myLowerBound = null;
                    this.myUpperBound = theDateParam;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown comparator:" + (Object)((Object)theDateParam.getComparator()) + ". This is a bug.");
                }
            }
        }
        this.validateAndThrowDataFormatExceptionIfInvalid();
    }

    public DateRangeParam(String theLowerBound, String theUpperBound) {
        this.setRangeFromDatesInclusive(theLowerBound, theUpperBound);
    }

    public DateParam getLowerBound() {
        return this.myLowerBound;
    }

    public Date getLowerBoundAsInstant() {
        if (this.myLowerBound == null) {
            return null;
        }
        Date retVal = (Date)this.myLowerBound.getValue();
        if (this.myLowerBound.getComparator() != null) {
            switch (this.myLowerBound.getComparator()) {
                case GREATERTHAN: {
                    retVal = this.myLowerBound.getPrecision().add(retVal, 1);
                    break;
                }
                case GREATERTHAN_OR_EQUALS: {
                    break;
                }
                case LESSTHAN: 
                case LESSTHAN_OR_EQUALS: {
                    throw new IllegalStateException("Unvalid lower bound comparator: " + (Object)((Object)this.myLowerBound.getComparator()));
                }
            }
        }
        return retVal;
    }

    public DateParam getUpperBound() {
        return this.myUpperBound;
    }

    public Date getUpperBoundAsInstant() {
        if (this.myUpperBound == null) {
            return null;
        }
        Date retVal = (Date)this.myUpperBound.getValue();
        if (this.myUpperBound.getComparator() != null) {
            switch (this.myUpperBound.getComparator()) {
                case LESSTHAN: {
                    retVal = new Date(retVal.getTime() - 1L);
                    break;
                }
                case LESSTHAN_OR_EQUALS: {
                    retVal = this.myUpperBound.getPrecision().add(retVal, 1);
                    retVal = new Date(retVal.getTime() - 1L);
                    break;
                }
                case GREATERTHAN: 
                case GREATERTHAN_OR_EQUALS: {
                    throw new IllegalStateException("Unvalid upper bound comparator: " + (Object)((Object)this.myUpperBound.getComparator()));
                }
            }
        }
        return retVal;
    }

    @Override
    public List<DateParam> getValuesAsQueryTokens() {
        ArrayList<DateParam> retVal = new ArrayList<DateParam>();
        if (this.myLowerBound != null && !this.myLowerBound.isEmpty()) {
            retVal.add(this.myLowerBound);
        }
        if (this.myUpperBound != null && !this.myUpperBound.isEmpty()) {
            retVal.add(this.myUpperBound);
        }
        return retVal;
    }

    public void setLowerBound(DateParam theLowerBound) {
        this.myLowerBound = theLowerBound;
        this.validateAndThrowDataFormatExceptionIfInvalid();
    }

    public void setRangeFromDatesInclusive(Date theLowerBound, Date theUpperBound) {
        this.myLowerBound = new DateParam(QuantityCompararatorEnum.GREATERTHAN_OR_EQUALS, theLowerBound);
        this.myUpperBound = new DateParam(QuantityCompararatorEnum.LESSTHAN_OR_EQUALS, theUpperBound);
        this.validateAndThrowDataFormatExceptionIfInvalid();
    }

    public void setRangeFromDatesInclusive(String theLowerBound, String theUpperBound) {
        this.myLowerBound = new DateParam(QuantityCompararatorEnum.GREATERTHAN_OR_EQUALS, theLowerBound);
        this.myUpperBound = new DateParam(QuantityCompararatorEnum.LESSTHAN_OR_EQUALS, theUpperBound);
        this.validateAndThrowDataFormatExceptionIfInvalid();
    }

    public void setUpperBound(DateParam theUpperBound) {
        this.myUpperBound = theUpperBound;
        this.validateAndThrowDataFormatExceptionIfInvalid();
    }

    @Override
    public void setValuesAsQueryTokens(List<QualifiedParamList> theParameters) throws InvalidRequestException {
        boolean haveHadUnqualifiedParameter = false;
        for (QualifiedParamList paramList : theParameters) {
            if (paramList.size() == 0) continue;
            if (paramList.size() > 1) {
                throw new InvalidRequestException("DateRange parameter does not suppport OR queries");
            }
            String param = (String)paramList.get(0);
            DateParam parsed = new DateParam();
            parsed.setValueAsQueryToken(paramList.getQualifier(), param);
            this.addParam(parsed);
            if (parsed.getComparator() != null) continue;
            if (haveHadUnqualifiedParameter) {
                throw new InvalidRequestException("Multiple date parameters with the same name and no qualifier (>, <, etc.) is not supported");
            }
            haveHadUnqualifiedParameter = true;
        }
    }

    private void addParam(DateParam theParsed) throws InvalidRequestException {
        if (theParsed.getComparator() == null) {
            if (this.myLowerBound != null || this.myUpperBound != null) {
                throw new InvalidRequestException("Can not have multiple date range parameters for the same param without a qualifier");
            }
            this.myLowerBound = new DateParam(QuantityCompararatorEnum.GREATERTHAN_OR_EQUALS, theParsed.getValueAsString());
            this.myUpperBound = new DateParam(QuantityCompararatorEnum.LESSTHAN_OR_EQUALS, theParsed.getValueAsString());
        } else {
            switch (theParsed.getComparator()) {
                case GREATERTHAN: 
                case GREATERTHAN_OR_EQUALS: {
                    if (this.myLowerBound != null) {
                        throw new InvalidRequestException("Can not have multiple date range parameters for the same param that specify a lower bound");
                    }
                    this.myLowerBound = theParsed;
                    break;
                }
                case LESSTHAN: 
                case LESSTHAN_OR_EQUALS: {
                    if (this.myUpperBound != null) {
                        throw new InvalidRequestException("Can not have multiple date range parameters for the same param that specify an upper bound");
                    }
                    this.myUpperBound = theParsed;
                    break;
                }
                default: {
                    throw new InvalidRequestException("Unknown comparator: " + (Object)((Object)theParsed.getComparator()));
                }
            }
        }
    }

    private void validateAndThrowDataFormatExceptionIfInvalid() {
        boolean haveLowerBound = this.haveLowerBound();
        boolean haveUpperBound = this.haveUpperBound();
        if (haveLowerBound && haveUpperBound && ((Date)this.myLowerBound.getValue()).after((Date)this.myUpperBound.getValue())) {
            throw new DataFormatException("Lower bound of " + this.myLowerBound.getValueAsString() + " is after upper bound of " + this.myUpperBound.getValueAsString());
        }
        if (haveLowerBound) {
            if (this.myLowerBound.getComparator() == null) {
                this.myLowerBound.setComparator(QuantityCompararatorEnum.GREATERTHAN_OR_EQUALS);
            }
            switch (this.myLowerBound.getComparator()) {
                default: {
                    break;
                }
                case LESSTHAN: 
                case LESSTHAN_OR_EQUALS: {
                    throw new DataFormatException("Lower bound comparator must be > or >=, can not be " + this.myLowerBound.getComparator().getCode());
                }
            }
        }
        if (haveUpperBound) {
            if (this.myUpperBound.getComparator() == null) {
                this.myUpperBound.setComparator(QuantityCompararatorEnum.LESSTHAN_OR_EQUALS);
            }
            switch (this.myUpperBound.getComparator()) {
                default: {
                    break;
                }
                case GREATERTHAN: 
                case GREATERTHAN_OR_EQUALS: {
                    throw new DataFormatException("Upper bound comparator must be < or <=, can not be " + this.myUpperBound.getComparator().getCode());
                }
            }
        }
    }

    private boolean haveUpperBound() {
        return this.myUpperBound != null && !this.myUpperBound.isEmpty();
    }

    private boolean haveLowerBound() {
        return this.myLowerBound != null && !this.myLowerBound.isEmpty();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName());
        b.append("[");
        if (this.haveLowerBound()) {
            if (this.myLowerBound.getComparator() != null) {
                b.append(this.myLowerBound.getComparator().getCode());
            }
            b.append(this.myLowerBound.getValueAsString());
        }
        if (this.haveUpperBound()) {
            if (this.haveLowerBound()) {
                b.append(" ");
            }
            if (this.myUpperBound.getComparator() != null) {
                b.append(this.myUpperBound.getComparator().getCode());
            }
            b.append(this.myUpperBound.getValueAsString());
        } else if (!this.haveLowerBound()) {
            b.append("empty");
        }
        b.append("]");
        return b.toString();
    }
}

