/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.dstu.valueset.QuantityCompararatorEnum;
import ca.uhn.fhir.rest.param.BaseParam;
import ca.uhn.fhir.rest.param.InternalQuantityDt;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public class NumberParam
extends BaseParam
implements IQueryParameterType {
    private InternalQuantityDt myQuantity = new InternalQuantityDt();

    public NumberParam() {
    }

    public NumberParam(String theValue) {
        this.setValueAsQueryToken(null, theValue);
    }

    @Override
    String doGetQueryParameterQualifier() {
        return null;
    }

    @Override
    String doGetValueAsQueryToken() {
        StringBuilder b = new StringBuilder();
        if (!this.myQuantity.getComparatorElement().isEmpty()) {
            b.append((String)this.myQuantity.getComparatorElement().getValue());
        }
        if (!this.myQuantity.getValueElement().isEmpty()) {
            b.append(this.myQuantity.getValueElement().toString());
        }
        return b.toString();
    }

    @Override
    void doSetValueAsQueryToken(String theQualifier, String theValue) {
        if (this.getMissing() != null && StringUtils.isBlank((CharSequence)theValue)) {
            return;
        }
        if (theValue.startsWith("<=")) {
            this.myQuantity.setComparator(QuantityCompararatorEnum.LESSTHAN_OR_EQUALS);
            this.myQuantity.setValue(new BigDecimal(theValue.substring(2)));
        } else if (theValue.startsWith("<")) {
            this.myQuantity.setComparator(QuantityCompararatorEnum.LESSTHAN);
            this.myQuantity.setValue(new BigDecimal(theValue.substring(1)));
        } else if (theValue.startsWith(">=")) {
            this.myQuantity.setComparator(QuantityCompararatorEnum.GREATERTHAN_OR_EQUALS);
            this.myQuantity.setValue(new BigDecimal(theValue.substring(2)));
        } else if (theValue.startsWith(">")) {
            this.myQuantity.setComparator(QuantityCompararatorEnum.GREATERTHAN);
            this.myQuantity.setValue(new BigDecimal(theValue.substring(1)));
        } else {
            this.myQuantity.setComparator((QuantityCompararatorEnum)null);
            this.myQuantity.setValue(new BigDecimal(theValue));
        }
    }

    public QuantityCompararatorEnum getComparator() {
        return this.myQuantity.getComparatorElement().getValueAsEnum();
    }

    public BigDecimal getValue() {
        return (BigDecimal)this.myQuantity.getValueElement().getValue();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName());
        b.append("[");
        if (!this.myQuantity.getComparatorElement().isEmpty()) {
            b.append((String)this.myQuantity.getComparatorElement().getValue());
        }
        if (!this.myQuantity.getValueElement().isEmpty()) {
            b.append(this.myQuantity.getValueElement().toString());
        }
        b.append("]");
        return b.toString();
    }
}

