/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.time.DateUtils;

public class ParameterUtil {
    private static final Set<Class<?>> BINDABLE_INTEGER_TYPES;
    private static final Set<Class<?>> BINDABLE_TIME_TYPES;

    public static int nonEscapedIndexOf(String theString, char theCharacter) {
        for (int i = 0; i < theString.length(); ++i) {
            if (theString.charAt(i) != theCharacter || i != 0 && theString.charAt(i - 1) == '\\') continue;
            return i;
        }
        return -1;
    }

    public static Object fromInstant(Class<?> theType, InstantDt theArgument) {
        if (theType.equals(InstantDt.class)) {
            if (theArgument == null) {
                return new InstantDt();
            }
            return theArgument;
        }
        if (theType.equals(Date.class)) {
            if (theArgument == null) {
                return null;
            }
            return theArgument.getValue();
        }
        if (theType.equals(Calendar.class)) {
            if (theArgument == null) {
                return null;
            }
            return DateUtils.toCalendar((Date)((Date)theArgument.getValue()));
        }
        throw new IllegalArgumentException("Invalid instant type:" + theType);
    }

    public static Object fromInteger(Class<?> theType, IntegerDt theArgument) {
        if (theType.equals(IntegerDt.class)) {
            if (theArgument == null) {
                return new IntegerDt();
            }
            return theArgument;
        }
        if (theType.equals(Integer.class)) {
            if (theArgument == null) {
                return null;
            }
            return theArgument.getValue();
        }
        throw new IllegalArgumentException("Invalid Integer type:" + theType);
    }

    public static Set<Class<?>> getBindableInstantTypes() {
        return BINDABLE_TIME_TYPES;
    }

    public static Set<Class<?>> getBindableIntegerTypes() {
        return BINDABLE_INTEGER_TYPES;
    }

    public static InstantDt toInstant(Object theArgument) {
        if (theArgument instanceof InstantDt) {
            return (InstantDt)theArgument;
        }
        if (theArgument instanceof Date) {
            return new InstantDt((Date)theArgument);
        }
        if (theArgument instanceof Calendar) {
            return new InstantDt((Calendar)theArgument);
        }
        return null;
    }

    public static IntegerDt toInteger(Object theArgument) {
        if (theArgument instanceof IntegerDt) {
            return (IntegerDt)theArgument;
        }
        if (theArgument instanceof Integer) {
            return new IntegerDt((Integer)theArgument);
        }
        return null;
    }

    static List<String> splitParameterString(String theInput, boolean theUnescapeComponents) {
        return ParameterUtil.splitParameterString(theInput, ',', theUnescapeComponents);
    }

    static List<String> splitParameterString(String theInput, char theDelimiter, boolean theUnescapeComponents) {
        ArrayList<String> retVal = new ArrayList<String>();
        if (theInput != null) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < theInput.length(); ++i) {
                char next = theInput.charAt(i);
                if (next == theDelimiter) {
                    if (i == 0) {
                        b.append(next);
                        continue;
                    }
                    char prevChar = theInput.charAt(i - 1);
                    if (prevChar == '\\') {
                        b.append(next);
                        continue;
                    }
                    if (b.length() <= 0) continue;
                    retVal.add(b.toString());
                    b.setLength(0);
                    continue;
                }
                b.append(next);
            }
            if (b.length() > 0) {
                retVal.add(b.toString());
            }
        }
        if (theUnescapeComponents) {
            for (int i = 0; i < retVal.size(); ++i) {
                retVal.set(i, ParameterUtil.unescape(retVal.get(i)));
            }
        }
        return retVal;
    }

    public static String escapeWithDefault(Object theValue) {
        if (theValue == null) {
            return "";
        }
        return ParameterUtil.escape(theValue.toString());
    }

    public static String escape(String theValue) {
        if (theValue == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < theValue.length(); ++i) {
            char next = theValue.charAt(i);
            switch (next) {
                case '$': 
                case ',': 
                case '|': {
                    b.append('\\');
                    break;
                }
            }
            b.append(next);
        }
        return b.toString();
    }

    public static String escapeAndUrlEncode(String theValue) {
        if (theValue == null) {
            return null;
        }
        try {
            return URLEncoder.encode(ParameterUtil.escape(theValue), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("UTF-8 not supported on this platform");
        }
    }

    public static String unescape(String theValue) {
        if (theValue == null) {
            return theValue;
        }
        if (theValue.indexOf(92) == -1) {
            return theValue;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < theValue.length(); ++i) {
            char next = theValue.charAt(i);
            if (next == '\\') {
                if (i == theValue.length() - 1) {
                    b.append(next);
                    continue;
                }
                switch (theValue.charAt(i + 1)) {
                    case '$': 
                    case ',': 
                    case '|': {
                        break;
                    }
                    default: {
                        b.append(next);
                        break;
                    }
                }
                continue;
            }
            b.append(next);
        }
        return b.toString();
    }

    static {
        HashSet<Class> intTypes = new HashSet<Class>();
        intTypes.add(IntegerDt.class);
        intTypes.add(Integer.class);
        BINDABLE_INTEGER_TYPES = Collections.unmodifiableSet(intTypes);
        HashSet<Class<Calendar>> timeTypes = new HashSet<Class<Calendar>>();
        timeTypes.add(InstantDt.class);
        timeTypes.add(Date.class);
        timeTypes.add(Calendar.class);
        BINDABLE_TIME_TYPES = Collections.unmodifiableSet(timeTypes);
    }
}

