/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.param.BaseParam;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.NumberParam;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.IBaseResource;

public class ReferenceParam
extends IdDt
implements IQueryParameterType {
    private String myChain;
    private BaseParam myBase = new BaseParam.ComposableBaseParam();

    public ReferenceParam() {
    }

    public ReferenceParam(String theValue) {
        this.setValueAsQueryToken(null, theValue);
    }

    public ReferenceParam(String theChain, String theValue) {
        this.setValueAsQueryToken(null, theValue);
        this.setChain(theChain);
    }

    public ReferenceParam(String theResourceType, String theChain, String theValue) {
        if (StringUtils.isNotBlank((CharSequence)theResourceType)) {
            this.setValue(theResourceType + "/" + theValue);
        } else {
            this.setValue(theValue);
        }
        this.setChain(theChain);
    }

    public String getChain() {
        return this.myChain;
    }

    @Override
    public String getQueryParameterQualifier() {
        if (this.myBase.getMissing() != null) {
            return this.myBase.getQueryParameterQualifier();
        }
        StringBuilder b = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.getResourceType())) {
            b.append(':');
            b.append(this.getResourceType());
        }
        if (StringUtils.isNotBlank((CharSequence)this.myChain)) {
            b.append('.');
            b.append(this.myChain);
        }
        if (b.length() != 0) {
            return b.toString();
        }
        return null;
    }

    @Override
    public String getValueAsQueryToken() {
        if (this.myBase.getMissing() != null) {
            return this.myBase.getValueAsQueryToken();
        }
        return this.getIdPart();
    }

    public void setChain(String theChain) {
        this.myChain = theChain;
    }

    public Class<? extends IBaseResource> getResourceType(FhirContext theCtx) {
        if (StringUtils.isBlank((CharSequence)this.getResourceType())) {
            return null;
        }
        return theCtx.getResourceDefinition(this.getResourceType()).getImplementingClass();
    }

    @Override
    public void setValueAsQueryToken(String theQualifier, String theValue) {
        this.myBase.setValueAsQueryToken(theQualifier, theValue);
        if (this.myBase.getMissing() != null) {
            this.myChain = null;
            this.setValue(null);
            return;
        }
        String q = theQualifier;
        String resourceType = null;
        if (StringUtils.isNotBlank((CharSequence)q)) {
            if (q.startsWith(":")) {
                int nextIdx = q.indexOf(46);
                if (nextIdx != -1) {
                    resourceType = q.substring(1, nextIdx);
                    this.myChain = q.substring(nextIdx + 1);
                } else {
                    resourceType = q.substring(1);
                }
            } else if (q.startsWith(".")) {
                this.myChain = q.substring(1);
            }
        }
        this.setValue(theValue);
        if (StringUtils.isNotBlank(resourceType) && StringUtils.isBlank((CharSequence)this.getResourceType())) {
            this.setValue(resourceType + '/' + theValue);
        }
    }

    public TokenParam toTokenParam() {
        TokenParam retVal = new TokenParam();
        retVal.setValueAsQueryToken(null, this.getValueAsQueryToken());
        return retVal;
    }

    public DateParam toDateParam() {
        DateParam retVal = new DateParam();
        retVal.setValueAsQueryToken(null, this.getValueAsQueryToken());
        return retVal;
    }

    public StringParam toStringParam() {
        StringParam retVal = new StringParam();
        retVal.setValueAsQueryToken(null, this.getValueAsQueryToken());
        return retVal;
    }

    public NumberParam toNumberParam() {
        NumberParam retVal = new NumberParam();
        retVal.setValueAsQueryToken(null, this.getValueAsQueryToken());
        return retVal;
    }

    public QuantityParam toQuantityParam() {
        QuantityParam retVal = new QuantityParam();
        retVal.setValueAsQueryToken(null, this.getValueAsQueryToken());
        return retVal;
    }

    @Override
    public Boolean getMissing() {
        return this.myBase.getMissing();
    }

    @Override
    public void setMissing(Boolean theMissing) {
        this.myBase.setMissing(theMissing);
    }
}

